/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.orbyfied.j8.util.StringReader;
import net.orbyfied.j8.util.math.expr.error.SyntaxError;

public class StringUtil {
    private static String formatPart(Object part, Object ... values) {
        if (part == null) {
            return null;
        }
        if (part instanceof PlacePart) {
            PlacePart pp = (PlacePart)part;
            switch (pp.type) {
                case '\u0000': {
                    if (pp.index >= values.length) {
                        return "null";
                    }
                    return Objects.toString(values[pp.index]);
                }
            }
            return null;
        }
        return Objects.toString(part);
    }

    private static PlacePart parsePlaceholder(StringReader reader) {
        int index = reader.collectInt(10);
        ArrayList data = new ArrayList();
        char type = '\u0000';
        if (reader.current() != '}') {
            throw new SyntaxError("expected '}' to close pattern placeholder");
        }
        reader.next();
        return new PlacePart(index, type, data.toArray());
    }

    public static String format(String format, Object ... values) {
        return StringUtil.pattern(format).format(values);
    }

    public static FormatPattern pattern(String str) {
        char c;
        FormatPattern pattern = new FormatPattern();
        StringBuilder buf = new StringBuilder();
        StringReader reader = new StringReader(str);
        while ((c = reader.current()) != '\uffff') {
            if (c == '\\') {
                buf.append(reader.next());
                reader.next();
                continue;
            }
            if (c == '{') {
                pattern.parts.add(buf);
                buf = new StringBuilder();
                reader.next();
                PlacePart part = StringUtil.parsePlaceholder(reader);
                pattern.parts.add(part);
                continue;
            }
            buf.append(c);
            reader.next();
        }
        pattern.parts.add(buf);
        return pattern;
    }

    public static String extendTail(String str, int targetLength, char ext) {
        int t = targetLength - ((String)str).length();
        if (t > 0) {
            str = (String)str + ("" + ext).repeat(t);
        }
        return str;
    }

    record PlacePart(int index, char type, Object[] data) {
    }

    public static class FormatPattern {
        final List<Object> parts = new ArrayList<Object>();

        public Object part(int i) {
            if (i < 0 || i >= this.parts.size()) {
                return null;
            }
            return this.parts.get(i);
        }

        public String string(int i, Object ... values) {
            Object part = this.parts.get(i);
            return StringUtil.formatPart(part, values);
        }

        public String format(Object ... values) {
            StringBuilder b = new StringBuilder();
            int l = this.parts.size();
            for (int i = 0; i < l; ++i) {
                Object part = this.parts.get(i);
                String fmt = StringUtil.formatPart(part, values);
                if (fmt == null) continue;
                b.append(fmt);
            }
            return b.toString();
        }
    }
}

