/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import net.orbyfied.j8.util.nbt.CompoundTagSerializer;
import org.jetbrains.annotations.NotNull;

public class CompoundObjectTag<T>
implements Tag {
    public static final String SERIALIZER_FIELD_NAME = "NBT_TAG_SERIALIZER";
    public static final String CLASS_NAME_TAG = "_class";
    public static final HashMap<Class<?>, CompoundTagSerializer<?>> LOADED_SERIALIZERS = new HashMap();
    public static final TagType<CompoundObjectTag<?>> TAG_TYPE = new TagType<CompoundObjectTag<?>>(){

        public CompoundObjectTag<?> load(DataInput input, int depth, NbtAccounter tracker) throws IOException {
            CompoundTag ctag = (CompoundTag)CompoundTag.TYPE.load(input, depth, tracker);
            return CompoundObjectTag.loadFromCompound(ctag);
        }

        public StreamTagVisitor.ValueResult parse(DataInput input, StreamTagVisitor visitor) throws IOException {
            return visitor.visitEnd();
        }

        public void skip(DataInput input, int count) throws IOException {
            for (int i = 0; i < count; ++i) {
                this.skip(input);
            }
        }

        public void skip(DataInput input) throws IOException {
            CompoundTag.TYPE.skip(input);
        }

        public String getName() {
            return CompoundTag.TYPE.getName();
        }

        public String getPrettyName() {
            return CompoundTag.TYPE.getPrettyName();
        }
    };
    T obj;

    private static CompoundTagSerializer getSerializer(Class<?> klass) {
        CompoundTagSerializer serializer = LOADED_SERIALIZERS.get(klass);
        if (serializer != null) {
            return serializer;
        }
        try {
            Field f = klass.getField(SERIALIZER_FIELD_NAME);
            f.setAccessible(true);
            serializer = (CompoundTagSerializer)f.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load serializer for: " + klass, e);
        }
        if (serializer == null) {
            throw new IllegalStateException("No serializer was provided for: " + klass);
        }
        LOADED_SERIALIZERS.put(klass, serializer);
        return serializer;
    }

    public static CompoundObjectTag<?> loadFromCompound(CompoundTag ctag) {
        try {
            Class<?> klass;
            String className = ctag.getString(CLASS_NAME_TAG);
            if ("null".equals(className)) {
                return new CompoundObjectTag<Object>(null);
            }
            try {
                klass = Class.forName(className);
            }
            catch (Exception e) {
                System.out.println("Invalid class name: " + className);
                return null;
            }
            CompoundTagSerializer serializer = CompoundObjectTag.getSerializer(klass);
            Object obj = serializer.read(ctag);
            CompoundObjectTag tag = new CompoundObjectTag(obj);
            return tag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CompoundTag saveToCompound(CompoundObjectTag<?> otag, CompoundTag ctag) {
        Object obj = otag.getObject();
        if (obj == null) {
            ctag.putString(CLASS_NAME_TAG, "null");
            return ctag;
        }
        Class<?> objKlass = obj.getClass();
        ctag.putString(CLASS_NAME_TAG, objKlass.getName());
        try {
            CompoundTagSerializer serializer = CompoundObjectTag.getSerializer(objKlass);
            serializer.write(ctag, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ctag;
    }

    public CompoundObjectTag(T obj) {
        this.obj = obj;
    }

    public Class<?> getObjectType() {
        return this.obj.getClass();
    }

    public T getObject() {
        return this.obj;
    }

    public CompoundObjectTag<T> setObject(T o) {
        this.obj = o;
        return this;
    }

    public CompoundTag writeCompoundTag(CompoundTag tag) {
        CompoundObjectTag.saveToCompound(this, tag);
        return tag;
    }

    public CompoundTag writeCompoundTag() {
        CompoundTag tag = new CompoundTag();
        CompoundObjectTag.saveToCompound(this, tag);
        return tag;
    }

    public void write(DataOutput output) throws IOException {
        Class<?> klass = this.obj.getClass();
        CompoundTag tag = new CompoundTag();
        CompoundObjectTag.saveToCompound(this, tag);
        tag.write(output);
    }

    public byte getId() {
        return 10;
    }

    @NotNull
    public TagType<?> getType() {
        return TAG_TYPE;
    }

    @NotNull
    public Tag copy() {
        return new CompoundObjectTag<T>(CompoundObjectTag.getSerializer(this.obj.getClass()).copy(this.obj));
    }

    public void accept(TagVisitor visitor) {
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull StreamTagVisitor.ValueResult accept(StreamTagVisitor visitor) {
        return visitor.visitEnd();
    }

    public String toString() {
        return this.obj.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundObjectTag that = (CompoundObjectTag)o;
        return Objects.equals(this.obj, that.obj);
    }

    public int hashCode() {
        return Objects.hash(this.obj);
    }
}

