/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.mc;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.orbyfied.j8.util.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class NmsHelper {
    private static final String VERSION = Bukkit.getServer().getClass().getName().split("\\.")[3];
    private static final String CRAFT_BUKKIT_PACKAGE = "org.bukkit.craftbukkit." + VERSION + ".";
    private static Field playerHandleField = ReflectionUtil.getDeclaredFieldSafe(NmsHelper.getCraftBukkitClass("entity.CraftEntity"), (String)"entity");
    private static Field worldHandleField = ReflectionUtil.getDeclaredFieldSafe(NmsHelper.getCraftBukkitClass("CraftWorld"), (String)"world");
    private static Field chunkHandleField = ReflectionUtil.getDeclaredFieldSafe(NmsHelper.getCraftBukkitClass("CraftChunk"), (String)"weakChunk");

    public static String getVersion() {
        return VERSION;
    }

    public static Class<?> getCraftBukkitClass(String relativeName) {
        try {
            return Class.forName(CRAFT_BUKKIT_PACKAGE + relativeName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ServerPlayer getPlayerHandle(Player player) {
        return (ServerPlayer)ReflectionUtil.queryFieldSafe((Object)player, (Field)playerHandleField);
    }

    public static ServerLevel getWorldHandle(World world) {
        return (ServerLevel)ReflectionUtil.queryFieldSafe((Object)world, (Field)worldHandleField);
    }

    public static LevelChunk getChunkHandle(Chunk chunk) {
        return (LevelChunk)((WeakReference)ReflectionUtil.queryFieldSafe((Object)chunk, (Field)chunkHandleField)).get();
    }
}

