/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.mc;

import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.orbyfied.j8.util.mc.MetaBuilder;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder<T extends ItemMeta, M extends MetaBuilder<T, M>, Self extends ItemBuilder<T, M, ?>> {
    protected Material material;
    protected int amount = 0;
    protected M meta;
    protected HashMap<Enchantment, Integer> enchantments = new HashMap();

    public static <B extends ItemMeta, A extends MetaBuilder<B, A>> ItemBuilder<B, A, ItemBuilder<B, A, ?>> create() {
        return new ItemBuilder();
    }

    public static <B extends ItemMeta, A extends MetaBuilder<B, A>> ItemBuilder<B, A, ItemBuilder<B, A, ?>> create(Material material, int amt) {
        return ((ItemBuilder)new ItemBuilder().setMaterial(material)).setAmount(amt);
    }

    public static <B extends ItemMeta, A extends MetaBuilder<B, A>> ItemBuilder<B, A, ItemBuilder<B, A, ?>> create(Material material) {
        return ItemBuilder.create(material, 1);
    }

    public static <A extends MetaBuilder<ItemMeta, A>> ItemBuilder<ItemMeta, A, ItemBuilder<ItemMeta, A, ?>> of(ItemStack stack) {
        return ((ItemBuilder)((ItemBuilder)new ItemBuilder().setMaterial(stack.getType())).setAmount(stack.getAmount())).setMeta((ItemMeta)stack.getItemMeta());
    }

    protected ItemBuilder() {
    }

    public Self update() {
        if (this.meta == null) {
            this.meta = new MetaBuilder(MetaBuilder.makeFor(this.material));
        }
        return (Self)this;
    }

    public Self setAmount(int amount) {
        this.amount = amount;
        return (Self)this;
    }

    public Self setMaterial(Material material) {
        this.material = material;
        return (Self)this;
    }

    public M meta() {
        return this.meta;
    }

    public Self meta(Consumer<M> consumer) {
        this.update();
        consumer.accept(this.meta);
        return (Self)this;
    }

    public Self meta(BiConsumer<M, T> consumer) {
        this.update();
        consumer.accept(this.meta, ((MetaBuilder)this.meta).it);
        return (Self)this;
    }

    public Self setMeta(T meta) {
        this.meta = MetaBuilder.create(meta);
        return (Self)this;
    }

    public Self add(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return (Self)this;
    }

    public Self remove(Enchantment enchantment) {
        this.enchantments.remove(enchantment);
        return (Self)this;
    }

    public boolean has(Enchantment enchantment) {
        return this.enchantments.containsKey(enchantment);
    }

    public int getLevel(Enchantment enchantment) {
        return this.enchantments.get(enchantment);
    }

    public boolean isUnsafe(Enchantment enchantment) {
        return this.enchantments.get(enchantment) > enchantment.getMaxLevel();
    }

    public ItemStack build() {
        ItemStack stack = new ItemStack(this.material != null ? this.material : Material.AIR, this.amount);
        if (this.meta != null && ((MetaBuilder)this.meta).it != null) {
            stack.setItemMeta(((MetaBuilder)this.meta).it);
        }
        stack.addUnsafeEnchantments(this.enchantments);
        return stack;
    }
}

