/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.registry;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.orbyfied.j8.registry.AutoRegister;
import net.orbyfied.j8.registry.FunctionalService;
import net.orbyfied.j8.registry.Identifiable;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.registry.MappingService;
import net.orbyfied.j8.registry.RegistryComponent;
import net.orbyfied.j8.registry.RegistryService;
import net.orbyfied.j8.util.functional.Accumulator;
import net.orbyfied.j8.util.functional.KeyProvider;
import net.orbyfied.j8.util.functional.ValueProvider;
import net.orbyfied.j8.util.ops.EntryOperation;

public class Registry<T extends Identifiable>
implements Identifiable,
Iterable<T>,
KeyProvider<Identifier>,
ValueProvider<T> {
    private final HashMap<Identifier, T> mapped = new HashMap();
    private final ArrayList<T> linear = new ArrayList();
    private final ArrayList<RegistryComponent<Registry<T>, T, ?, ?>> componentsLinear = new ArrayList();
    private final HashMap<Class<? extends RegistryComponent<Registry<T>, T, ?, ?>>, RegistryComponent<Registry<T>, T, ?, ?>> componentsMapped = new HashMap();
    private final ArrayList<RegistryService<Registry<T>, T>> servicesLinear = new ArrayList();
    private final HashMap<Class<? extends RegistryService<Registry<T>, T>>, RegistryService<Registry<T>, T>> servicesMapped = new HashMap();
    private final HashMap<Class<?>, Object> suppliersByKeyType = new HashMap();
    private final Identifier identifier;
    private final Class<T> runtimeType;
    private static final HashMap<Class<?>, BiFunction<Registry, Object, ? extends Identifiable>> fieldHandlers = new HashMap();

    public Registry(Identifier identifier, Class<?> runtimeType) {
        this.identifier = identifier;
        this.runtimeType = runtimeType;
    }

    public Registry(String identifier, Class<?> runtimeType) {
        this(Identifier.of(identifier), runtimeType);
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    public int size() {
        return this.linear.size();
    }

    public T getByIndex(int i) {
        return (T)((Identifiable)this.linear.get(i));
    }

    public T getByIdentifier(Identifier id) {
        return (T)((Identifiable)this.mapped.get(id));
    }

    public <R extends T> R getByIdentifier(String id) {
        return (R)this.getByIdentifier(Identifier.of(id));
    }

    public Registry<T> register(T item) {
        int i;
        this.mapped.put(item.getIdentifier(), item);
        this.linear.add(item);
        int l = this.componentsLinear.size();
        for (i = 0; i < l; ++i) {
            this.componentsLinear.get(i).register(item);
        }
        l = this.servicesLinear.size();
        for (i = 0; i < l; ++i) {
            RegistryService<Registry<T>, T> service = this.servicesLinear.get(i);
            if (!(service instanceof FunctionalService)) continue;
            FunctionalService fs = (FunctionalService)service;
            fs.registered(item);
        }
        return this;
    }

    public Registry<T> unregister(T item) {
        int i;
        this.mapped.remove(item.getIdentifier());
        this.linear.remove(item);
        int l = this.componentsLinear.size();
        for (i = 0; i < l; ++i) {
            this.componentsLinear.get(i).unregister(item);
        }
        l = this.servicesLinear.size();
        for (i = 0; i < l; ++i) {
            RegistryService<Registry<T>, T> service = this.servicesLinear.get(i);
            if (!(service instanceof FunctionalService)) continue;
            FunctionalService fs = (FunctionalService)service;
            fs.unregistered(item);
        }
        return this;
    }

    public Registry<T> unregister(Identifier id) {
        return this.unregister(this.getByIdentifier(id));
    }

    public Registry<T> unregister(String id) {
        return this.unregister(this.getByIdentifier(id));
    }

    public List<T> linear() {
        return Collections.unmodifiableList(this.linear);
    }

    public Map<Identifier, T> mapped() {
        return Collections.unmodifiableMap(this.mapped);
    }

    public <K, R> R getValue(K key) {
        Class<?> klass = key.getClass();
        Object o = this.suppliersByKeyType.get(klass);
        if (o == null) {
            return null;
        }
        if (o instanceof RegistryComponent) {
            RegistryComponent component = (RegistryComponent)o;
            return (R)component.getMapped(key);
        }
        if (o instanceof MappingService) {
            MappingService service = (MappingService)o;
            return (R)service.getByKey(key);
        }
        return null;
    }

    public EntryOperation<Registry<T>, Identifier, T> entry(T val) {
        return EntryOperation.builder().key((Object)val.getIdentifier()).value(val).returns((Object)this).doWith((id, t) -> this.register(t)).doWithout((id, t) -> this.unregister(t)).doGet(this::getByIdentifier).doHas((id, t) -> this.has(t)).build();
    }

    public boolean has(Identifier id) {
        return this.mapped.containsKey(id);
    }

    public boolean has(T t) {
        if (t == null) {
            return false;
        }
        T o = this.mapped.get(t.getIdentifier());
        if (o == null) {
            return false;
        }
        return t.equals(o);
    }

    public <K, V, M extends RegistryComponent<Registry<T>, T, K, V>> M getComponent(int index) {
        return (M)this.componentsLinear.get(index);
    }

    public <K, V, M extends RegistryComponent<Registry<T>, T, K, V>> M getComponent(Class<M> klass) {
        return (M)this.componentsMapped.get(klass);
    }

    public Registry<T> addComponent(RegistryComponent<Registry<T>, T, ?, ?> module) {
        Objects.requireNonNull(module, "module cannot be null");
        this.componentsLinear.add(module);
        this.componentsMapped.put(module.getClass(), module);
        this.suppliersByKeyType.put(module.getKeyType(), module);
        return this;
    }

    public Registry<T> addComponent(Function<Registry<T>, RegistryComponent<Registry<T>, T, ?, ?>> f) {
        Objects.requireNonNull(f, "function cannot be null");
        return this.addComponent(f.apply(this));
    }

    public Registry<T> addComponent(Class<? extends RegistryComponent<Registry<T>, T, ?, ?>> of) {
        try {
            Constructor<RegistryComponent<Registry<T>, T, ?, ?>> constructor = of.getConstructor(Registry.class);
            return this.addComponent(constructor.newInstance(this));
        }
        catch (Exception e) {
            throw new RuntimeException("failed to construct and register module", e);
        }
    }

    public <K, V, M extends RegistryComponent<Registry<T>, T, K, V>> Registry<T> addComponent(Class<M> of, Consumer<M> consumer) {
        try {
            Constructor<M> constructor = of.getConstructor(Registry.class);
            RegistryComponent m = (RegistryComponent)constructor.newInstance(this);
            this.addComponent(m);
            consumer.accept(m);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to construct and register module", e);
        }
        return this;
    }

    public Registry<T> removeComponent(RegistryComponent<Registry<T>, T, ?, ?> module) {
        if (module == null) {
            return this;
        }
        this.componentsMapped.remove(module.getClass(), module);
        this.componentsLinear.remove(module);
        this.suppliersByKeyType.remove(module.getKeyType(), module);
        return this;
    }

    public Registry<T> removeComponent(Class<? extends RegistryComponent<Registry<T>, T, ?, ?>> klass) {
        if (klass == null) {
            return this;
        }
        return this.removeComponent(this.componentsMapped.get(klass));
    }

    public Map<Class<? extends RegistryComponent<Registry<T>, T, ?, ?>>, RegistryComponent<Registry<T>, T, ?, ?>> getComponentsMapped() {
        return Collections.unmodifiableMap(this.componentsMapped);
    }

    public List<RegistryComponent<Registry<T>, T, ?, ?>> getComponentsLinear() {
        return Collections.unmodifiableList(this.componentsLinear);
    }

    public int getComponentsSize() {
        return this.componentsLinear.size();
    }

    public <K, V, M extends RegistryService<Registry<T>, T>> M getService(int index) {
        return (M)this.servicesLinear.get(index);
    }

    public <K, V, M extends RegistryService<Registry<T>, T>> M getService(Class<M> klass) {
        return (M)this.servicesMapped.get(klass);
    }

    public Registry<T> addService(RegistryService<Registry<T>, T> service) {
        Objects.requireNonNull(service, "service cannot be null");
        this.servicesLinear.add(service);
        this.servicesMapped.put(service.getClass(), service);
        if (service instanceof MappingService) {
            MappingService ms = (MappingService)service;
            this.suppliersByKeyType.put(ms.getKeyType(), ms);
        }
        return this;
    }

    public Registry<T> addService(Function<Registry<T>, RegistryService<Registry<T>, T>> f) {
        Objects.requireNonNull(f, "function cannot be null");
        return this.addService(f.apply(this));
    }

    public Registry<T> addService(Class<? extends RegistryService<Registry<T>, T>> of) {
        try {
            Constructor<RegistryService<Registry<T>, T>> constructor = of.getConstructor(Registry.class);
            return this.addService(constructor.newInstance(this));
        }
        catch (Exception e) {
            throw new RuntimeException("failed to construct and register service", e);
        }
    }

    public <K, V, M extends RegistryService<Registry<T>, T>> Registry<T> addService(Class<M> of, Consumer<M> consumer) {
        try {
            Constructor<M> constructor = of.getConstructor(Registry.class);
            RegistryService m = (RegistryService)constructor.newInstance(this);
            this.addService(m);
            consumer.accept(m);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to construct and register service", e);
        }
        return this;
    }

    public Registry<T> removeService(RegistryService<Registry<T>, T> service) {
        if (service == null) {
            return this;
        }
        this.servicesMapped.remove(service.getClass(), service);
        this.servicesLinear.remove(service);
        if (service instanceof MappingService) {
            MappingService ms = (MappingService)service;
            this.suppliersByKeyType.remove(ms.getKeyType(), ms);
        }
        return this;
    }

    public Registry<T> removeService(Class<? extends RegistryService<Registry<T>, T>> klass) {
        if (klass == null) {
            return this;
        }
        return this.removeService(this.servicesMapped.get(klass));
    }

    public <S> ArrayList<S> getServicesOf(Class<S> type, ArrayList<S> list) {
        for (RegistryService<Registry<T>, T> o : this.servicesLinear) {
            if (!type.isAssignableFrom(o.getClass())) continue;
            list.add(o);
        }
        return list;
    }

    public <S> ArrayList<S> getServicesOf(Class<S> type) {
        return this.getServicesOf(type, new ArrayList());
    }

    public List<RegistryService<Registry<T>, T>> getServicesLinear() {
        return Collections.unmodifiableList(this.servicesLinear);
    }

    public Map<Class<? extends RegistryService<Registry<T>, T>>, RegistryService<Registry<T>, T>> getServicesMapped() {
        return Collections.unmodifiableMap(this.servicesMapped);
    }

    public int getServicesSize() {
        return this.servicesLinear.size();
    }

    public Registry<T> autoRegisterFrom(Class<?> klass, Object ... instances) {
        try {
            for (Field field : klass.getDeclaredFields()) {
                AutoRegister ann = field.getAnnotation(AutoRegister.class);
                if (ann != null) {
                    if (!ann.allow()) continue;
                    if (ann.all()) {
                        field.setAccessible(true);
                        if (Modifier.isStatic(field.getModifiers())) {
                            if (ann.allStatic()) {
                                this.autoRegisterFrom(field.getType(), new Object[0]);
                                continue;
                            }
                            this.autoRegisterFrom(field.getType(), field.get(null));
                            continue;
                        }
                        if (ann.allStatic()) {
                            this.autoRegisterFrom(field.getType(), new Object[0]);
                            continue;
                        }
                        for (Object instance : instances) {
                            this.autoRegisterFrom(field.getType(), field.get(instance));
                        }
                        continue;
                    }
                }
                Class<?> type = field.getType();
                boolean isT = this.runtimeType.isAssignableFrom(type);
                BiFunction<Registry, Object, ? extends Identifiable> handler = fieldHandlers.get(type);
                if (!isT && handler == null) continue;
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers())) {
                    if (isT) {
                        this.register((Identifiable)field.get(null));
                        continue;
                    }
                    this.register(handler.apply(this, field.get(null)));
                    continue;
                }
                if (isT) {
                    for (Object instance : instances) {
                        this.register((Identifiable)field.get(instance));
                    }
                    continue;
                }
                for (Object instance : instances) {
                    this.register(handler.apply(this, field.get(instance)));
                }
            }
        }
        catch (Exception e) {
            System.out.println("error while auto registering for class: " + klass + " with " + instances.length + " instances provided");
            e.printStackTrace();
        }
        return this;
    }

    public void provideKeys(Accumulator<Identifier> acc) {
        for (Identifiable v : this.linear) {
            acc.add((Object)v.getIdentifier());
        }
    }

    public void provideValues(Accumulator<T> acc) {
        for (Identifiable v : this.linear) {
            acc.add((Object)v);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new RegistryIterator();
    }

    public String toString() {
        return "Registry(" + this.identifier + "): " + this.mapped;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Registry registry = (Registry)o;
        return Objects.equals(this.identifier, registry.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    static {
        fieldHandlers.put(Supplier.class, (registry, o) -> (Identifiable)((Supplier)o).get());
    }

    class RegistryIterator
    implements Iterator<T> {
        int i = 0;

        RegistryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < Registry.this.linear.size();
        }

        @Override
        public T next() {
            return (Identifiable)Registry.this.linear.get(this.i++);
        }
    }
}

