/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.orbyfied.j8.registry.MalformedIdentifierException;
import net.orbyfied.j8.util.StringReader;

public class Identifier
implements Cloneable {
    protected String namespace;
    protected String path;

    public static Identifier parse(String in, Identifier out) {
        char c;
        Objects.requireNonNull(in, "input string cannot be null");
        Objects.requireNonNull(out, "output identifier cannot be null");
        StringReader reader = new StringReader(in, 0);
        List<String> components = new ArrayList<String>();
        while ((c = reader.current()) != '\uffff' && c != '<' && c != '>') {
            components.add(reader.collect(c1 -> c1.charValue() != ':' && c1.charValue() != '<' && c1.charValue() != '>', 1));
        }
        if (components.size() < 1) {
            throw new MalformedIdentifierException(in, Identifier.class);
        }
        if (components.size() < 2) {
            String[] tmp = new String[2];
            tmp[1] = (String)components.get(0);
            tmp[0] = null;
            components = Arrays.asList(tmp);
        }
        out.namespace = (String)components.get(0);
        out.path = (String)components.get(1);
        return out;
    }

    public static Identifier of(String in) {
        return Identifier.parse(in, new Identifier());
    }

    private Identifier() {
    }

    public Identifier(String namespace, String path) {
        this.namespace = namespace;
        this.path = path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return (String)(this.namespace != null ? this.namespace + ":" : "") + this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.path);
    }

    public Identifier clone() {
        try {
            return (Identifier)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

