/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.event.util;

import net.orbyfied.j8.event.BusEvent;
import net.orbyfied.j8.event.EventBus;
import net.orbyfied.j8.event.pipeline.Pipeline;
import net.orbyfied.j8.event.pipeline.PipelineAccess;
import net.orbyfied.j8.event.pipeline.PipelineConverter;
import net.orbyfied.j8.event.pipeline.PipelineHandlerAction;
import net.orbyfied.j8.event.pipeline.impl.BasicPipeline;

public class Pipelines {
    private Pipelines() {
    }

    public static PipelineAccess parental(final EventBus bus, Class<?> klass) {
        final Class[] parents = klass.getClasses();
        return new PipelineAccess(){
            Pipeline pipeline = new BasicPipeline();

            public PipelineAccess push(Object event) {
                this.pipeline.push(event);
                for (Class parent : parents) {
                    PipelineAccess<?> p = bus.getPipelineOrNull(parent);
                    if (p == null) continue;
                    p.push(event);
                }
                return this;
            }

            public Pipeline base() {
                return this.pipeline;
            }

            public Pipeline base(PipelineConverter converter) {
                this.pipeline = converter.convert(this.pipeline);
                return null;
            }
        };
    }

    public static PipelineAccess<BusEvent> mono(EventBus bus) {
        return new PipelineAccess<BusEvent>(){
            Pipeline pipeline = new BasicPipeline();

            @Override
            public PipelineAccess<BusEvent> push(BusEvent event) {
                this.pipeline.push(event);
                return this;
            }

            @Override
            public Pipeline<BusEvent, ? extends PipelineHandlerAction> base() {
                return this.pipeline;
            }

            @Override
            public Pipeline base(PipelineConverter converter) {
                this.pipeline = converter.convert(this.pipeline);
                return null;
            }
        };
    }
}

