/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.event.pipeline.impl;

import java.util.ArrayList;
import net.orbyfied.j8.event.pipeline.Handler;
import net.orbyfied.j8.event.pipeline.Pipeline;
import net.orbyfied.j8.event.pipeline.PipelineConverter;
import net.orbyfied.j8.event.pipeline.PipelineHandlerAction;

public class BasicPipeline<E>
implements Pipeline<E, PipelineHandlerAction> {
    private ArrayList<Handler<E>> handlers = new ArrayList();

    public ArrayList<Handler<E>> handlers() {
        return this.handlers;
    }

    public int size() {
        return this.handlers.size();
    }

    @Override
    public BasicPipeline<E> push(E event) {
        int l = this.handlers.size();
        if (l == 0) {
            return this;
        }
        for (int i = 0; i < l; ++i) {
            Handler<E> handler = this.handlers.get(i);
            handler.handle(event);
        }
        return this;
    }

    @Override
    public PipelineHandlerAction<PipelineHandlerAction, E> handler(final Handler handler) {
        return new PipelineHandlerAction<PipelineHandlerAction, E>(){

            @Override
            public Handler<E> get() {
                return handler;
            }

            @Override
            public Pipeline<E, PipelineHandlerAction> back() {
                return BasicPipeline.this;
            }

            @Override
            public Pipeline<E, PipelineHandlerAction> register() {
                BasicPipeline.this.addLast(handler);
                return BasicPipeline.this;
            }

            @Override
            public Pipeline<E, PipelineHandlerAction> unregister() {
                BasicPipeline.this.handlers.remove(handler);
                return BasicPipeline.this;
            }
        };
    }

    public BasicPipeline<E> base() {
        return this;
    }

    @Override
    public <T extends Pipeline<E, ? extends PipelineHandlerAction>> T base(PipelineConverter<T> converter) {
        throw new UnsupportedOperationException();
    }

    public BasicPipeline<E> addLast(Handler<E> handler) {
        this.handlers.add(handler);
        return this;
    }
}

