/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.event;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.orbyfied.j8.event.BusHandler;
import net.orbyfied.j8.event.EventBus;
import net.orbyfied.j8.event.EventListener;
import net.orbyfied.j8.event.handler.HandlerDescriptor;
import net.orbyfied.j8.event.handler.HandlerProvider;
import net.orbyfied.j8.event.pipeline.Handler;

public class RegisteredListener {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    final EventBus bus;
    final List<BusHandler> handlers = new ArrayList<BusHandler>();
    final EventListener obj;
    final Class<? extends EventListener> klass;
    boolean dynamic;
    boolean enabled = true;
    boolean registered = false;
    public static final Object HANDLER_PROPERTY_EVENT_CLASS = new Object();

    public RegisteredListener(EventBus bus, EventListener obj) {
        Objects.requireNonNull(bus, "the event bus cannot be null");
        this.bus = bus;
        this.obj = obj;
        this.klass = obj == null ? null : obj.getClass();
    }

    public void destroy() {
        for (BusHandler handler : this.handlers) {
            handler.destroy();
        }
    }

    public RegisteredListener parse() {
        try {
            Method[] methods;
            for (final Method method : methods = this.klass.getDeclaredMethods()) {
                HandlerProvider provider;
                if (method.getParameterCount() == 0) continue;
                Annotation desc = null;
                for (Annotation a : method.getDeclaredAnnotations()) {
                    if (!a.annotationType().isAnnotationPresent(HandlerDescriptor.class)) continue;
                    desc = a;
                    break;
                }
                if (desc == null) continue;
                try {
                    Class<? extends Annotation> descClass = desc.annotationType();
                    Field field = descClass.getDeclaredField("PROVIDER");
                    field.setAccessible(true);
                    provider = (HandlerProvider)field.get(null);
                    if (provider == null) {
                        throw new IllegalArgumentException("No provider set");
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid handler descriptor " + desc.getClass().getSimpleName(), e);
                }
                Class<?> eventType = method.getParameterTypes()[0];
                try {
                    method.setAccessible(true);
                }
                catch (Exception e) {
                    Exception cause = e instanceof InaccessibleObjectException ? null : e;
                    throw new IllegalArgumentException("Listener method " + method.getDeclaringClass().getName() + "#" + method.getClass() + " is inaccessible", cause);
                }
                BusHandler handler = new BusHandler(this.bus, this, provider){

                    @Override
                    public void handle(Object event) {
                        if (!this.isEnabled()) {
                            return;
                        }
                        try {
                            method.invoke((Object)RegisteredListener.this.obj, event);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                };
                handler.withProperty(HANDLER_PROPERTY_EVENT_CLASS, eventType);
                provider.configure(handler, desc);
                this.handlers.add(handler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public RegisteredListener register() {
        if (this.registered) {
            return this;
        }
        this.registered = true;
        for (BusHandler handler : this.handlers) {
            handler.register();
        }
        return this;
    }

    public RegisteredListener dynamic(boolean b) {
        this.dynamic = b;
        return this;
    }

    public <E> RegisteredListener handle(Class<E> klass, Handler handler) {
        BusHandler h = new BusHandler(this.bus, this, HandlerProvider.forBasicPipeline(this.bus.getPipelineFor(klass).base())).setDelegate(handler);
        if (this.dynamic) {
            h.register();
        }
        this.handlers.add(h);
        return this;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }
}

