/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.event;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.orbyfied.j8.event.BusEvent;
import net.orbyfied.j8.event.EventInvocationException;
import net.orbyfied.j8.event.EventListener;
import net.orbyfied.j8.event.InternalBusException;
import net.orbyfied.j8.event.InvalidEventException;
import net.orbyfied.j8.event.RegisteredListener;
import net.orbyfied.j8.event.pipeline.BusPipelineFactory;
import net.orbyfied.j8.event.pipeline.PipelineAccess;

public class EventBus {
    private final Object2ObjectOpenHashMap<Class<? extends EventListener>, RegisteredListener> listenersByClass = new Object2ObjectOpenHashMap();
    private final ArrayList<RegisteredListener> listeners = new ArrayList();
    private final Object2ObjectOpenHashMap<Class<?>, PipelineAccess<?>> eventPipelineCache = new Object2ObjectOpenHashMap();
    private BusPipelineFactory defaultPipelineFactory;

    public RegisteredListener register(EventListener listener) {
        RegisteredListener rl = new RegisteredListener(this, listener);
        this.listeners.add(rl);
        this.listenersByClass.put(rl.klass, (Object)rl);
        rl.parse().register();
        return rl;
    }

    public boolean isRegistered(EventListener listener) {
        return this.listenersByClass.containsKey(listener.getClass());
    }

    public boolean isRegistered(Class<? extends EventListener> listener) {
        return this.listenersByClass.containsKey(listener);
    }

    public RegisteredListener getRegistered(Class<? extends EventListener> klass) {
        return (RegisteredListener)this.listenersByClass.get(klass);
    }

    public List<RegisteredListener> getAllRegistered(Class<? extends EventListener> klass) {
        ArrayList<RegisteredListener> list = new ArrayList<RegisteredListener>();
        for (RegisteredListener l : this.listeners) {
            if (l.klass != klass) continue;
            list.add(l);
        }
        return Collections.unmodifiableList(list);
    }

    public List<RegisteredListener> getAllRegistered() {
        return Collections.unmodifiableList(this.listeners);
    }

    public EventBus unregister(RegisteredListener listener) {
        if (listener == null) {
            return this;
        }
        listener.destroy();
        this.listeners.remove(listener);
        this.listenersByClass.remove(listener.klass, (Object)listener);
        return this;
    }

    public EventBus unregisterLast(EventListener listener) {
        this.unregister((RegisteredListener)this.listenersByClass.get(listener.getClass()));
        return this;
    }

    public EventBus unregisterLast(Class<? extends EventListener> klass) {
        this.unregister((RegisteredListener)this.listenersByClass.get(klass));
        return this;
    }

    public EventBus unregisterAll(Class<? extends EventListener> klass) {
        for (RegisteredListener rl : this.listeners) {
            if (rl.klass != klass) continue;
            this.unregister(rl);
        }
        return this;
    }

    public EventBus bake(Class<?> event) {
        this.getPipelineFor(event);
        return this;
    }

    public <E extends BusEvent> EventBus post(E event) {
        return this.post(event.getClass(), event);
    }

    public <E> void postUnsafe(Class fclass, E event) {
        PipelineAccess<?> acc = this.getPipelineFor(fclass);
        acc.push(event);
    }

    public <E> EventBus post(Class<E> fclass, E event) {
        PipelineAccess<?> acc = this.getPipelineFor(fclass);
        this.pushSafe(event, acc);
        return this;
    }

    protected <E> void pushSafe(E event, PipelineAccess<E> acc) {
        try {
            acc.push(event);
        }
        catch (Exception e) {
            throw new EventInvocationException(this, "error occurred in event handler", e);
        }
    }

    public PipelineAccess<?> getPipelineFor(Class<?> event) {
        PipelineAccess pipeline = (PipelineAccess)this.eventPipelineCache.get(event);
        if (pipeline != null) {
            return pipeline;
        }
        try {
            try {
                Method getPipeline = event.getDeclaredMethod("getPipeline", EventBus.class);
                pipeline = (PipelineAccess)getPipeline.invoke(null, this);
            }
            catch (NoSuchMethodException e) {
                if (this.defaultPipelineFactory == null) {
                    throw new InvalidEventException(this, event, "pipeline provider { PipelineAccess<E> getPipeline(EventBus); } not implemented");
                }
                pipeline = this.defaultPipelineFactory.createPipeline(this, event);
            }
            this.eventPipelineCache.put(event, (Object)pipeline);
            return pipeline;
        }
        catch (InvalidEventException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalBusException(this, "internal exception while retrieving event pipeline from '" + event.getName() + "'", e);
        }
    }

    public PipelineAccess<?> getPipelineOrNull(Class<?> event) {
        return (PipelineAccess)this.eventPipelineCache.get(event);
    }

    public EventBus withDefaultPipelineFactory(BusPipelineFactory factory) {
        this.defaultPipelineFactory = factory;
        return this;
    }
}

