/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.orbyfied.j8.event.EventBus;
import net.orbyfied.j8.event.EventListener;
import net.orbyfied.j8.event.RegisteredListener;
import net.orbyfied.j8.event.pipeline.PipelineAccess;
import net.orbyfied.j8.event.service.EventService;
import net.orbyfied.j8.event.service.FunctionalEventService;

public class ComplexEventBus
extends EventBus {
    private final ArrayList<EventService> servicesLinear = new ArrayList();
    private final HashMap<Class<? extends EventService>, EventService> servicesMapped = new HashMap();

    @Override
    public RegisteredListener register(EventListener listener) {
        RegisteredListener rl = super.register(listener);
        int l = this.servicesLinear.size();
        for (int i = 0; i < l; ++i) {
            EventService service = this.servicesLinear.get(i);
            if (!(service instanceof FunctionalEventService)) continue;
            FunctionalEventService fes = (FunctionalEventService)service;
            fes.registered(rl);
        }
        return rl;
    }

    @Override
    public ComplexEventBus unregister(RegisteredListener listener) {
        super.unregister(listener);
        int l = this.servicesLinear.size();
        for (int i = 0; i < l; ++i) {
            EventService service = this.servicesLinear.get(i);
            if (!(service instanceof FunctionalEventService)) continue;
            FunctionalEventService fes = (FunctionalEventService)service;
            fes.unregistered(listener);
        }
        return this;
    }

    @Override
    public <E> EventBus post(Class<E> fclass, E event) {
        PipelineAccess<?> acc = this.getPipelineFor(fclass);
        int l = this.servicesLinear.size();
        for (int i = 0; i < l; ++i) {
            EventService service = this.servicesLinear.get(i);
            if (!(service instanceof FunctionalEventService)) continue;
            FunctionalEventService fes = (FunctionalEventService)service;
            fes.prePublish(event, acc);
        }
        this.pushSafe(event, acc);
        return this;
    }

    public List<EventService> getServicesLinear() {
        return Collections.unmodifiableList(this.servicesLinear);
    }

    public Map<Class<? extends EventService>, EventService> getServicesMapped() {
        return Collections.unmodifiableMap(this.servicesMapped);
    }

    public <S extends EventService> S getService(Class<S> klass) {
        return (S)this.servicesMapped.get(klass);
    }

    public ComplexEventBus addService(EventService s) {
        this.servicesLinear.add(s);
        this.servicesMapped.put(s.getClass(), s);
        return this;
    }

    public ComplexEventBus removeService(EventService s) {
        this.servicesLinear.remove(s);
        this.servicesMapped.remove(s.getClass());
        return this;
    }
}

