/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.event;

import java.util.HashMap;
import java.util.Map;
import net.orbyfied.j8.event.EventBus;
import net.orbyfied.j8.event.RegisteredListener;
import net.orbyfied.j8.event.handler.HandlerProvider;
import net.orbyfied.j8.event.pipeline.Handler;

public class BusHandler
implements Handler<Object> {
    public static final int STATUS_DISABLED = -1;
    public static final int STATUS_DELEGATE = 0;
    public static final int STATUS_ENABLED = 1;
    final RegisteredListener listener;
    final EventBus bus;
    final HandlerProvider<?> provider;
    Map<Object, Object> properties;
    Handler<Object> delegate;
    int toggleStatus = 0;
    boolean registered = false;

    public BusHandler(EventBus bus, RegisteredListener listener, HandlerProvider<?> provider) {
        this.bus = bus;
        this.listener = listener;
        this.provider = provider;
    }

    @Override
    public void handle(Object event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.handle(event);
        }
    }

    public void register() {
        this.provider.register(this.bus, this);
        this.registered = true;
    }

    public void destroy() {
        this.provider.unregister(this.bus, this);
    }

    public BusHandler withProperty(Object key, Object val) {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>();
        }
        this.properties.put(key, val);
        return this;
    }

    public <T> T getProperty(Object key) {
        return (T)(this.properties == null ? null : this.properties.get(key));
    }

    public boolean isEnabled() {
        if (this.toggleStatus == 0) {
            return this.listener.enabled;
        }
        return this.toggleStatus != -1;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public int getStatus() {
        return this.toggleStatus;
    }

    public void setStatus(int s) {
        this.toggleStatus = s;
    }

    public Handler<Object> getDelegate() {
        return this.delegate;
    }

    public BusHandler setDelegate(Handler<Object> handler) {
        this.delegate = handler;
        return this;
    }

    public HandlerProvider<?> getProvider() {
        return this.provider;
    }

    public EventBus getBus() {
        return this.bus;
    }

    public RegisteredListener getListener() {
        return this.listener;
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }
}

