/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.orbyfied.j8.config.Configurable;
import net.orbyfied.j8.util.ReflectionUtil;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationHelper<S extends ConfigurationSection> {
    protected final List<Configurable<?>> configurables = new ArrayList();
    protected final Map<Class<?>, Configurable<?>> configurablesByClass = new HashMap();
    protected final HashMap<String, ConfigurationHelper<ConfigurationSection>> children = new HashMap();
    protected S section;
    protected Consumer<S> beforeLoad;
    protected Consumer<S> afterSave;

    public List<Configurable<?>> getConfigurables() {
        return Collections.unmodifiableList(this.configurables);
    }

    public Map<Class<?>, Configurable<?>> getConfigurablesByClass() {
        return Collections.unmodifiableMap(this.configurablesByClass);
    }

    public Map<String, ConfigurationHelper<ConfigurationSection>> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public <T extends Configurable<?>> T getConfigurable(Class<T> klass) {
        return (T)this.configurablesByClass.get(klass);
    }

    public ConfigurationHelper<S> addConfigurable(Configurable<?> c) {
        this.configurables.add(c);
        this.configurablesByClass.put(c.getClass(), c);
        return this;
    }

    void tryDiscoverChildConfigurables(Configurable<?> c) {
        try {
            Class<?> klass = c.getClass();
            for (Field field : klass.getFields()) {
                if (!Configurable.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Object o = Modifier.isStatic(field.getModifiers()) ? field.get(null) : field.get(c);
                if (o == null) continue;
                Configurable conf = (Configurable)o;
                this.addConfigurable(conf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ConfigurationHelper<S> removeConfigurable(Configurable<?> c) {
        this.configurables.remove(c);
        this.configurablesByClass.remove(c.getClass());
        return this;
    }

    public ConfigurationHelper<S> removeConfigurable(Class<?> c) {
        return this.removeConfigurable(this.configurablesByClass.get(c));
    }

    public ConfigurationHelper<S> section(S section) {
        this.section = section;
        return this;
    }

    public ConfigurationHelper<S> afterSave(Consumer<S> consumer) {
        this.afterSave = consumer;
        return this;
    }

    public ConfigurationHelper<S> beforeLoad(Consumer<S> consumer) {
        this.beforeLoad = consumer;
        return this;
    }

    public <C extends ConfigurationSection> ConfigurationHelper<S> child(String key, Supplier<ConfigurationHelper<C>> supplier, Consumer<ConfigurationHelper<C>> consumer) {
        ConfigurationHelper<?> helper = this.createChildren(key, supplier);
        if (consumer != null) {
            consumer.accept(helper);
        }
        this.children.put(key, helper);
        return this;
    }

    public <C extends ConfigurationSection> ConfigurationHelper<S> child(String key, Supplier<ConfigurationHelper<C>> supplier) {
        return this.child(key, supplier, null);
    }

    public ConfigurationHelper<S> unchild(String key) {
        this.children.remove(key);
        return this;
    }

    public ConfigurationHelper<S> save() {
        for (Configurable<?> configurable : this.configurables) {
            String path;
            ConfigurationHelper<?> helper;
            String[] ps = configurable.getConfigurationPath().split("/");
            if (ps.length == 1) {
                helper = this.getChild(null);
                path = ps[0];
            } else {
                helper = this.getChild(ps[0]);
                path = ps[1];
            }
            configurable.getConfiguration().save(ConfigurationHelper.getOrCreateSection(helper.section, path));
        }
        for (ConfigurationHelper configurationHelper : this.children.values()) {
            configurationHelper.save();
        }
        if (this.afterSave != null) {
            this.afterSave.accept(this.section);
        }
        return this;
    }

    public ConfigurationHelper<S> loadOne(Configurable<?> c) {
        String path;
        ConfigurationHelper<?> helper;
        String[] ps = c.getConfigurationPath().split("/");
        if (ps.length == 1) {
            helper = this.getChild(null);
            path = ps[0];
        } else {
            helper = this.getChild(ps[0]);
            path = ps[1];
        }
        c.getConfiguration().load(ConfigurationHelper.getOrCreateSection(helper.section, path));
        return this;
    }

    public ConfigurationHelper<S> load() {
        if (this.beforeLoad != null) {
            this.beforeLoad.accept(this.section);
        }
        for (ConfigurationHelper<ConfigurationSection> configurationHelper : this.children.values()) {
            configurationHelper.load();
        }
        for (Configurable configurable : this.configurables) {
            this.loadOne(configurable);
        }
        return this;
    }

    public ConfigurationHelper<?> getChild(String s) {
        if (s == null) {
            return this;
        }
        String[] c = s.split("\\.");
        ConfigurationHelper<ConfigurationSection> curr = this;
        for (String k : c) {
            curr = curr.children.get(k);
        }
        return curr;
    }

    public <C extends ConfigurationSection> ConfigurationHelper<?> createChildren(String s, Supplier<ConfigurationHelper<C>> supplier) {
        String[] c = s.split("\\.");
        ConfigurationHelper<Object> curr = this;
        for (int i = 0; i < c.length - 1; ++i) {
            String k = c[i];
            ConfigurationHelper<ConfigurationSection> prev = curr;
            curr = prev.children.get(k);
            if (curr != null) continue;
            curr = new ConfigurationHelper<S>();
            prev.children.put(k, curr);
        }
        ConfigurationHelper<C> helper = supplier.get();
        curr.children.put(c[c.length - 1], helper);
        return helper;
    }

    public ConfigurationHelper<S> applyTemplate(Consumer<ConfigurationHelper<? extends S>> consumer) {
        consumer.accept(this);
        return this;
    }

    public String toString() {
        return new StringJoiner(", ", ConfigurationHelper.class.getSimpleName() + "[", "]").add("configurables=" + this.configurables).add("children=" + this.children).add("section=" + this.section).toString();
    }

    public static Consumer<ConfigurationHelper<YamlConfiguration>> bukkitYamlConfiguration(Path file, String defaults) {
        Class<?> resolver = ReflectionUtil.getCallerClass(1);
        return helper -> helper.section(new YamlConfiguration()).beforeLoad(sect -> {
            if (defaults != null) {
                ConfigurationHelper.saveDefaults(resolver, defaults, file, false);
            }
            ConfigurationHelper.loadFromFile((FileConfiguration)sect, file);
        }).afterSave(sect -> ConfigurationHelper.saveToFile((FileConfiguration)sect, file));
    }

    public static ConfigurationSection getOrCreateSection(ConfigurationSection cfg, String path) {
        ConfigurationSection section = cfg.getConfigurationSection(path);
        if (section != null) {
            return section;
        }
        return cfg.createSection(path);
    }

    public static boolean saveDefaults(Class<?> resolver, String resource, Path to, boolean overwrite) {
        try {
            if (!Files.exists(to, new LinkOption[0])) {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
                Files.createFile(to, new FileAttribute[0]);
            } else if (!overwrite) {
                return false;
            }
            InputStream resIn = resolver.getResourceAsStream(resource);
            OutputStream fOut = Files.newOutputStream(to, new OpenOption[0]);
            if (resIn == null) {
                throw new IllegalArgumentException("resource '" + resource + "' not found");
            }
            resIn.transferTo(fOut);
            resIn.close();
            fOut.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void saveToFile(FileConfiguration cfg, Path file) {
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
            cfg.save(file.toFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadFromFile(FileConfiguration cfg, Path file) {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                cfg.load(file.toFile());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ConfigurationHelper<YamlConfiguration> newYamlFileConfiguration(Path file, String defaults) {
        Class<?> resolver = ReflectionUtil.getCallerClass(1);
        ConfigurationHelper<YamlConfiguration> helper = new ConfigurationHelper<YamlConfiguration>();
        helper.section(new YamlConfiguration()).beforeLoad(sect -> {
            if (defaults != null) {
                ConfigurationHelper.saveDefaults(resolver, defaults, file, false);
            }
            ConfigurationHelper.loadFromFile((FileConfiguration)sect, file);
        }).afterSave(sect -> ConfigurationHelper.saveToFile((FileConfiguration)sect, file));
        return helper;
    }
}

