/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import net.orbyfied.j8.config.Comment;
import net.orbyfied.j8.config.Configurable;
import net.orbyfied.j8.config.ConfigurationException;
import net.orbyfied.j8.config.Configure;
import org.bukkit.configuration.ConfigurationSection;

public interface Configuration {
    public Configurable<?> getConfigurable();

    default public void whenLoaded(ConfigurationSection config) {
    }

    default public void whenSaved(ConfigurationSection config) {
    }

    default public void load(ConfigurationSection config) {
        try {
            Class<?> klass = this.getClass();
            for (Field field : klass.getDeclaredFields()) {
                field.setAccessible(true);
                Configure desc = field.getAnnotation(Configure.class);
                if (desc == null) continue;
                String name = desc.name();
                if (name.equals("<get>")) {
                    name = field.getName();
                }
                if (!config.contains(name)) continue;
                Object o = config.get(name);
                if (o == null) {
                    field.set(this, null);
                } else if (Configurable.class.isAssignableFrom(field.getType())) {
                    Configurable c = (Configurable)o;
                    c.getConfiguration().load(config.getConfigurationSection(name));
                } else {
                    field.set(this, o);
                }
                this.whenLoaded(config);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("failed to load configuration", e);
        }
    }

    default public void save(ConfigurationSection config) {
        try {
            Class<?> klass = this.getClass();
            for (Field field : klass.getDeclaredFields()) {
                Object o;
                String name;
                field.setAccessible(true);
                Configure desc = field.getAnnotation(Configure.class);
                if (desc == null) continue;
                Comment comment = field.getAnnotation(Comment.class);
                if (comment != null) {
                    ArrayList<String> list = new ArrayList<String>(config.getComments(""));
                    list.addAll(Arrays.asList(comment.value().split("\n")));
                    config.setComments("", list);
                }
                if ((name = desc.name()).equals("<get>")) {
                    name = field.getName();
                }
                if ((o = field.get(this)) == null) {
                    config.set(name, null);
                } else if (Configurable.class.isAssignableFrom(field.getType())) {
                    Configurable c = (Configurable)o;
                    c.getConfiguration().save(config.getConfigurationSection(name));
                } else {
                    config.set(name, o);
                }
                this.whenSaved(config);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("failed to load configuration", e);
        }
    }
}

