/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.argument;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.argument.ArgumentType;
import net.orbyfied.j8.command.argument.GenericArgumentType;
import net.orbyfied.j8.command.argument.TypeIdentifier;
import net.orbyfied.j8.command.argument.TypeResolver;
import net.orbyfied.j8.command.argument.options.StringArgumentOptions;
import net.orbyfied.j8.command.exception.ErrorLocation;
import net.orbyfied.j8.command.exception.NodeParseException;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.StringReader;
import net.orbyfied.j8.util.functional.QuadConsumer;
import net.orbyfied.j8.util.functional.TriConsumer;
import net.orbyfied.j8.util.functional.TriFunction;
import net.orbyfied.j8.util.functional.TriPredicate;

public class ArgumentTypes {
    public static final SystemTypeResolver typeResolver = new SystemTypeResolver();
    public static final String KEY_PROVIDER_OPTION = "key_provider";
    public static final String SUGGESTER_OPTION = "suggester";
    private static final CompleterFunc BASE_10_COMPLETER_FUNC = (ctx, reader, acc) -> {
        for (int i = 0; i < 10; ++i) {
            acc.suggest(i);
        }
    };
    private static final CompleterFunc BASE_10_F_COMPLETER_FUNC = (ctx, reader, acc) -> {
        for (int i = 0; i < 10; ++i) {
            acc.suggest(i);
        }
    };
    public static final ArgumentType<Boolean> BOOLEAN = ArgumentTypes.of(Boolean.class, "system:bool", (context, reader) -> reader.current() == '0' || reader.current() == '1' || reader.current() == 't' || reader.current() == 'f', (context, reader) -> {
        String str = reader.collect(c -> c.charValue() != ' ');
        return "1".equals(str) || "true".equals(str);
    }, (context, builder, value) -> builder.append(value), new Object[0]);
    public static final ArgumentType<Byte> BYTE = ArgumentTypes.of(Byte.class, "system:byte", (context, reader) -> ArgumentTypes.isDigit(reader.current(), 10), (context, reader) -> ArgumentTypes.parseNumber(context, reader, Byte::parseByte), (context, builder, value) -> builder.append(value), BASE_10_COMPLETER_FUNC);
    public static final ArgumentType<Short> SHORT = ArgumentTypes.of(Short.class, "system:short", (context, reader) -> ArgumentTypes.isDigit(reader.current(), 10), (context, reader) -> ArgumentTypes.parseNumber(context, reader, Short::parseShort), (context, builder, value) -> builder.append(value), BASE_10_COMPLETER_FUNC);
    public static final ArgumentType<Integer> INT = ArgumentTypes.of(Integer.class, "system:int", (context, reader) -> ArgumentTypes.isDigit(reader.current(), 10), (context, reader) -> ArgumentTypes.parseNumber(context, reader, Integer::parseInt), (context, builder, value) -> builder.append(value), BASE_10_COMPLETER_FUNC);
    public static final ArgumentType<Long> LONG = ArgumentTypes.of(Long.class, "system:long", (context, reader) -> ArgumentTypes.isDigit(reader.current(), 10), (context, reader) -> ArgumentTypes.parseNumber(context, reader, Long::parseLong), (context, builder, value) -> builder.append(value), BASE_10_COMPLETER_FUNC);
    public static final ArgumentType<Float> FLOAT = ArgumentTypes.of(Float.class, "system:float", (context, reader) -> ArgumentTypes.isDigit(reader.current(), 10), (context, reader) -> ArgumentTypes.parseNumberFloat(context, reader, Float::parseFloat), (context, builder, value) -> builder.append(value), BASE_10_F_COMPLETER_FUNC);
    public static final ArgumentType<Double> DOUBLE = ArgumentTypes.of(Double.class, "system:double", (context, reader) -> ArgumentTypes.isDigit(reader.current(), 10), (context, reader) -> ArgumentTypes.parseNumberFloat(context, reader, Double::parseDouble), (context, builder, value) -> builder.append(value), BASE_10_F_COMPLETER_FUNC);
    public static final ArgumentType<String> STRING = ArgumentTypes.of(String.class, "system:string", (context, reader) -> true, (context, reader) -> {
        if (reader.current() == '\"') {
            reader.next();
            return reader.collect(c -> c.charValue() != '\"', 1);
        }
        StringArgumentOptions options = context.argumentOptions(StringArgumentOptions.class);
        if (options != null && options.readFar()) {
            return reader.collect();
        }
        return reader.collect(c -> c.charValue() != ' ');
    }, (context, builder, s) -> builder.append("\"").append((String)s).append("\""), new Object[0]);
    public static final ArgumentType<Character> CHAR = ArgumentTypes.of(Character.class, "system:char", (context, reader) -> true, (context, reader) -> {
        if (reader.current() == '\'') {
            reader.next();
            return Character.valueOf(reader.collect(c -> c.charValue() != '\'', 1).charAt(0));
        }
        return Character.valueOf(reader.collect(c -> c.charValue() != ' ').charAt(0));
    }, (context, builder, s) -> builder.append("'").append(s).append("'"), new Object[0]);
    public static final ArgumentType<Identifier> IDENTIFIER = ArgumentTypes.of(Identifier.class, "system:identifier", (context, stringReader) -> true, (context, reader) -> Identifier.of((String)STRING.parse((Context)context, (StringReader)reader)), (context, builder, s) -> builder.append(s.toString()), new Object[0]);
    public static final ArgumentType<Path> FILE_PATH = ArgumentTypes.of(Path.class, "system:filepath", (context, reader) -> true, (context, reader) -> Path.of(STRING.parse((Context)context, (StringReader)reader), new String[0]), (context, builder, v) -> builder.append("\"").append(v.toString()).append("\n"), new Object[0]);
    public static final GenericArgumentType<List> LIST = ArgumentTypes.ofGeneric(List.class, "system:list", "T", (TriPredicate<Context, StringReader, LinkedHashMap<String, ArgumentType>>)((TriPredicate)(context, reader, types) -> true), (context, reader, types) -> {
        char c1;
        ArgumentType type = (ArgumentType)types.get("T");
        ArrayList list = new ArrayList();
        while ((c1 = reader.next()) != ']' && c1 != '\uffff') {
            reader.collect(c -> c.charValue() == ' ');
            list.add(type.parse((Context)context, (StringReader)reader));
        }
        return list;
    }, (context, builder, v, types) -> {
        ArgumentType type = (ArgumentType)types.get("T");
        builder.append("[");
        int l = v.size();
        for (int i = 0; i < l; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            type.write((Context)context, (StringBuilder)builder, v.get(i));
        }
        builder.append("]");
    }, (context, reader, suggestions, types) -> {
        suggestions.suggest("]");
        suggestions.suggest(",");
        ((ArgumentType)types.get("T")).suggest(context, suggestions);
        reader.collect(c -> c.charValue() != ']', 1);
    });
    public static final ArgumentType<TypeIdentifier> TYPE_IDENTIFIER = ArgumentTypes.of(TypeIdentifier.class, "system:type_identifier", (context, reader) -> true, (context, reader) -> TypeIdentifier.of(reader.collect(c -> c.charValue() != ' ')), (context, builder, identifier) -> builder.append(identifier), new Object[0]);
    public static final ArgumentType<ArgumentType> TYPE = ArgumentTypes.of(ArgumentType.class, "system:type", (context, reader) -> true, (context, reader) -> context.manager().getTypeResolver().compile(TYPE_IDENTIFIER.parse((Context)context, (StringReader)reader)), (context, builder, o) -> builder.append(o.getIdentifier()), new Object[0]);
    public static final ArgumentType<UUID> UUID = ArgumentTypes.of(UUID.class, "system:uuid", (context, reader) -> true, (context, reader) -> java.util.UUID.fromString(reader.collect(c -> c.charValue() != ' ')), (context, builder, uuid) -> builder.append(uuid), new Object[0]);
    public static final ArgumentType<Class> CLASS = ArgumentTypes.of(Class.class, "system:class", (context, reader) -> true, (context, reader) -> {
        String n = reader.collect(c -> c.charValue() != ' ');
        try {
            return Class.forName(n);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }, (context, builder, aClass) -> builder.append(aClass.getName()), new Object[0]);

    private ArgumentTypes() {
    }

    static <T> ArgumentType<T> of(final Class<T> klass, String baseId, final BiPredicate<Context, StringReader> acceptor, final BiFunction<Context, StringReader, T> parser, final TriConsumer<Context, StringBuilder, T> writer, Object ... optional) {
        final TypeIdentifier bid = TypeIdentifier.of(baseId);
        CompleterFunc completerFunc = null;
        for (Object o : optional) {
            if (!(o instanceof CompleterFunc)) continue;
            completerFunc = (CompleterFunc)o;
        }
        final CompleterFunc finalCompleterFunc = completerFunc;
        ArgumentType type = new ArgumentType<T>(){

            @Override
            public TypeIdentifier getBaseIdentifier() {
                return bid;
            }

            @Override
            public Class<T> getType() {
                return klass;
            }

            @Override
            public boolean accepts(Context context, StringReader reader) {
                return acceptor.test(context, reader);
            }

            @Override
            public T parse(Context context, StringReader reader) {
                return parser.apply(context, reader);
            }

            @Override
            public void write(Context context, StringBuilder builder, T v) {
                writer.accept((Object)context, (Object)builder, v);
            }

            @Override
            public void suggest(Context context, SuggestionAccumulator suggestions) {
                if (finalCompleterFunc != null) {
                    finalCompleterFunc.doSuggestions(context, context.reader().branch(), suggestions);
                }
            }

            public String toString() {
                return bid.toString();
            }
        };
        ArgumentTypes.typeResolver.types.put(bid.getPath(), type);
        return type;
    }

    static <T> GenericArgumentType<T> ofGeneric(final Class<T> klass, String baseId, String paramsStr, final TriPredicate<Context, StringReader, LinkedHashMap<String, ArgumentType>> acceptor, final TriFunction<Context, StringReader, LinkedHashMap<String, ArgumentType>, T> parser, final QuadConsumer<Context, StringBuilder, T, LinkedHashMap<String, ArgumentType>> writer, Object ... optional) {
        final TypeIdentifier bid = TypeIdentifier.of(baseId);
        String[] params = paramsStr.split(" ");
        GenericCompleterFunc suggester = null;
        for (Object o : optional) {
            if (!(o instanceof GenericCompleterFunc)) continue;
            suggester = (GenericCompleterFunc)o;
        }
        final GenericCompleterFunc finalSuggester = suggester;
        GenericArgumentType type = new GenericArgumentType<T>(params){

            @Override
            public boolean accepts(Context context, StringReader reader, LinkedHashMap<String, ArgumentType> types) {
                return acceptor.test((Object)context, (Object)reader, types);
            }

            @Override
            public T parse(Context context, StringReader reader, LinkedHashMap<String, ArgumentType> types) {
                return parser.apply((Object)context, (Object)reader, types);
            }

            @Override
            public void write(Context context, StringBuilder builder, T v, LinkedHashMap<String, ArgumentType> types) {
                writer.accept((Object)context, (Object)builder, v, types);
            }

            @Override
            public void suggest(Context context, SuggestionAccumulator suggestions, LinkedHashMap<String, ArgumentType> types) {
                if (finalSuggester != null) {
                    finalSuggester.doSuggestions(context, context.reader().branch(), suggestions, types);
                } else {
                    try {
                        this.parse(context, context.reader());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public TypeIdentifier getBaseIdentifier() {
                return bid;
            }

            @Override
            public Class<?> getType() {
                return klass;
            }
        };
        ArgumentTypes.typeResolver.types.put(bid.getPath(), type);
        return type;
    }

    private static boolean isDigit(char c, int radix) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '_';
    }

    private static <T extends Number> T parseNumberFloat(Context context, StringReader reader, Function<String, T> parser) {
        return (T)ArgumentTypes.parseNumber(context, reader, (str, __) -> (Number)parser.apply((String)str));
    }

    private static <T extends Number> T parseNumber(Context context, StringReader reader, BiFunction<String, Integer, T> parser) {
        reader.collect(c -> c.charValue() == ' ');
        int idx = reader.index();
        int radix = 10;
        if (reader.current() == '0') {
            boolean c2 = true;
            switch (reader.peek(1)) {
                case 'x': {
                    radix = 16;
                    break;
                }
                case 'b': {
                    radix = 2;
                    break;
                }
                case 'o': {
                    radix = 8;
                    break;
                }
                default: {
                    c2 = false;
                }
            }
            if (c2) {
                reader.next(2);
            }
        }
        int rdx = radix;
        String str = reader.collect(c -> ArgumentTypes.isDigit(c.charValue(), rdx), c -> c.charValue() == '_');
        try {
            return (T)((Number)parser.apply(str, radix));
        }
        catch (NumberFormatException e) {
            throw new NodeParseException(context.rootCommand(), context.currentNode(), new ErrorLocation(reader, idx, reader.index()), "NaN (radix " + radix + "): '" + str + "'");
        }
    }

    public static <E extends Enum<?>> ArgumentType<E> ofEnum(final Class<E> eClass) {
        final Map values = Arrays.stream((Enum[])eClass.getEnumConstants()).collect(HashMap::new, (stringEHashMap, e) -> stringEHashMap.put(e.name().toLowerCase(Locale.ROOT), e), HashMap::putAll);
        final TypeIdentifier id = TypeIdentifier.of("generated:enum." + eClass.getSimpleName());
        return new ArgumentType<E>(){

            @Override
            public TypeIdentifier getBaseIdentifier() {
                return id;
            }

            @Override
            public Class<?> getType() {
                return eClass;
            }

            @Override
            public boolean accepts(Context context, StringReader reader) {
                String name = reader.collect(c -> c.charValue() != ' ');
                return values.containsKey(name.toLowerCase(Locale.ROOT));
            }

            @Override
            public E parse(Context context, StringReader reader) {
                String name = reader.collect(c -> c.charValue() != ' ');
                return (Enum)values.get(name.toLowerCase(Locale.ROOT));
            }

            @Override
            public void write(Context context, StringBuilder builder, E v) {
                builder.append(((Enum)v).name());
            }

            @Override
            public void suggest(Context context, SuggestionAccumulator suggestions) {
                for (Enum v : values.values()) {
                    suggestions.suggest(v.name().toLowerCase(Locale.ROOT));
                }
            }
        };
    }

    public static <T> ArgumentType<T> withSuggester(final ArgumentType<T> type, final CompleterFunc func) {
        return new ArgumentType<T>(){

            @Override
            public TypeIdentifier getBaseIdentifier() {
                return type.getBaseIdentifier();
            }

            @Override
            public Class<?> getType() {
                return type.getType();
            }

            @Override
            public boolean accepts(Context context, StringReader reader) {
                return type.accepts(context, reader);
            }

            @Override
            public T parse(Context context, StringReader reader) {
                return type.parse(context, reader);
            }

            @Override
            public void write(Context context, StringBuilder builder, T v) {
                type.write(context, builder, v);
            }

            @Override
            public void suggest(Context context, SuggestionAccumulator suggestions) {
                type.suggest(context, suggestions);
                if (func != null) {
                    func.doSuggestions(context, context.reader().branch(), suggestions);
                }
            }
        };
    }

    public static interface CompleterFunc {
        public void doSuggestions(Context var1, StringReader var2, SuggestionAccumulator var3);
    }

    public static final class SystemTypeResolver
    implements TypeResolver {
        protected HashMap<String, ArgumentType<?>> types = new HashMap();

        @Override
        public ArgumentType<?> resolve(Identifier identifier) {
            return this.types.get(identifier.getPath());
        }
    }

    public static interface GenericCompleterFunc {
        public void doSuggestions(Context var1, StringReader var2, SuggestionAccumulator var3, LinkedHashMap<String, ArgumentType> var4);
    }
}

