/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.md_5.bungee.api.ChatColor;
import net.orbyfied.j8.command.AbstractNodeComponent;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.NodeComponent;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.argument.Argument;
import net.orbyfied.j8.command.argument.ArgumentType;
import net.orbyfied.j8.command.argument.ArgumentTypes;
import net.orbyfied.j8.command.argument.Flag;
import net.orbyfied.j8.command.argument.options.ArgumentOptions;
import net.orbyfied.j8.command.component.Executable;
import net.orbyfied.j8.command.component.Flags;
import net.orbyfied.j8.command.component.Functional;
import net.orbyfied.j8.command.component.NonComponent;
import net.orbyfied.j8.command.component.Primary;
import net.orbyfied.j8.command.component.Properties;
import net.orbyfied.j8.command.component.Secure;
import net.orbyfied.j8.command.component.Suggester;
import net.orbyfied.j8.command.exception.CommandException;
import net.orbyfied.j8.command.exception.CommandParseException;
import net.orbyfied.j8.command.exception.ErrorLocation;
import net.orbyfied.j8.command.exception.NodeParseException;
import net.orbyfied.j8.command.impl.CommandNodeExecutor;
import net.orbyfied.j8.util.ReflectionUtil;
import net.orbyfied.j8.util.StringReader;

public class Node {
    static final Node NODE_UNKNOWN = new Node("<unknown>", null, null).executes(null, (ctx, cmd) -> {
        if (!ctx.isSuggesting()) {
            ctx.fail("Unknown sub-command " + ChatColor.WHITE + ctx.getArgument("__fast_node_name"));
        }
    });
    static final Node NODE_BLANK = new Node("<blank>", null, null);
    protected final ArrayList<NodeComponent> components = new ArrayList();
    protected final HashMap<Class<?>, NodeComponent> componentsByClass = new HashMap();
    protected final ArrayList<Node> children = new ArrayList();
    protected final HashMap<String, Node> childrenByName = new HashMap();
    protected final HashMap<String, Node> fastMappedChildren = new HashMap();
    protected final String name;
    protected final List<String> aliases = new ArrayList<String>();
    protected final Node parent;
    protected Node root;

    public Node(String name, Node parent, Node root) {
        this.name = name;
        this.parent = parent;
        this.root = Objects.requireNonNullElse(root, this);
        this.addChild(NODE_BLANK);
        this.withComponent(Suggester.defaults(this));
    }

    boolean executeOrBacktrack(Context context) {
        Executable executable;
        if (!context.isSuggesting() && (executable = this.getComponent(Executable.class)) != null) {
            executable.execute(context);
            return false;
        }
        return true;
    }

    public boolean walk(Context context, Node last, StringReader fReader) {
        context.current = this;
        Node root = context.rootCommand();
        SuggestionAccumulator suggestions = context.suggestions();
        while (Character.isWhitespace(fReader.current())) {
            fReader.next();
        }
        StringReader reader = fReader.branch();
        Primary primary = this.getComponentOf(Primary.class);
        if (primary == null) {
            throw new CommandException(this, "Invalid node, no primary component set");
        }
        for (NodeComponent component : this.components) {
            if (!(component instanceof Functional)) continue;
            Functional func = (Functional)component;
            func.walked(context, reader);
        }
        reader.next();
        ArrayList<Runnable> flagCompletions = new ArrayList<Runnable>();
        if (reader.current() == '-') {
            char c;
            while ((c = reader.current()) != '\uffff' && c == '-') {
                flagCompletions.clear();
                int sIdx = reader.index();
                c = reader.next();
                if (c == '-') {
                    reader.next();
                    String flagName = reader.collect(c1 -> c1.charValue() != '=' && c1.charValue() != ' ');
                    flag = context.getFlagByName(flagName);
                    if (reader.current() != '=' && context.isSuggesting()) {
                        flagCompletions.add(() -> {
                            suggestions.pushPrefix("--");
                            for (Flag<?> f : context.getFlags()) {
                                suggestions.suggest(f.getName());
                            }
                            suggestions.popPrefix();
                        });
                    }
                    if (flag != null) {
                        if (reader.current() == '=') {
                            reader.next();
                            try {
                                value = flag.getType().parse(context, reader);
                            }
                            catch (Exception e) {
                                throw new NodeParseException(root, this, new ErrorLocation(reader, sIdx, reader.index()), e);
                            }
                            if (context.isSuggesting()) {
                                flagCompletions.add(() -> {
                                    suggestions.pushPrefix("--" + flagName + "=");
                                    flag.getType().suggest(context, suggestions);
                                    suggestions.popPrefix();
                                });
                            }
                        } else {
                            if (!flag.isSwitch()) {
                                throw new CommandParseException(root, new ErrorLocation(reader, sIdx + 1, reader.index()), "Flag --" + flag.getName() + " is not a switch, but no value was provided.");
                            }
                            value = true;
                        }
                        context.flagValues.put(flag, value);
                    } else {
                        reader.next();
                        if (reader.current() == '=') {
                            reader.next();
                            value = ArgumentTypes.STRING.parse(context, reader);
                        } else {
                            value = true;
                        }
                        context.foreignFlagValues.put(flagName, value);
                    }
                } else {
                    char fg;
                    while ((fg = reader.current()) != '\uffff' && fg != ' ') {
                        flag = context.getFlagByCharacter(fg);
                        if (flag == null || !flag.isSwitch()) {
                            throw new CommandParseException(root, new ErrorLocation(reader, reader.index(), reader.index()), "No switch flag by character -" + fg);
                        }
                        context.flagValues.put(flag, true);
                        reader.next();
                    }
                }
                reader.next();
            }
        }
        reader.prev();
        Node next = this.findNext(context, reader);
        if (next == null) {
            if (context.isSuggesting()) {
                Suggester suggester;
                for (Runnable flagSuggestion : flagCompletions) {
                    flagSuggestion.run();
                }
                if (last != null && (suggester = last.getComponentOf(Suggester.class)) != null) {
                    suggester.suggest(context, suggestions, fReader);
                }
            }
            return this.executeOrBacktrack(context);
        }
        if (next.walk(context, this, reader)) {
            return this.executeOrBacktrack(context);
        }
        return false;
    }

    public Node findNext(Context context, StringReader reader) {
        if (reader.current() == '\uffff') {
            return null;
        }
        reader.next();
        String name = reader.branch().collect(c -> c.charValue() != ' ');
        Node node = this.fastMappedChildren.get(name);
        context.setArgument("__fast_node_name", (Object)name);
        if (node != null) {
            return node;
        }
        NodeComponent highest = null;
        for (Node child : this.children) {
            Primary primary = child.getComponentOf(Primary.class);
            if (primary == null || !primary.selects(context, reader.branch()) || highest != null && primary.priority() <= highest.priority()) continue;
            highest = primary;
        }
        if (highest != null) {
            return highest.getNode();
        }
        return NODE_UNKNOWN;
    }

    public Node node() {
        return this;
    }

    public List<Node> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Map<String, Node> getFastMappedChildren() {
        return Collections.unmodifiableMap(this.fastMappedChildren);
    }

    public List<NodeComponent> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public Map<Class<?>, NodeComponent> getComponentsByClass() {
        return Collections.unmodifiableMap(this.componentsByClass);
    }

    public Node parent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public Node root() {
        return this.root;
    }

    public Node withAliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    public Node addAliases(String ... aliases) {
        this.aliases.addAll(Arrays.asList(aliases));
        return this;
    }

    public Node removeAlias(String ... aliases) {
        this.aliases.removeAll(Arrays.asList(aliases));
        return this;
    }

    public <T extends NodeComponent> T makeComponent(Function<Node, T> constructor) {
        return (T)this.withComponent((NodeComponent)constructor.apply(this));
    }

    public <T extends NodeComponent> Node makeComponent(Function<Node, T> constructor, Consumer<T> consumer) {
        NodeComponent it = this.withComponent((NodeComponent)constructor.apply(this));
        if (consumer != null) {
            consumer.accept(it);
        }
        return this;
    }

    public <T extends NodeComponent> T component(Class<T> tClass, Function<Node, T> constructor) {
        Object c = this.getComponent(tClass);
        if (c != null) {
            return c;
        }
        c = (NodeComponent)constructor.apply(this);
        this.withComponent(c);
        return c;
    }

    public <T extends NodeComponent> Node component(Class<T> tClass, Function<Node, T> constructor, BiConsumer<Node, T> consumer) {
        T c = this.component(tClass, constructor);
        if (consumer != null) {
            consumer.accept(this, (Node)c);
        }
        return this;
    }

    public <T extends NodeComponent> T withComponent(T component) {
        Objects.requireNonNull(component, "component cannot be null");
        if (this.componentsByClass.containsKey(component.getClass())) {
            return component;
        }
        this.components.add(component);
        ReflectionUtil.walkParents(component.getClass(), c -> !c.isAssignableFrom(NonComponent.class), c -> this.componentsByClass.put((Class<?>)c, component));
        return component;
    }

    public <T extends NodeComponent> Node withComponent(T component, Consumer<T> consumer) {
        T c = this.withComponent(component);
        if (consumer != null) {
            consumer.accept(c);
        }
        return this;
    }

    public Node removeComponent(NodeComponent component) {
        this.components.remove(component);
        ReflectionUtil.walkParents(component.getClass(), c -> !c.isAssignableFrom(NonComponent.class), c -> this.componentsByClass.remove(c, component));
        return this;
    }

    public Node removeComponent(Class<?> klass) {
        return this.removeComponent(this.componentsByClass.get(klass));
    }

    public <T> T getComponentOf(Class<T> klass) {
        return (T)this.componentsByClass.get(klass);
    }

    public <T extends NodeComponent> T getComponent(Class<T> klass) {
        return (T)this.componentsByClass.get(klass);
    }

    public boolean hasComponentOf(Class<?> klass) {
        return this.componentsByClass.containsKey(klass);
    }

    public Node addChild(Node node) {
        if (node == null) {
            return null;
        }
        this.children.add(node);
        this.childrenByName.put(node.name, node);
        if (node.componentsByClass.containsKey(Executable.class)) {
            this.fastMappedChildren.put(node.name, node);
        }
        return node;
    }

    public Node addChild(Node node, Consumer<Node> consumer) {
        consumer.accept(this.addChild(node));
        return this;
    }

    public Node removeChild(Node node) {
        this.children.remove(node);
        this.childrenByName.remove(node.getName());
        if (node.componentsByClass.containsKey(Executable.class)) {
            this.fastMappedChildren.remove(node.name);
        }
        return this;
    }

    public Node getChildByName(String name) {
        return this.childrenByName.get(name);
    }

    public Node getChildByPath(String ... path) {
        Node curr = this;
        for (String p : path) {
            curr = curr.getChildByName(p);
        }
        return curr;
    }

    public Node getChild(String name) {
        return this.childrenByName.get(name);
    }

    public Node getOrCreateChild(String name, Function<Node, Node> constructor) {
        Node node = this.getChild(name);
        if (node != null) {
            return node;
        }
        node = constructor.apply(this);
        this.addChild(node);
        return node;
    }

    public Node propertied(String desc, String label, String usage) {
        this.component(Properties.class, Properties::new, (node, rcp) -> rcp.description(desc).label(label).usage(usage));
        return this;
    }

    public Node executable() {
        return this.executable(null);
    }

    public Node executable(Consumer<Executable> consumer) {
        Executable executable = this.component(Executable.class, Executable::new);
        if (consumer != null) {
            consumer.accept(executable);
        }
        return this;
    }

    public Node executes(CommandNodeExecutor executor) {
        this.component(Executable.class, Executable::new).setExecutor(executor);
        return this;
    }

    public Node setExecutor(Consumer<Context> executor) {
        return this.executes(executor);
    }

    public Node executes(Consumer<Context> executor) {
        this.component(Executable.class, Executable::new).setExecutor((Context ctx, Node cmd) -> executor.accept(ctx));
        return this;
    }

    public Node executes(CommandNodeExecutor executor, CommandNodeExecutor walked) {
        this.component(Executable.class, Executable::new).setExecutor(executor).setWalkExecutor(walked);
        return this;
    }

    public Node argument(ArgumentType<?> type) {
        this.component(Argument.class, Argument::new).setType(type);
        return this;
    }

    public Node argument(ArgumentType<?> type, ArgumentOptions options) {
        this.component(Argument.class, Argument::new).setType(type).setOptions(options);
        return this;
    }

    public Node permission(String perm) {
        this.component(Secure.class, Secure::new, (node, secure) -> secure.setPermission(perm));
        return this;
    }

    public Node flag(Flag<?> flag) {
        this.component(Flags.class, Flags::new, (node, flags) -> flags.addFlag(flag));
        return this;
    }

    public Node flag(String name, Character ch, ArgumentType<?> type, boolean isSwitch) {
        this.component(Flags.class, Flags::new, (node, flags) -> flags.addFlag(name, ch, type, isSwitch));
        return this;
    }

    public Node flag(String name, ArgumentType<?> type) {
        this.component(Flags.class, Flags::new, (node, flags) -> flags.addFlag(name, null, type, false));
        return this;
    }

    public Node thenArgument(String name, ArgumentType<?> type) {
        Node node = new Node(name, this, this.root);
        node.argument(type);
        this.addChild(node);
        return node;
    }

    public Node thenArgument(String name, ArgumentType<?> type, Consumer<Node> consumer) {
        Node node = this.thenArgument(name, type);
        if (consumer != null) {
            consumer.accept(node);
        }
        return this;
    }

    public Node thenArgument(String name, ArgumentType<?> type, BiConsumer<Node, Argument> consumer) {
        Node node = this.thenArgument(name, type);
        if (consumer != null) {
            consumer.accept(node, node.getComponent(Argument.class));
        }
        return this;
    }

    public Node thenArgument(String name, ArgumentType<?> type, ArgumentOptions options) {
        Node node = new Node(name, this, this.root);
        node.argument(type, options);
        this.addChild(node);
        return node;
    }

    public Node thenArgument(String name, ArgumentType<?> type, ArgumentOptions options, Consumer<Node> consumer) {
        Node node = this.thenArgument(name, type, options);
        if (consumer != null) {
            consumer.accept(node);
        }
        return this;
    }

    public Node thenArgument(String name, ArgumentType<?> type, ArgumentOptions options, BiConsumer<Node, Argument> consumer) {
        Node node = this.thenArgument(name, type, options);
        if (consumer != null) {
            consumer.accept(node, node.getComponent(Argument.class));
        }
        return this;
    }

    public Node thenExecute(String name, CommandNodeExecutor executor) {
        Node node = new Node(name, this, this.root);
        node.executes(executor);
        this.addChild(node);
        return node;
    }

    public Node thenExecute(String name, Consumer<Context> executor) {
        return this.thenExecute(name, (Context ctx, Node cmd) -> executor.accept(ctx));
    }

    public Node thenExecute(String name, CommandNodeExecutor executor, Consumer<Node> consumer) {
        Node n = this.thenExecute(name, executor);
        if (consumer != null) {
            consumer.accept(n);
        }
        return this;
    }

    public Node thenExecute(String name, Consumer<Context> executor, Consumer<Node> consumer) {
        return this.thenExecute(name, (Context ctx, Node cmd) -> executor.accept(ctx), consumer);
    }

    public Node thenExecute(String name, CommandNodeExecutor executor, BiConsumer<Node, Executable> consumer) {
        Node n = this.thenExecute(name, executor);
        if (consumer != null) {
            consumer.accept(n, n.getComponent(Executable.class));
        }
        return this;
    }

    public Node thenExecute(String name, CommandNodeExecutor executor, CommandNodeExecutor walked) {
        Node node = new Node(name, this, this.root);
        node.executes(executor, walked);
        this.addChild(node);
        return node;
    }

    public Node thenExecute(String name, CommandNodeExecutor executor, CommandNodeExecutor walked, BiConsumer<Node, Executable> consumer) {
        Node node = this.thenExecute(name, executor, walked);
        if (consumer != null) {
            consumer.accept(node, node.getComponent(Executable.class));
        }
        return this;
    }

    public void printTreeFancy(PrintStream stream) {
        this.printTreeFancyNext(stream, 0);
    }

    private void printTreeFancyNext(PrintStream stream, int depth) {
        if (depth >= 50) {
            stream.println(" ".repeat(depth) + " /!\\ Tree goes too deep! Over 50 entries deep.");
            return;
        }
        Argument param = this.getComponent(Argument.class);
        if (param != null) {
            stream.println(" ".repeat(depth) + "\\" + this.name + " <" + param.getType().getIdentifier() + " " + param.getIdentifier() + ">");
        } else {
            stream.println(" ".repeat(depth) + "/" + this.name);
        }
        for (Node child : this.children) {
            child.printTreeFancyNext(stream, depth + 1);
        }
    }

    static {
        NODE_BLANK.withComponent(new BlankNodeSelector(NODE_BLANK));
    }

    static class BlankNodeSelector
    extends AbstractNodeComponent
    implements Primary {
        public BlankNodeSelector(Node node) {
            super(node);
        }

        @Override
        public boolean selects(Context ctx, StringReader reader) {
            reader.collect(Character::isWhitespace);
            return reader.current() == '\uffff';
        }

        @Override
        public int priority() {
            return Integer.MAX_VALUE;
        }
    }
}

