/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.orbyfied.j8.command.CommandManager;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.Sender;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.impl.DelegatingNamespacedTypeResolver;
import net.orbyfied.j8.command.minecraft.BungeeArgumentTypes;
import org.jetbrains.annotations.NotNull;

public class BungeeCommandManager
extends CommandManager {
    public static final Sender CONSOLE_SENDER = new Sender(){
        final CommandSender sender = ProxyServer.getInstance().getConsole();

        @Override
        public void sendMessage(BaseComponent[] components) {
            this.sender.sendMessage(components);
        }

        @Override
        public boolean hasPermission(String perm) {
            return this.sender.hasPermission(perm);
        }

        @Override
        public Object unwrap() {
            return this.sender;
        }
    };
    private final Plugin plugin;
    private String fallbackPrefix;
    Map<String, RegisteredBungeeCommand> bungeeCommandMap = new HashMap<String, RegisteredBungeeCommand>();

    public static Sender wrapSender(CommandSender sender) {
        if (sender instanceof ProxiedPlayer) {
            final ProxiedPlayer player = (ProxiedPlayer)sender;
            return new Sender(){

                @Override
                public void sendMessage(BaseComponent[] components) {
                    player.sendMessage(components);
                }

                @Override
                public boolean hasPermission(String perm) {
                    return player.hasPermission(perm);
                }

                @Override
                public Object unwrap() {
                    return player;
                }
            };
        }
        return CONSOLE_SENDER;
    }

    public BungeeCommandManager(Plugin plugin) {
        this.plugin = plugin;
        this.fallbackPrefix = plugin.getDescription().getName().toLowerCase(Locale.ROOT);
        ((DelegatingNamespacedTypeResolver)this.getTypeResolver()).namespace("bungee", BungeeArgumentTypes.typeResolver);
    }

    public BungeeCommandManager setFallbackPrefix(String fallbackPrefix) {
        this.fallbackPrefix = fallbackPrefix;
        return this;
    }

    public String getFallbackPrefix() {
        return this.fallbackPrefix;
    }

    @Override
    protected void registerPlatform(Node root) {
        RegisteredBungeeCommand command = new RegisteredBungeeCommand(this, root);
        this.bungeeCommandMap.put(root.getName(), command);
        ProxyServer.getInstance().getPluginManager().registerCommand(this.plugin, (Command)command);
    }

    @Override
    protected void unregisterPlatform(Node root) {
        RegisteredBungeeCommand command = this.bungeeCommandMap.get(root.getName());
        if (command == null) {
            return;
        }
        ProxyServer.getInstance().getPluginManager().unregisterCommand((Command)command);
    }

    @Override
    public void enablePlatform() {
    }

    @Override
    public void disablePlatform() {
    }

    private static String stitchArgs(String label, String[] args) {
        String[] ls = label.split(":");
        String l = ls.length == 1 ? ls[0] : ls[1];
        StringBuilder b = new StringBuilder(l);
        for (String s : args) {
            b.append(" ").append(s);
        }
        return b.toString();
    }

    private static SuggestionAccumulator createSuggestionAccumulator(final List<String> list) {
        return new SuggestionAccumulator(){

            @Override
            public void suggest0(String s) {
                list.add(s);
            }

            @Override
            public void unsuggest0(String o) {
                if (o != null) {
                    list.remove(o);
                }
            }
        };
    }

    static class RegisteredBungeeCommand
    extends Command
    implements TabExecutor {
        protected final CommandManager engine;
        protected final Node node;

        protected RegisteredBungeeCommand(CommandManager engine, Node node) {
            super(node.getName(), "", node.getAliases().toArray(new String[0]));
            this.engine = engine;
            this.node = node;
        }

        public void execute(@NotNull CommandSender sender, @NotNull String[] args) {
            String str = BungeeCommandManager.stitchArgs(this.getName(), args);
            Context ctx = this.engine.dispatch(BungeeCommandManager.wrapSender(sender), str, null, null);
            if (ctx.intermediateText() != null && ctx.intermediateText().length != 0) {
                sender.sendMessage(ctx.intermediateText());
            }
        }

        public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
            ArrayList<String> list = new ArrayList<String>();
            String str = BungeeCommandManager.stitchArgs(this.getName(), args);
            Context ctx = this.engine.dispatch(BungeeCommandManager.wrapSender(sender), str, BungeeCommandManager.createSuggestionAccumulator(list), null);
            return list;
        }
    }
}

