/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.exception;

import net.md_5.bungee.api.ChatColor;
import net.orbyfied.j8.util.StringReader;

public class ErrorLocation {
    protected StringReader reader;
    protected int fromIndex;
    protected int toIndex;

    public ErrorLocation(StringReader reader, int fromIndex, int toIndex) {
        this.reader = reader;
        if (fromIndex > toIndex) {
            toIndex = fromIndex = toIndex;
        }
        this.fromIndex = Math.min(reader.getString().length() - 1, fromIndex);
        this.toIndex = Math.max(reader.getString().length() - 1, toIndex);
    }

    public int getStartIndex() {
        return this.fromIndex;
    }

    public int getEndIndex() {
        return this.toIndex;
    }

    public StringReader getReader() {
        return this.reader;
    }

    public String getLocationString() {
        return this.getLocationString(10);
    }

    public String getLocationString(int off) {
        Object str = this.reader.getString();
        StringBuilder b = new StringBuilder();
        b.append(ChatColor.RED).append("(").append(this.fromIndex).append(":").append(this.toIndex).append(")").append(ChatColor.RESET);
        if (this.toIndex >= ((String)str).length()) {
            str = (String)str + " ";
        }
        int l = ((String)str).length();
        int ss = Math.max(0, Math.min(l, this.fromIndex - off));
        int se = Math.max(0, Math.min(l, this.fromIndex));
        int bs = Math.max(0, Math.min(l, this.fromIndex));
        int be = Math.max(0, Math.min(l, this.toIndex + 1));
        int es = Math.max(0, Math.min(l, this.toIndex + 1));
        int ee = Math.max(0, Math.min(l, this.toIndex + off));
        b.append("" + ChatColor.RESET + ChatColor.DARK_GRAY).append("...").append("" + ChatColor.RESET + ChatColor.GRAY).append(((String)str).substring(ss, se)).append("" + ChatColor.RESET + ChatColor.RED + ChatColor.UNDERLINE).append(((String)str).substring(bs, be)).append("" + ChatColor.RESET + ChatColor.GRAY).append(((String)str).substring(es, ee)).append("" + ChatColor.RESET + ChatColor.DARK_GRAY).append("...");
        return b.toString();
    }
}

