/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.orbyfied.j8.command.AbstractNodeComponent;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.argument.ArgumentType;
import net.orbyfied.j8.command.argument.Flag;
import net.orbyfied.j8.command.component.Functional;
import net.orbyfied.j8.util.StringReader;

public class Flags
extends AbstractNodeComponent
implements Functional {
    List<Flag<?>> flags = new ArrayList();
    Map<String, Flag<?>> flagsByName = new HashMap();

    public Flags(Node node) {
        super(node);
    }

    public List<Flag<?>> getFlags() {
        return Collections.unmodifiableList(this.flags);
    }

    public Flag<?> getFlag(String name) {
        return this.flagsByName.get(name);
    }

    public Flags removeFlag(Flag<?> flag) {
        this.flags.remove(flag);
        this.flagsByName.remove(flag.getName());
        return this;
    }

    public Flags removeFlag(String name) {
        return this.removeFlag(this.getFlag(name));
    }

    public Flags addFlag(Flag<?> flag) {
        this.flags.add(flag);
        this.flagsByName.put(flag.getName(), flag);
        return this;
    }

    public Flags addFlag(String name, Character ch, ArgumentType<?> type, boolean isSwitch) {
        return this.addFlag(new Flag(this, name, ch, type, isSwitch));
    }

    @Override
    public void walked(Context ctx, StringReader reader) {
        for (Flag<?> fl : this.flags) {
            ctx.pushFlag(fl);
        }
    }

    @Override
    public void execute(Context ctx) {
    }
}

