/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.argument;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.argument.ArgumentType;
import net.orbyfied.j8.command.argument.GenericArgumentType;
import net.orbyfied.j8.command.argument.TypeIdentifier;
import net.orbyfied.j8.util.StringReader;

public class GenericTypeInstance<B>
implements ArgumentType<B> {
    final GenericArgumentType<B> base;
    final LinkedHashMap<String, ArgumentType> params = new LinkedHashMap();

    public GenericTypeInstance(GenericArgumentType<B> base, ArgumentType ... types) {
        this(base, Arrays.asList(types));
    }

    public GenericTypeInstance(GenericArgumentType<B> base, List<ArgumentType> types) {
        this.base = base;
        int l = types.size();
        if (l != base.getTypeParameters().size()) {
            throw new IllegalArgumentException("Invalid amount of type parameters.");
        }
        List<String> paramNames = base.getTypeParameters();
        for (int i = 0; i < l; ++i) {
            this.params.put(paramNames.get(i), types.get(i));
        }
    }

    public GenericArgumentType<B> getBase() {
        return this.base;
    }

    @Override
    public TypeIdentifier getIdentifier() {
        TypeIdentifier id = this.getBaseIdentifier().clone();
        for (ArgumentType pt : this.params.values()) {
            id.getTypeParameters().add(pt.getIdentifier());
        }
        return id;
    }

    @Override
    public TypeIdentifier getBaseIdentifier() {
        return this.base.getBaseIdentifier();
    }

    @Override
    public Class<?> getType() {
        return this.base.getType();
    }

    @Override
    public boolean accepts(Context context, StringReader reader) {
        return this.base.accepts(context, reader, this.params);
    }

    @Override
    public B parse(Context context, StringReader reader) {
        return this.base.parse(context, reader, this.params);
    }

    @Override
    public void write(Context context, StringBuilder builder, B v) {
        this.base.write(context, builder, v, this.params);
    }

    @Override
    public void suggest(Context context, SuggestionAccumulator suggestions) {
        this.base.suggest(context, suggestions, this.params);
    }
}

