/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command.argument;

import java.util.LinkedHashMap;
import java.util.function.Supplier;
import net.orbyfied.j8.command.AbstractNodeComponent;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.argument.ArgumentType;
import net.orbyfied.j8.command.argument.options.ArgumentCompleter;
import net.orbyfied.j8.command.argument.options.ArgumentOptions;
import net.orbyfied.j8.command.component.Completer;
import net.orbyfied.j8.command.component.Functional;
import net.orbyfied.j8.command.component.Primary;
import net.orbyfied.j8.command.exception.ErrorLocation;
import net.orbyfied.j8.command.exception.NodeParseException;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.StringReader;

public class Argument
extends AbstractNodeComponent
implements Functional,
Primary,
Completer {
    protected Identifier identifier;
    protected ArgumentType<?> type;
    protected ArgumentOptions options;
    protected LinkedHashMap<String, Supplier<Object>> optionMap = new LinkedHashMap();

    public Argument(Node node) {
        super(node);
        Node parent = node;
        while ((parent = parent.parent()).hasComponentOf(Argument.class)) {
        }
        this.identifier = new Identifier(null, node.getName());
    }

    public ArgumentOptions getOptions() {
        return this.options;
    }

    public Argument setOptions(ArgumentOptions options) {
        this.options = options;
        return this;
    }

    public Argument setIdentifier(Identifier id) {
        this.identifier = id;
        return this;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Argument setType(ArgumentType<?> type) {
        this.type = type;
        return this;
    }

    public ArgumentType<?> getType() {
        return this.type;
    }

    @Override
    public void walked(Context ctx, StringReader reader) {
        Object v;
        int startIndex = reader.index();
        try {
            v = this.type.parse(ctx, reader);
        }
        catch (Exception e) {
            if (e instanceof NodeParseException) {
                throw e;
            }
            int endIndex = reader.index();
            throw new NodeParseException(this.node.root(), this.node, new ErrorLocation(reader, startIndex, endIndex), e);
        }
        ctx.setArgument(this.identifier, v);
    }

    @Override
    public void execute(Context ctx) {
    }

    @Override
    public boolean selects(Context ctx, StringReader reader) {
        return this.type.accepts(ctx, reader);
    }

    @Override
    public int priority() {
        return this.options != null ? this.options.priority() : 0;
    }

    @Override
    public void complete(Context context, SuggestionAccumulator suggestions, StringReader reader) {
        this.type.suggest(context, suggestions);
        if (this.options != null) {
            for (ArgumentCompleter completer : this.options.completers()) {
                completer.complete(this, context, suggestions);
            }
        }
    }
}

