/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.orbyfied.j8.command.CommandManager;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.Sender;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.argument.Argument;
import net.orbyfied.j8.command.argument.Flag;
import net.orbyfied.j8.command.argument.options.ArgumentOptions;
import net.orbyfied.j8.command.exception.CommandHaltException;
import net.orbyfied.j8.registry.Identifier;
import net.orbyfied.j8.util.StringReader;

public class Context {
    protected final Sender sender;
    protected Target target;
    protected Node rootCommand;
    protected final HashMap<Identifier, Object> argValues = new HashMap();
    protected final CommandManager engine;
    protected BaseComponent[] intermediateText;
    protected boolean canFormat = true;
    protected Boolean successful;
    protected StringReader reader;
    protected Node current;
    protected List<Flag<?>> flags = new ArrayList();
    protected Map<String, Flag<?>> flagsByName = new HashMap();
    protected Map<Character, Flag<?>> flagsByChar = new HashMap();
    protected Map<Flag<?>, Object> flagValues = new HashMap();
    protected Map<String, Object> foreignFlagValues = new HashMap<String, Object>();
    protected SuggestionAccumulator suggestions;

    public Context(CommandManager engine, Sender sender) {
        this.engine = engine;
        this.sender = sender;
    }

    public Context canFormat(boolean canFormat) {
        this.canFormat = canFormat;
        return this;
    }

    public CommandManager manager() {
        return this.engine;
    }

    public Sender wrappedSender() {
        return this.sender;
    }

    public <S extends org.bukkit.command.CommandSender> S bukkitSender() {
        return (S)((org.bukkit.command.CommandSender)this.sender.as());
    }

    public <S extends CommandSender> S bungeeSender() {
        return (S)((CommandSender)this.sender.as());
    }

    public <S> S sender() {
        return (S)this.sender.as();
    }

    public boolean senderIs(Class<?> cClass) {
        return this.sender.is(cClass);
    }

    public Target target() {
        return this.target;
    }

    public boolean isSuggesting() {
        return this.target == Target.SUGGEST;
    }

    public BaseComponent[] intermediateText() {
        return this.intermediateText;
    }

    public Context intermediateText(String text) {
        if (!this.canFormat) {
            text = ChatColor.stripColor((String)text);
        }
        this.intermediateText(TextComponent.fromLegacyText((String)text));
        return this;
    }

    public Context intermediateText(BaseComponent[] components) {
        this.intermediateText = components;
        return this;
    }

    public Context successful(boolean b) {
        this.successful = b;
        return this;
    }

    public Boolean successful() {
        return this.successful;
    }

    public Context target(Target target) {
        this.target = target;
        return this;
    }

    public SuggestionAccumulator suggestions() {
        return this.suggestions;
    }

    public Node rootCommand() {
        return this.rootCommand;
    }

    public StringReader reader() {
        return this.reader;
    }

    public Node currentNode() {
        return this.current;
    }

    public <O extends ArgumentOptions> O argumentOptions(Class<O> oClass) {
        ArgumentOptions options;
        Argument argument = this.currentNode().getComponent(Argument.class);
        if (argument == null || (options = argument.getOptions()) == null) {
            return null;
        }
        if (!oClass.isAssignableFrom(options.getClass())) {
            return null;
        }
        return (O)options;
    }

    public Context halt(boolean success, String message) {
        throw new CommandHaltException(this.rootCommand, message).setSuccessful(success);
    }

    public Context halt(boolean success, Throwable t) {
        throw new CommandHaltException(this.rootCommand, t).setSuccessful(success);
    }

    public Context halt(boolean success, String message, Throwable t) {
        throw new CommandHaltException(this.rootCommand, message, t).setSuccessful(success);
    }

    public Context fail(String message) {
        return this.halt(false, message);
    }

    public Context fail(Throwable t) {
        return this.halt(false, t);
    }

    public Context fail(String message, Throwable t) {
        return this.halt(false, message, t);
    }

    public HashMap<Identifier, Object> getArgumentValues() {
        return this.argValues;
    }

    public <T> T getArgument(Identifier identifier) {
        return (T)this.argValues.get(identifier);
    }

    public <T> T getArgument(String id) {
        return this.getArgument(Identifier.of((String)id));
    }

    public <T> T getArgument(Identifier identifier, Class<T> tClass) {
        return (T)this.argValues.get(identifier);
    }

    public <T> T getArgument(String id, Class<T> tClass) {
        return this.getArgument(Identifier.of((String)id), tClass);
    }

    public boolean hasArgument(Identifier identifier) {
        return this.argValues.containsKey(identifier);
    }

    public boolean hasArgument(String id) {
        return this.hasArgument(Identifier.of((String)id));
    }

    public Context setArgument(Identifier id, Object o) {
        this.argValues.put(id, o);
        return this;
    }

    public Context setArgument(String id, Object o) {
        return this.setArgument(Identifier.of((String)id), o);
    }

    public Context unsetArgument(Identifier id) {
        this.argValues.remove(id);
        return this;
    }

    public Context unsetArgument(String id) {
        return this.unsetArgument(Identifier.of((String)id));
    }

    public Context pushFlag(Flag<?> flag) {
        this.flags.add(flag);
        this.flagsByName.put(flag.getName(), flag);
        Character c = flag.getCharacter();
        if (c != null) {
            this.flagsByChar.put(c, flag);
        }
        return this;
    }

    public List<Flag<?>> getFlags() {
        return this.flags;
    }

    public Flag<?> getFlagByName(String name) {
        return this.flagsByName.get(name);
    }

    public Flag<?> getFlagByCharacter(char c) {
        return this.flagsByChar.get(Character.valueOf(c));
    }

    public <T> T getFlagValue(Flag<T> flag) {
        if (flag == null) {
            return null;
        }
        Object res = !this.flagValues.containsKey(flag) ? flag.getDefault() : this.flagValues.get(flag);
        return res;
    }

    public <T> T getFlagValue(String name) {
        Flag<?> flag = this.flagsByName.get(name);
        if (flag == null) {
            return (T)this.foreignFlagValues.get(name);
        }
        return (T)this.getFlagValue(flag);
    }

    public <T> T getFlagValue(String name, Class<T> tClass) {
        return this.getFlagValue(name);
    }

    public <T> T getFlagValue(Flag<?> flag, T ifUnset) {
        if (flag == null) {
            return ifUnset;
        }
        if (!this.flagValues.containsKey(flag)) {
            return ifUnset;
        }
        return (T)this.getFlagValue(flag);
    }

    public <T> T getFlagValue(Flag<?> flag, Class<T> tClass, T ifUnset) {
        if (flag == null) {
            return ifUnset;
        }
        if (!this.flagValues.containsKey(flag)) {
            return ifUnset;
        }
        return (T)this.getFlagValue(flag);
    }

    public <T> T getFlagValue(String name, Class<T> tClass, T ifUnset) {
        Flag<?> flag = this.flagsByName.get(name);
        if (flag == null) {
            return (T)this.foreignFlagValues.getOrDefault(name, ifUnset);
        }
        return this.getFlagValue(flag, ifUnset);
    }

    public static enum Target {
        SUGGEST,
        EXECUTE;

    }
}

