/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import net.orbyfied.j8.command.Context;
import net.orbyfied.j8.command.Node;
import net.orbyfied.j8.command.Sender;
import net.orbyfied.j8.command.SuggestionAccumulator;
import net.orbyfied.j8.command.argument.ArgumentTypes;
import net.orbyfied.j8.command.argument.TypeResolver;
import net.orbyfied.j8.command.exception.CommandException;
import net.orbyfied.j8.command.exception.CommandHaltException;
import net.orbyfied.j8.command.impl.DelegatingNamespacedTypeResolver;
import net.orbyfied.j8.util.StringReader;

public abstract class CommandManager {
    TypeResolver typeResolver;
    ArrayList<Node> commands = new ArrayList();
    HashMap<String, Node> aliases = new HashMap();

    public CommandManager() {
        this.typeResolver = new DelegatingNamespacedTypeResolver().namespace("system", ArgumentTypes.typeResolver);
    }

    public CommandManager register(Node command) {
        this.commands.add(command);
        this.aliases.put(command.getName(), command);
        for (String alias : command.aliases) {
            this.aliases.put(alias, command);
        }
        this.registerPlatform(command);
        return this;
    }

    public CommandManager unregister(Node command) {
        this.commands.remove(command);
        this.aliases.remove(command.getName(), command);
        for (String alias : command.aliases) {
            this.aliases.remove(alias, command);
        }
        this.unregisterPlatform(command);
        return this;
    }

    public CommandManager setTypeResolver(TypeResolver resolver) {
        this.typeResolver = resolver;
        return this;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    protected abstract void registerPlatform(Node var1);

    protected abstract void unregisterPlatform(Node var1);

    public abstract void enablePlatform();

    public abstract void disablePlatform();

    public Context dispatch(Sender sender, String str, SuggestionAccumulator suggestions, Consumer<Context> ctxConsumer) {
        String alias;
        Node root;
        boolean isSuggesting = suggestions != null;
        Context.Target target = isSuggesting ? Context.Target.SUGGEST : Context.Target.EXECUTE;
        StringReader reader = new StringReader(str, 0);
        Context context = new Context(this, sender);
        context.target(target);
        if (ctxConsumer != null) {
            ctxConsumer.accept(context);
        }
        context.successful(true);
        context.suggestions = suggestions;
        if (suggestions != null) {
            suggestions.withContext(context);
        }
        if ((root = this.aliases.get(alias = reader.collect(c -> c.charValue() != ' ', 0))) == null) {
            return null;
        }
        context.rootCommand = root;
        context.reader = reader;
        try {
            root.walk(context, null, reader.index(0).branch());
        }
        catch (CommandException e) {
            if (e instanceof CommandHaltException) {
                CommandHaltException ec = (CommandHaltException)e;
                boolean success = ec.isSuccessful();
                if (ec.getMessage() != null || ec.getCause() != null) {
                    StringBuilder b = new StringBuilder();
                    if (success) {
                        b.append(ChatColor.GREEN + ChatColor.BOLD + "\u2714 " + ChatColor.GREEN);
                    } else {
                        b.append(ChatColor.RED + ChatColor.BOLD + "\u2716 " + ChatColor.RED);
                    }
                    if (ec.getMessage() != null) {
                        b.append(ec.getMessage());
                    }
                    if (ec.getCause() != null) {
                        b.append(ChatColor.DARK_GRAY).append(" (").append(ChatColor.RED).append(ec.getCause()).append(ChatColor.DARK_GRAY).append(")");
                    }
                    context.intermediateText(b.toString());
                }
                context.successful(success);
            }
            if (e.isSevere()) {
                e.printStackTrace();
            }
            context.intermediateText(e.getFormattedString());
            context.successful(false);
        }
        return context;
    }

    public Node command(String name) {
        Node node = new Node(name, null, null);
        node.executable();
        node.root = node;
        this.register(node);
        return node;
    }

    public Node newCommand(String name, Consumer<Node> consumer) {
        Node node = new Node(name, null, null);
        node.executable();
        node.root = node;
        if (consumer != null) {
            consumer.accept(node);
        }
        this.register(node);
        return node;
    }
}

