/*
 * Decompiled with CFR 0.152.
 */
package net.orange_box.storebox.utils;

import android.net.Uri;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.orange_box.storebox.adapters.StoreBoxTypeAdapter;
import net.orange_box.storebox.adapters.extra.DateTypeAdapter;
import net.orange_box.storebox.adapters.extra.EnumTypeAdapter;
import net.orange_box.storebox.adapters.extra.UriTypeAdapter;
import net.orange_box.storebox.adapters.standard.BooleanTypeAdapter;
import net.orange_box.storebox.adapters.standard.FloatTypeAdapter;
import net.orange_box.storebox.adapters.standard.IntegerTypeAdapter;
import net.orange_box.storebox.adapters.standard.LongTypeAdapter;
import net.orange_box.storebox.adapters.standard.StringSetTypeAdapter;
import net.orange_box.storebox.adapters.standard.StringTypeAdapter;
import net.orange_box.storebox.annotations.method.TypeAdapter;

public final class TypeUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_BOXED_MAP;
    private static final Map<Class<?>, StoreBoxTypeAdapter> ADAPTERS_MAP;

    public static Class<?> wrapToBoxedType(Class<?> type) {
        if (type.isPrimitive() && PRIMITIVE_TO_BOXED_MAP.containsKey(type)) {
            return PRIMITIVE_TO_BOXED_MAP.get(type);
        }
        return type;
    }

    public static StoreBoxTypeAdapter getTypeAdapter(Class<?> type, TypeAdapter annotation) {
        if (ADAPTERS_MAP.containsKey(type)) {
            return ADAPTERS_MAP.get(type);
        }
        if (type.isEnum()) {
            return new EnumTypeAdapter(type);
        }
        if (annotation == null) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to find type adapter for %1$s", type.getName()));
        }
        try {
            return annotation.value().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to instantiate %1$s, perhaps the no-arguments constructor is missing?", annotation.value().getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to instantiate %1$s, perhaps the no-arguments constructor is not public?", annotation.value().getSimpleName()), e);
        }
    }

    private TypeUtils() {
    }

    static {
        HashMap<Class<Object>, Class<Object>> map = new HashMap(4);
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Float.TYPE, Float.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_BOXED_MAP = map;
        map = new HashMap(8);
        map.put((Class<Object>)Boolean.class, (Class<Object>)((Object)new BooleanTypeAdapter()));
        map.put(Float.class, (Class<Object>)((Object)new FloatTypeAdapter()));
        map.put(Integer.class, (Class<Object>)((Object)new IntegerTypeAdapter()));
        map.put(Long.class, (Class<Object>)((Object)new LongTypeAdapter()));
        map.put(String.class, (Class<Object>)((Object)new StringTypeAdapter()));
        map.put(Set.class, (Class<Object>)((Object)new StringSetTypeAdapter()));
        map.put(Date.class, (Class<Object>)((Object)new DateTypeAdapter()));
        map.put(Uri.class, (Class<Object>)((Object)new UriTypeAdapter()));
        ADAPTERS_MAP = map;
    }
}

