/*
 * Decompiled with CFR 0.152.
 */
package net.orange_box.storebox.utils;

import android.annotation.TargetApi;
import android.content.SharedPreferences;
import android.os.Build;
import java.util.Locale;
import java.util.Set;
import net.orange_box.storebox.adapters.StoreType;
import net.orange_box.storebox.enums.SaveMode;

public final class PreferenceUtils {
    public static Object getValue(SharedPreferences prefs, String key, StoreType type, Object defValue) {
        switch (type) {
            case BOOLEAN: {
                return prefs.getBoolean(key, ((Boolean)defValue).booleanValue());
            }
            case FLOAT: {
                return Float.valueOf(prefs.getFloat(key, ((Float)defValue).floatValue()));
            }
            case INTEGER: {
                return prefs.getInt(key, ((Integer)defValue).intValue());
            }
            case LONG: {
                return prefs.getLong(key, ((Long)defValue).longValue());
            }
            case STRING: {
                return prefs.getString(key, (String)defValue);
            }
            case STRING_SET: {
                if (Build.VERSION.SDK_INT < 11) break;
                return PreferenceUtils.getStringSetApi11(prefs, key, (Set)defValue);
            }
        }
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Retrieving type %1$s from the preferences is not supported", type.name()));
    }

    public static void putValue(SharedPreferences.Editor editor, String key, StoreType type, Object value) {
        switch (type) {
            case BOOLEAN: {
                editor.putBoolean(key, ((Boolean)value).booleanValue());
                break;
            }
            case FLOAT: {
                editor.putFloat(key, ((Float)value).floatValue());
                break;
            }
            case INTEGER: {
                editor.putInt(key, ((Integer)value).intValue());
                break;
            }
            case LONG: {
                editor.putLong(key, ((Long)value).longValue());
                break;
            }
            case STRING: {
                editor.putString(key, (String)value);
                break;
            }
            case STRING_SET: {
                if (Build.VERSION.SDK_INT >= 11) {
                    PreferenceUtils.putStringSetApi11(editor, key, (Set)value);
                    break;
                }
            }
            default: {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Saving type %1$s into the preferences is not supported", type.name()));
            }
        }
    }

    public static void saveChanges(SharedPreferences.Editor editor, SaveMode mode) {
        switch (mode) {
            case APPLY: {
                editor.apply();
                break;
            }
            case COMMIT: {
                editor.commit();
                break;
            }
        }
    }

    @TargetApi(value=11)
    private static Set<String> getStringSetApi11(SharedPreferences prefs, String key, Set<String> defValue) {
        return prefs.getStringSet(key, defValue);
    }

    @TargetApi(value=11)
    private static void putStringSetApi11(SharedPreferences.Editor editor, String key, Set<String> value) {
        editor.putStringSet(key, value);
    }

    private PreferenceUtils() {
    }
}

