/*
 * Decompiled with CFR 0.152.
 */
package net.orange_box.storebox.utils;

import android.content.res.Resources;
import java.lang.reflect.Method;
import net.orange_box.storebox.utils.TypeUtils;

public final class MethodUtils {
    public static String getKeyForRemove(Resources res, Object ... args) {
        if (args != null && args.length > 0) {
            Object value = args[0];
            Class<?> type = TypeUtils.wrapToBoxedType(value.getClass());
            if (type == String.class) {
                return (String)value;
            }
            if (type == Integer.class) {
                return res.getString(((Integer)value).intValue());
            }
            throw new UnsupportedOperationException("Only String or int supported for remove method");
        }
        throw new UnsupportedOperationException("String or int key argument not found for remove method");
    }

    public static Object getValueArg(Object ... args) {
        if (args != null && args.length > 0) {
            return args[0];
        }
        throw new UnsupportedOperationException("Value argument not found");
    }

    public static Class<?> getValueParameterType(Method method) {
        Class<?>[] types = method.getParameterTypes();
        if (types != null && types.length > 0) {
            return TypeUtils.wrapToBoxedType(types[0]);
        }
        throw new UnsupportedOperationException("Value parameter type not found");
    }

    public static Method getObjectMethod(String name, Class ... types) {
        try {
            return Object.class.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private MethodUtils() {
    }
}

