/*
 * Decompiled with CFR 0.152.
 */
package net.orange_box.storebox;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.preference.PreferenceManager;
import android.util.TypedValue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Locale;
import net.orange_box.storebox.adapters.StoreBoxTypeAdapter;
import net.orange_box.storebox.annotations.method.DefaultValue;
import net.orange_box.storebox.annotations.method.KeyByResource;
import net.orange_box.storebox.annotations.method.KeyByString;
import net.orange_box.storebox.annotations.method.RemoveMethod;
import net.orange_box.storebox.annotations.method.TypeAdapter;
import net.orange_box.storebox.annotations.option.SaveOption;
import net.orange_box.storebox.enums.PreferencesMode;
import net.orange_box.storebox.enums.PreferencesType;
import net.orange_box.storebox.enums.SaveMode;
import net.orange_box.storebox.utils.MethodUtils;
import net.orange_box.storebox.utils.PreferenceUtils;
import net.orange_box.storebox.utils.TypeUtils;

@SuppressLint(value={"CommitPrefEdits"})
class StoreBoxInvocationHandler
implements InvocationHandler {
    private static final Method OBJECT_EQUALS = MethodUtils.getObjectMethod("equals", Object.class);
    private static final Method OBJECT_HASHCODE = MethodUtils.getObjectMethod("hashCode", new Class[0]);
    private static final Method OBJECT_TOSTRING = MethodUtils.getObjectMethod("toString", new Class[0]);
    private final SharedPreferences prefs;
    private final SharedPreferences.Editor editor;
    private final Resources res;
    private final SaveMode saveMode;
    private int hashCode;

    public StoreBoxInvocationHandler(Context context, PreferencesType preferencesType, String openNameValue, PreferencesMode preferencesMode, SaveMode saveMode) {
        switch (preferencesType) {
            case ACTIVITY: {
                this.prefs = ((Activity)context).getPreferences(preferencesMode.value());
                break;
            }
            case FILE: {
                this.prefs = context.getSharedPreferences(openNameValue, preferencesMode.value());
                break;
            }
            default: {
                this.prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            }
        }
        this.editor = this.prefs.edit();
        this.res = context.getResources();
        this.saveMode = saveMode;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
        boolean isRemove;
        String key;
        if (method.isAnnotationPresent(KeyByString.class)) {
            key = method.getAnnotation(KeyByString.class).value();
            isRemove = method.isAnnotationPresent(RemoveMethod.class);
        } else if (method.isAnnotationPresent(KeyByResource.class)) {
            key = this.res.getString(method.getAnnotation(KeyByResource.class).value());
            isRemove = method.isAnnotationPresent(RemoveMethod.class);
        } else if (method.isAnnotationPresent(RemoveMethod.class)) {
            isRemove = true;
            key = MethodUtils.getKeyForRemove(this.res, args);
        } else {
            if (method.equals(OBJECT_EQUALS)) {
                return this.internalEquals(proxy, args[0]);
            }
            if (method.equals(OBJECT_HASHCODE)) {
                return this.internalHashCode();
            }
            if (method.equals(OBJECT_TOSTRING)) {
                return this.toString();
            }
            try {
                Method prefsMethod = this.prefs.getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
                return prefsMethod.invoke((Object)this.prefs, args);
            }
            catch (NoSuchMethodException prefsMethod) {
                try {
                    Method editorMethod = this.editor.getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
                    return editorMethod.invoke((Object)this.editor, args);
                }
                catch (NoSuchMethodException editorMethod) {
                    throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Failed to invoke %1$s method, perhaps the %2$s or %3$s annotation is missing?", method.getName(), KeyByString.class.getSimpleName(), KeyByResource.class.getSimpleName()));
                }
            }
        }
        Class<?> returnType = method.getReturnType();
        if (isRemove) {
            this.editor.remove(key);
        } else if (returnType == Void.TYPE || returnType == method.getDeclaringClass() || returnType == SharedPreferences.Editor.class) {
            StoreBoxTypeAdapter adapter = TypeUtils.getTypeAdapter(MethodUtils.getValueParameterType(method), method.getAnnotation(TypeAdapter.class));
            Object value = adapter.adaptForPreferences(MethodUtils.getValueArg(args));
            PreferenceUtils.putValue(this.editor, key, adapter.getStoreType(), value);
        } else {
            StoreBoxTypeAdapter adapter = TypeUtils.getTypeAdapter(TypeUtils.wrapToBoxedType(method.getReturnType()), method.getAnnotation(TypeAdapter.class));
            Object defValue = this.getDefaultValueArg(method, args);
            Object value = PreferenceUtils.getValue(this.prefs, key, adapter.getStoreType(), defValue == null ? adapter.getDefaultValue() : adapter.adaptForPreferences(defValue));
            return adapter.adaptFromPreferences(value);
        }
        SaveMode mode = method.isAnnotationPresent(SaveOption.class) ? method.getAnnotation(SaveOption.class).value() : this.saveMode;
        PreferenceUtils.saveChanges(this.editor, mode);
        if (returnType == method.getDeclaringClass()) {
            return proxy;
        }
        if (returnType == SharedPreferences.Editor.class) {
            return this.editor;
        }
        return null;
    }

    private boolean internalEquals(Object us, Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != us.getClass()) {
            return false;
        }
        InvocationHandler otherHandler = Proxy.getInvocationHandler(other);
        return otherHandler instanceof StoreBoxInvocationHandler && us == other;
    }

    private int internalHashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(new Object[]{this.prefs, this.editor, this.res, this.saveMode});
        }
        return this.hashCode;
    }

    private Object getDefaultValueArg(Method method, Object ... args) {
        Object result = null;
        Class<?> type = TypeUtils.wrapToBoxedType(method.getReturnType());
        if (args != null && args.length > 0) {
            result = args[0];
        }
        if (result == null && method.isAnnotationPresent(DefaultValue.class)) {
            TypedValue value = new TypedValue();
            this.res.getValue(method.getAnnotation(DefaultValue.class).value(), value, true);
            if (type == Boolean.class) {
                result = value.data != 0;
            } else if (type == Float.class) {
                result = Float.valueOf(value.getFloat());
            } else if (type == Integer.class) {
                result = value.data;
            } else if (type == Long.class) {
                result = value.data;
            } else if (type == String.class) {
                result = value.string == null ? new Object() : value.string;
            } else {
                throw new UnsupportedOperationException(type.getName() + " not supported as a resource default");
            }
        }
        if (result == null) {
            return null;
        }
        if (!type.isAssignableFrom(result.getClass())) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Return type %1$s and default value type %2$s not the same", result.getClass().getName(), type.getName()));
        }
        return result;
    }
}

