/*
 * Decompiled with CFR 0.152.
 */
package net.orange_box.storebox;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Locale;
import net.orange_box.storebox.StoreBoxInvocationHandler;
import net.orange_box.storebox.annotations.option.SaveOption;
import net.orange_box.storebox.annotations.type.ActivityPreferences;
import net.orange_box.storebox.annotations.type.DefaultSharedPreferences;
import net.orange_box.storebox.annotations.type.FilePreferences;
import net.orange_box.storebox.enums.PreferencesMode;
import net.orange_box.storebox.enums.PreferencesType;
import net.orange_box.storebox.enums.SaveMode;

public final class StoreBox {
    public static <T> T create(Context context, Class<T> cls) {
        return new Builder<T>(context, cls).build();
    }

    private StoreBox() {
    }

    public static class Builder<T> {
        private final Context context;
        private final Class<T> cls;
        private PreferencesType preferencesType = PreferencesType.DEFAULT_SHARED;
        private String preferencesName = "";
        private PreferencesMode preferencesMode = PreferencesMode.MODE_PRIVATE;
        private SaveMode saveMode = SaveMode.APPLY;

        public Builder(Context context, Class<T> cls) {
            this.context = context;
            this.cls = cls;
            this.readAnnotations();
        }

        public Builder preferencesType(PreferencesType value) {
            this.preferencesType = value;
            return this;
        }

        public Builder preferencesType(PreferencesType value, String name) {
            this.preferencesType = value;
            this.preferencesName = name;
            return this;
        }

        public Builder preferencesMode(PreferencesMode value) {
            this.preferencesMode = value;
            return this;
        }

        public Builder saveMode(SaveMode value) {
            this.saveMode = value;
            return this;
        }

        public T build() {
            this.validate();
            return (T)Proxy.newProxyInstance(this.cls.getClassLoader(), new Class[]{this.cls}, (InvocationHandler)new StoreBoxInvocationHandler(this.context, this.preferencesType, this.preferencesName, this.preferencesMode, this.saveMode));
        }

        private void readAnnotations() {
            if (this.cls.isAnnotationPresent(DefaultSharedPreferences.class)) {
                this.preferencesType(PreferencesType.DEFAULT_SHARED);
            } else if (this.cls.isAnnotationPresent(ActivityPreferences.class)) {
                ActivityPreferences annotation = this.cls.getAnnotation(ActivityPreferences.class);
                this.preferencesType(PreferencesType.ACTIVITY);
                this.preferencesMode(annotation.mode());
            } else if (this.cls.isAnnotationPresent(FilePreferences.class)) {
                FilePreferences annotation = this.cls.getAnnotation(FilePreferences.class);
                this.preferencesType(PreferencesType.FILE, annotation.value());
                this.preferencesMode(annotation.mode());
            }
            if (this.cls.isAnnotationPresent(SaveOption.class)) {
                this.saveMode(this.cls.getAnnotation(SaveOption.class).value());
            }
        }

        private void validate() {
            if (this.context == null) {
                throw new IllegalArgumentException("Context cannot be null");
            }
            if (this.cls == null) {
                throw new IllegalArgumentException("Class cannot be null");
            }
            if (!this.cls.isInterface()) {
                throw new IllegalArgumentException("Class needs to be an interface");
            }
            if (this.preferencesType == PreferencesType.ACTIVITY) {
                if (!(this.context instanceof Activity)) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use %1$s without an Activity context", PreferencesType.ACTIVITY.name()));
                }
            } else if (this.preferencesType == PreferencesType.FILE && TextUtils.isEmpty((CharSequence)this.preferencesName)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use %1$s with an empty file name", PreferencesType.FILE.name()));
            }
        }
    }
}

