/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.io.specific;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.orandja.obor.io.ByteWriter;
import net.orandja.obor.io.WriterException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005\u00a8\u0006\u001b"}, d2={"Lnet/orandja/obor/io/specific/ExpandableByteArray;", "Lnet/orandja/obor/io/ByteWriter;", "initialCapacity", "", "<init>", "(I)V", "array", "", "getArray", "()[B", "setArray", "([B)V", "size", "getSize", "()I", "setSize", "getSizedArray", "ensureCapacity", "", "elementsToAppend", "totalWrite", "", "write", "value", "", "offset", "count", "obor"})
public final class ExpandableByteArray
implements ByteWriter {
    @NotNull
    private byte[] array;
    private int size;

    public ExpandableByteArray(int initialCapacity) {
        this.array = new byte[initialCapacity];
    }

    public /* synthetic */ ExpandableByteArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        this(n);
    }

    @NotNull
    public final byte[] getArray() {
        return this.array;
    }

    public final void setArray(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.array = byArray;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    @NotNull
    public final byte[] getSizedArray() {
        byte[] byArray = this.array;
        int n = 0;
        int n2 = this.size;
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }

    public final void ensureCapacity(int elementsToAppend) {
        if (this.size + elementsToAppend <= this.array.length) {
            return;
        }
        byte[] newArray = new byte[Integer.highestOneBit(this.size + elementsToAppend) << 1];
        ArraysKt.copyInto$default((byte[])this.array, (byte[])newArray, (int)0, (int)0, (int)0, (int)14, null);
        this.array = newArray;
    }

    @Override
    public long totalWrite() {
        return this.size;
    }

    @Override
    public void write(byte value) {
        this.ensureCapacity(1);
        this.array[this.size] = value;
        ++this.size;
    }

    @Override
    public void write(@NotNull byte[] array, int offset, int count) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)array, (String)"array");
                if (count == 0) {
                    return;
                }
                boolean bl = 0 <= count ? count <= array.length : false;
                if (!bl) break block4;
                int n = array.length;
                int n2 = count + offset;
                if (0 <= n2 ? n2 <= n : false) break block5;
            }
            throw new WriterException("Requested array range is out of range. Range is " + new IntRange(0, array.length) + " Requested is " + RangesKt.until((int)count, (int)(count + offset)), null, 2, null);
        }
        this.ensureCapacity(count);
        ArraysKt.copyInto((byte[])array, (byte[])this.array, (int)this.size, (int)offset, (int)(offset + count));
        this.size += count;
    }

    @Override
    public void write(@NotNull byte[] byteArray) {
        ByteWriter.DefaultImpls.write(this, byteArray);
    }

    public ExpandableByteArray() {
        this(0, 1, null);
    }
}

