/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.io.specific;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.orandja.obor.io.CborReader;
import net.orandja.obor.io.ReaderException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lnet/orandja/obor/io/specific/CborReaderByteArray;", "Lnet/orandja/obor/io/CborReader;", "bytes", "", "<init>", "([B)V", "position", "", "totalRead", "", "read", "", "()Ljava/lang/Byte;", "count", "readString", "", "skip", "", "peek", "Ljava/lang/Byte;", "consume", "nextByte", "nextShort", "", "nextInt", "nextLong", "obor"})
public final class CborReaderByteArray
implements CborReader {
    @NotNull
    private final byte[] bytes;
    private int position;
    @Nullable
    private Byte peek;

    public CborReaderByteArray(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
    }

    @Override
    public long totalRead() {
        return this.position;
    }

    @Override
    @NotNull
    public Byte read() {
        if (this.position >= this.bytes.length) {
            throw new ReaderException("Cannot read beyond the end of the byte array. (Size: " + this.bytes.length + ", Index: " + this.position + ")", null, 2, null);
        }
        int n = this.position;
        this.position = n + 1;
        return this.bytes[n];
    }

    @Override
    @NotNull
    public byte[] read(int count) {
        if (count == 0) {
            return new byte[0];
        }
        if (this.position + count > this.bytes.length) {
            throw new ReaderException("Cannot read beyond the end of the byte array. (Size: " + this.bytes.length + ", Range: " + RangesKt.until((int)this.position, (int)count) + ")", null, 2, null);
        }
        byte[] byArray = this.bytes;
        int n = this.position;
        int n2 = this.position + count;
        byte[] result = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        this.position += count;
        return result;
    }

    @Override
    @NotNull
    public String readString(int count) {
        if (count == 0) {
            return "";
        }
        if (this.position + count > this.bytes.length) {
            throw new ReaderException("Cannot read beyond the end of the byte array. (Size: " + this.bytes.length + ", Range: " + RangesKt.until((int)this.position, (int)count) + ")", null, 2, null);
        }
        String result = StringsKt.decodeToString$default((byte[])this.bytes, (int)this.position, (int)(this.position + count), (boolean)false, (int)4, null);
        this.position += count;
        return result;
    }

    @Override
    public void skip(int count) {
        if (this.position + count > this.bytes.length) {
            throw new ReaderException("Cannot skip beyond the end of the byte array. (Size: " + this.bytes.length + ", Range: " + RangesKt.until((int)this.position, (int)count) + ")", null, 2, null);
        }
        this.position += count;
    }

    @Override
    public byte peek() {
        if (this.peek != null) {
            Byte by = this.peek;
            Intrinsics.checkNotNull((Object)by);
            return by;
        }
        Byte by = this.peek = this.read();
        Intrinsics.checkNotNull((Object)by);
        return by;
    }

    @Override
    public void consume() {
        this.peek = null;
    }

    @Override
    public byte nextByte() {
        return this.read();
    }

    @Override
    public short nextShort() {
        short result = (short)((this.bytes[this.position + 0] & 0xFF) << 8 | this.bytes[this.position + 1] & 0xFF);
        this.position += 2;
        return result;
    }

    @Override
    public int nextInt() {
        int result = (this.bytes[this.position + 0] & 0xFF) << 24 | (this.bytes[this.position + 1] & 0xFF) << 16 | (this.bytes[this.position + 2] & 0xFF) << 8 | this.bytes[this.position + 3] & 0xFF;
        this.position += 4;
        return result;
    }

    @Override
    public long nextLong() {
        long result = ((long)this.bytes[this.position + 0] & 0xFFL) << 56 | ((long)this.bytes[this.position + 1] & 0xFFL) << 48 | ((long)this.bytes[this.position + 2] & 0xFFL) << 40 | ((long)this.bytes[this.position + 3] & 0xFFL) << 32 | ((long)this.bytes[this.position + 4] & 0xFFL) << 24 | ((long)this.bytes[this.position + 5] & 0xFFL) << 16 | ((long)this.bytes[this.position + 6] & 0xFFL) << 8 | (long)this.bytes[this.position + 7] & 0xFFL;
        this.position += 8;
        return result;
    }

    @Override
    public byte peekConsume() {
        return CborReader.DefaultImpls.peekConsume(this);
    }
}

