/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.io;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.orandja.obor.io.NativeArrayReader;
import net.orandja.obor.io.ReaderException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\bJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lnet/orandja/obor/io/ByteReader;", "Lnet/orandja/obor/io/NativeArrayReader;", "", "", "readString", "", "count", "", "Of", "obor"})
public interface ByteReader
extends NativeArrayReader<Byte, byte[]> {
    @NotNull
    public String readString(int var1) throws ReaderException;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/orandja/obor/io/ByteReader$Of;", "Lnet/orandja/obor/io/ByteReader;", "bytes", "", "<init>", "([B)V", "position", "", "totalRead", "", "read", "", "()Ljava/lang/Byte;", "count", "readString", "", "skip", "", "obor"})
    public static final class Of
    implements ByteReader {
        @NotNull
        private final byte[] bytes;
        private int position;

        public Of(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.bytes = bytes;
        }

        @Override
        public long totalRead() {
            return this.position;
        }

        @Override
        @NotNull
        public Byte read() {
            if (this.position >= this.bytes.length) {
                throw new ReaderException("Cannot read beyond the end of the byte array. (Size: " + this.bytes.length + ", Index: " + this.position + ")", null, 2, null);
            }
            int n = this.position;
            this.position = n + 1;
            return this.bytes[n];
        }

        @Override
        @NotNull
        public byte[] read(int count) {
            if (count == 0) {
                return new byte[0];
            }
            if (this.position + count > this.bytes.length) {
                throw new ReaderException("Cannot read beyond the end of the byte array. (Size: " + this.bytes.length + ", Range: " + RangesKt.until((int)this.position, (int)count) + ")", null, 2, null);
            }
            byte[] byArray = this.bytes;
            int n = this.position;
            int n2 = this.position + count;
            byte[] result = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            this.position += count;
            return result;
        }

        @Override
        @NotNull
        public String readString(int count) {
            if (count == 0) {
                return "";
            }
            if (this.position + count > this.bytes.length) {
                throw new ReaderException("Cannot read beyond the end of the byte array. (Size: " + this.bytes.length + ", Range: " + RangesKt.until((int)this.position, (int)count) + ")", null, 2, null);
            }
            String result = StringsKt.decodeToString$default((byte[])this.bytes, (int)this.position, (int)(this.position + count), (boolean)false, (int)4, null);
            this.position += count;
            return result;
        }

        @Override
        public void skip(int count) {
            if (this.position + count > this.bytes.length) {
                throw new ReaderException("Cannot skip beyond the end of the byte array. (Size: " + this.bytes.length + ", Range: " + RangesKt.until((int)this.position, (int)count) + ")", null, 2, null);
            }
            this.position += count;
        }
    }
}

