/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import net.orandja.obor.codec.CborDecoder;
import net.orandja.obor.codec.CborDecoderException;
import net.orandja.obor.codec.CborEncoder;
import net.orandja.obor.codec.UtilsKt;
import net.orandja.obor.data.CborArray;
import net.orandja.obor.data.CborBoolean;
import net.orandja.obor.data.CborBytes;
import net.orandja.obor.data.CborBytesIndefinite;
import net.orandja.obor.data.CborFloat;
import net.orandja.obor.data.CborMap;
import net.orandja.obor.data.CborMapEntry;
import net.orandja.obor.data.CborNegative;
import net.orandja.obor.data.CborNull;
import net.orandja.obor.data.CborObjectBuilder;
import net.orandja.obor.data.CborPositive;
import net.orandja.obor.data.CborTagged;
import net.orandja.obor.data.CborText;
import net.orandja.obor.data.CborTextIndefinite;
import net.orandja.obor.data.CborUndefined;
import net.orandja.obor.data.DummyDescriptor;
import net.orandja.obor.io.ByteWriter;
import net.orandja.obor.io.CborWriter;
import net.orandja.obor.io.specific.CborWriterExpandableByteArray;
import net.orandja.obor.io.specific.ExpandableByteArray;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Serializable(with=Serializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 *2\u00020\u0001:\u0004)*+,B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&JH\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2#\u0010 \u001a\u001f\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0!\u00a2\u0006\u0002\b\"\u0012\u0004\u0012\u00020\u00110!H \u00a2\u0006\u0002\b#J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0%J\b\u0010&\u001a\u00020\u0015H\u0016J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0004J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u001cH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u000e-./0123456789:\u00a8\u0006;"}, d2={"Lnet/orandja/obor/data/CborObject;", "", "kind", "Lnet/orandja/obor/data/CborObject$Kind;", "<init>", "(Lnet/orandja/obor/data/CborObject$Kind;)V", "getKind", "()Lnet/orandja/obor/data/CborObject$Kind;", "writeInto", "", "writer", "Lnet/orandja/obor/io/CborWriter;", "cborSize", "", "getCborSize", "()J", "cbor", "", "getCbor", "()[B", "cborAsHexString", "", "getCborAsHexString$annotations", "()V", "getCborAsHexString", "()Ljava/lang/String;", "describe", "depth", "", "elements", "", "Lnet/orandja/obor/data/CborObject$Description;", "withWriter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "describe$obor", "getObjectDescription", "", "toString", "sizeOfMajor", "value", "Kind", "Companion", "Description", "Serializer", "Lnet/orandja/obor/data/CborArray;", "Lnet/orandja/obor/data/CborBoolean;", "Lnet/orandja/obor/data/CborBytes;", "Lnet/orandja/obor/data/CborBytesIndefinite;", "Lnet/orandja/obor/data/CborFloat;", "Lnet/orandja/obor/data/CborMap;", "Lnet/orandja/obor/data/CborMapEntry;", "Lnet/orandja/obor/data/CborNegative;", "Lnet/orandja/obor/data/CborNull;", "Lnet/orandja/obor/data/CborPositive;", "Lnet/orandja/obor/data/CborTagged;", "Lnet/orandja/obor/data/CborText;", "Lnet/orandja/obor/data/CborTextIndefinite;", "Lnet/orandja/obor/data/CborUndefined;", "obor"})
@SourceDebugExtension(value={"SMAP\nCborObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborObject.kt\nnet/orandja/obor/data/CborObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
public abstract class CborObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Kind kind;

    private CborObject(Kind kind) {
        this.kind = kind;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    public abstract void writeInto(@NotNull CborWriter var1);

    public abstract long getCborSize();

    @NotNull
    public final byte[] getCbor() {
        byte[] bytes = new byte[(int)this.getCborSize()];
        CborWriter.ByWriter writer = new CborWriter.ByWriter(new ByteWriter.Of(bytes));
        this.writeInto(writer);
        return bytes;
    }

    @NotNull
    public final String getCborAsHexString() {
        return HexExtensionsKt.toHexString((byte[])this.getCbor(), (HexFormat)HexFormat.Companion.getUpperCase());
    }

    public static /* synthetic */ void getCborAsHexString$annotations() {
    }

    public abstract void describe$obor(int var1, @NotNull List<Description> var2, @NotNull Function1<? super Function1<? super CborWriter, Unit>, byte[]> var3);

    @NotNull
    public final List<Description> getObjectDescription() {
        List descriptions = new ArrayList();
        ExpandableByteArray writerArray = new ExpandableByteArray(64);
        CborWriterExpandableByteArray writer = new CborWriterExpandableByteArray(writerArray);
        this.describe$obor(0, descriptions, (Function1<? super Function1<? super CborWriter, Unit>, byte[]>)((Function1)arg_0 -> CborObject.getObjectDescription$lambda$0(writer, writerArray, arg_0)));
        return descriptions;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        List<Description> descriptions = this.getObjectDescription();
        Iterator iterator = ((Iterable)descriptions).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Description it22 = (Description)iterator.next();
        boolean bl = false;
        int it22 = it22.getDepth() * 3 + it22.getCborPart().length * 2;
        while (iterator.hasNext()) {
            Description it = (Description)iterator.next();
            $i$a$-maxOf-CborObject$toString$leftMaxSize$1 = false;
            int n = it.getDepth() * 3 + it.getCborPart().length * 2;
            if (it22 >= n) continue;
            it22 = n;
        }
        int leftMaxSize = it22;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (Description description : descriptions) {
            $this$toString_u24lambda_u242.append(StringsKt.repeat((CharSequence)" ", (int)(description.getDepth() * 3)));
            $this$toString_u24lambda_u242.append(HexExtensionsKt.toHexString((byte[])description.getCborPart(), (HexFormat)HexFormat.Companion.getUpperCase()));
            $this$toString_u24lambda_u242.append(StringsKt.repeat((CharSequence)" ", (int)(leftMaxSize - description.getDepth() * 3 - description.getCborPart().length * 2)));
            $this$toString_u24lambda_u242.append(" # ");
            $this$toString_u24lambda_u242.append(description.getMeaning());
            Intrinsics.checkNotNullExpressionValue((Object)$this$toString_u24lambda_u242.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final long sizeOfMajor(long value) {
        long l;
        block1: {
            block2: {
                block0: {
                    boolean bl = 0L <= value ? value < 24L : false;
                    if (!bl) break block0;
                    l = 1L;
                    break block1;
                }
                boolean bl = 0L <= value ? value < 256L : false;
                if (!bl) break block2;
                l = 2L;
                break block1;
            }
            l = (0L <= value ? value < 65536L : false) ? 3L : ((0L <= value ? value < 0x100000000L : false) ? 5L : 9L);
        }
        return l;
    }

    protected final long sizeOfMajor(int value) {
        long l;
        block1: {
            block0: {
                boolean bl = 0 <= value ? value < 24 : false;
                if (!bl) break block0;
                l = 1L;
                break block1;
            }
            long l2 = value;
            l = (0L <= l2 ? l2 < 256L : false) ? 2L : ((0L <= (l2 = (long)value) ? l2 < 65536L : false) ? 3L : 5L);
        }
        return l;
    }

    private static final byte[] getObjectDescription$lambda$0(CborWriterExpandableByteArray $writer, ExpandableByteArray $writerArray, Function1 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CborWriterExpandableByteArray cborWriterExpandableByteArray = $writer;
        it.invoke((Object)cborWriterExpandableByteArray);
        byte[] result = $writerArray.getSizedArray();
        $writerArray.setSize(0);
        return result;
    }

    public /* synthetic */ CborObject(Kind kind, DefaultConstructorMarker $constructor_marker) {
        this(kind);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/orandja/obor/data/CborObject$Companion;", "Lnet/orandja/obor/data/CborObjectBuilder;", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/orandja/obor/data/CborObject;", "obor"})
    public static final class Companion
    extends CborObjectBuilder {
        private Companion() {
        }

        @NotNull
        public final KSerializer<CborObject> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/orandja/obor/data/CborObject$Description;", "", "depth", "", "cborPart", "", "meaning", "", "<init>", "(I[BLjava/lang/String;)V", "getDepth", "()I", "getCborPart", "()[B", "getMeaning", "()Ljava/lang/String;", "obor"})
    public static final class Description {
        private final int depth;
        @NotNull
        private final byte[] cborPart;
        @NotNull
        private final String meaning;

        public Description(int depth, @NotNull byte[] cborPart, @NotNull String meaning) {
            Intrinsics.checkNotNullParameter((Object)cborPart, (String)"cborPart");
            Intrinsics.checkNotNullParameter((Object)meaning, (String)"meaning");
            this.depth = depth;
            this.cborPart = cborPart;
            this.meaning = meaning;
        }

        public final int getDepth() {
            return this.depth;
        }

        @NotNull
        public final byte[] getCborPart() {
            return this.cborPart;
        }

        @NotNull
        public final String getMeaning() {
            return this.meaning;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0011\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lnet/orandja/obor/data/CborObject$Kind;", "", "<init>", "(Ljava/lang/String;I)V", "POSITIVE", "NEGATIVE", "FLOAT", "BOOLEAN", "NULL", "UNDEFINED", "BYTES", "BYTES_INDEFINITE", "TEXT", "TEXT_INDEFINITE", "ARRAY", "MAP", "MAP_ENTRY", "TAGGED", "obor"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind POSITIVE = new Kind();
        public static final /* enum */ Kind NEGATIVE = new Kind();
        public static final /* enum */ Kind FLOAT = new Kind();
        public static final /* enum */ Kind BOOLEAN = new Kind();
        public static final /* enum */ Kind NULL = new Kind();
        public static final /* enum */ Kind UNDEFINED = new Kind();
        public static final /* enum */ Kind BYTES = new Kind();
        public static final /* enum */ Kind BYTES_INDEFINITE = new Kind();
        public static final /* enum */ Kind TEXT = new Kind();
        public static final /* enum */ Kind TEXT_INDEFINITE = new Kind();
        public static final /* enum */ Kind ARRAY = new Kind();
        public static final /* enum */ Kind MAP = new Kind();
        public static final /* enum */ Kind MAP_ENTRY = new Kind();
        public static final /* enum */ Kind TAGGED = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value) {
            return Enum.valueOf(Kind.class, value);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.POSITIVE, Kind.NEGATIVE, Kind.FLOAT, Kind.BOOLEAN, Kind.NULL, Kind.UNDEFINED, Kind.BYTES, Kind.BYTES_INDEFINITE, Kind.TEXT, Kind.TEXT_INDEFINITE, Kind.ARRAY, Kind.MAP, Kind.MAP_ENTRY, Kind.TAGGED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lnet/orandja/obor/data/CborObject$Serializer;", "Lkotlinx/serialization/KSerializer;", "Lnet/orandja/obor/data/CborObject;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor$annotations", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "obor"})
    @SourceDebugExtension(value={"SMAP\nCborObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborObject.kt\nnet/orandja/obor/data/CborObject$Serializer\n+ 2 Utils.kt\nnet/orandja/obor/codec/UtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,179:1\n76#2:180\n67#2:181\n77#2:186\n85#2:187\n67#2:188\n86#2:193\n67#2:194\n11165#3:182\n11500#3,3:183\n11165#3:189\n11500#3,3:190\n11165#3:195\n11500#3,3:196\n*S KotlinDebug\n*F\n+ 1 CborObject.kt\nnet/orandja/obor/data/CborObject$Serializer\n*L\n104#1:180\n104#1:181\n104#1:186\n142#1:187\n142#1:188\n142#1:193\n100#1:194\n104#1:182\n104#1:183,3\n142#1:189\n142#1:190,3\n100#1:195\n100#1:196,3\n*E\n"})
    public static final class Serializer
    implements KSerializer<CborObject> {
        @NotNull
        public static final Serializer INSTANCE;
        @NotNull
        private static final SerialDescriptor descriptor;

        private Serializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        public static /* synthetic */ void getDescriptor$annotations() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public CborObject deserialize(@NotNull Decoder decoder) {
            CborObject cborObject;
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            Decoder $this$assertCborDecoder$iv = decoder;
            boolean $i$f$assertCborDecoder = false;
            if (!($this$assertCborDecoder$iv instanceof CborDecoder)) {
                void $this$mapTo$iv$iv$iv;
                boolean bl = false;
                KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CborObject.class)};
                KClass[] klass$iv = kClassArray;
                boolean $i$f$name = false;
                KClass[] $this$map$iv$iv = klass$iv;
                boolean $i$f$map = false;
                KClass[] kClassArray2 = $this$map$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList($this$map$iv$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it$iv;
                    void item$iv$iv$iv;
                    void var15_18 = item$iv$iv$iv = $this$mapTo$iv$iv$iv[i];
                    Collection collection = destination$iv$iv$iv;
                    boolean bl2 = false;
                    collection.add(it$iv.getSimpleName());
                }
                String string = (CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null) + " can only be used with Obor's library. Expected: " + Reflection.getOrCreateKotlinClass(CborDecoder.class) + " found " + Reflection.getOrCreateKotlinClass($this$assertCborDecoder$iv.getClass())).toString();
                throw new IllegalStateException(string);
            }
            byte peek = ((CborDecoder)decoder).getReader$obor().peek();
            byte major = (byte)(peek & 0xFFFFFFE0);
            byte by = major;
            if (by == 0) {
                cborObject = CborPositive.Serializer.INSTANCE.deserialize(decoder);
                return cborObject;
            } else if (by == 32) {
                cborObject = CborNegative.Serializer.INSTANCE.deserialize(decoder);
                return cborObject;
            } else if (by == -32) {
                byte by2 = peek;
                if (by2 == UtilsKt.getHEADER_FALSE() || by2 == UtilsKt.getHEADER_TRUE()) {
                    cborObject = CborBoolean.Serializer.INSTANCE.deserialize(decoder);
                    return cborObject;
                } else if (by2 == UtilsKt.getHEADER_NULL()) {
                    cborObject = CborNull.Serializer.INSTANCE.deserialize(decoder);
                    return cborObject;
                } else if (by2 == UtilsKt.getHEADER_UNDEFINED()) {
                    cborObject = CborUndefined.Serializer.INSTANCE.deserialize(decoder);
                    return cborObject;
                } else {
                    if (by2 != UtilsKt.getHEADER_FLOAT_64() && by2 != UtilsKt.getHEADER_FLOAT_32() && by2 != UtilsKt.getHEADER_FLOAT_16()) throw new CborDecoderException.FailedToDecodeElement(((CborDecoder)decoder).getReader$obor().totalRead(), "PRIMITIVE Major 7 (float, boolean, null, undefined)");
                    cborObject = CborFloat.Serializer.INSTANCE.deserialize(decoder);
                }
                return cborObject;
            } else if (by == 64) {
                cborObject = (byte)(peek & 0x1F) == 31 ? (CborObject)CborBytesIndefinite.Serializer.INSTANCE.deserialize(decoder) : (CborObject)CborBytes.Serializer.INSTANCE.deserialize(decoder);
                return cborObject;
            } else if (by == 96) {
                cborObject = (byte)(peek & 0x1F) == 31 ? (CborObject)CborTextIndefinite.Serializer.INSTANCE.deserialize(decoder) : (CborObject)CborText.Serializer.INSTANCE.deserialize(decoder);
                return cborObject;
            } else if (by == -128) {
                cborObject = CborArray.Serializer.INSTANCE.deserialize(decoder);
                return cborObject;
            } else if (by == -96) {
                cborObject = CborMap.Serializer.INSTANCE.deserialize(decoder);
                return cborObject;
            } else {
                if (by != -64) throw new IllegalStateException(("unreachable " + ((CborDecoder)decoder).getReader$obor().totalRead()).toString());
                cborObject = CborTagged.Serializer.INSTANCE.deserialize(decoder);
            }
            return cborObject;
        }

        /*
         * WARNING - void declaration
         */
        public void serialize(@NotNull Encoder encoder, @NotNull CborObject value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Encoder $this$assertCborEncoder$iv = encoder;
            boolean $i$f$assertCborEncoder = false;
            if (!($this$assertCborEncoder$iv instanceof CborEncoder)) {
                void $this$mapTo$iv$iv$iv;
                boolean bl = false;
                KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CborObject.class)};
                KClass[] klass$iv = kClassArray;
                boolean $i$f$name = false;
                KClass[] $this$map$iv$iv = klass$iv;
                boolean $i$f$map = false;
                KClass[] kClassArray2 = $this$map$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList($this$map$iv$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it$iv;
                    void item$iv$iv$iv;
                    void var16_16 = item$iv$iv$iv = $this$mapTo$iv$iv$iv[i];
                    Collection collection = destination$iv$iv$iv;
                    boolean bl2 = false;
                    collection.add(it$iv.getSimpleName());
                }
                String string = (CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null) + " can only be used with Obor's library. Expected: " + Reflection.getOrCreateKotlinClass(CborEncoder.class) + " found " + Reflection.getOrCreateKotlinClass($this$assertCborEncoder$iv.getClass())).toString();
                throw new IllegalStateException(string);
            }
            CborObject cborObject = value;
            if (cborObject instanceof CborArray) {
                CborArray.Serializer.INSTANCE.serialize(encoder, (CborArray)value);
            } else if (cborObject instanceof CborBoolean) {
                CborBoolean.Serializer.INSTANCE.serialize(encoder, (CborBoolean)value);
            } else if (cborObject instanceof CborBytes) {
                CborBytes.Serializer.INSTANCE.serialize(encoder, (CborBytes)value);
            } else if (cborObject instanceof CborBytesIndefinite) {
                CborBytesIndefinite.Serializer.INSTANCE.serialize(encoder, (CborBytesIndefinite)value);
            } else if (cborObject instanceof CborFloat) {
                CborFloat.Serializer.INSTANCE.serialize(encoder, (CborFloat)value);
            } else if (cborObject instanceof CborMap) {
                CborMap.Serializer.INSTANCE.serialize(encoder, (CborMap)value);
            } else if (cborObject instanceof CborNegative) {
                CborNegative.Serializer.INSTANCE.serialize(encoder, (CborNegative)value);
            } else if (cborObject instanceof CborNull) {
                CborNull.Serializer.INSTANCE.serialize(encoder, (CborNull)value);
            } else if (cborObject instanceof CborPositive) {
                CborPositive.Serializer.INSTANCE.serialize(encoder, (CborPositive)value);
            } else if (cborObject instanceof CborTagged) {
                CborTagged.Serializer.INSTANCE.serialize(encoder, (CborTagged)value);
            } else if (cborObject instanceof CborText) {
                CborText.Serializer.INSTANCE.serialize(encoder, (CborText)value);
            } else if (cborObject instanceof CborTextIndefinite) {
                CborTextIndefinite.Serializer.INSTANCE.serialize(encoder, (CborTextIndefinite)value);
            } else if (cborObject instanceof CborUndefined) {
                CborUndefined.Serializer.INSTANCE.serialize(encoder, (CborUndefined)value);
            } else if (cborObject instanceof CborMapEntry) {
                CborMapEntry.Serializer.INSTANCE.serialize(encoder, (CborMapEntry)value);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$mapTo$iv$iv$iv;
            void klass$iv;
            INSTANCE = new Serializer();
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CborObject.class)};
            boolean $i$f$name = false;
            void $this$map$iv$iv = klass$iv;
            boolean $i$f$map = false;
            void var4_4 = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(((void)$this$map$iv$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it$iv;
                void item$iv$iv$iv;
                void var10_10 = item$iv$iv$iv = $this$mapTo$iv$iv$iv[i];
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                collection.add(it$iv.getSimpleName());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 6;
            SerialKind serialKind = null;
            int n3 = 0;
            String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            descriptor = new DummyDescriptor(string, n3, serialKind, n2, defaultConstructorMarker);
        }
    }
}

