/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import net.orandja.obor.codec.Float16Kt;
import net.orandja.obor.codec.Float32Kt;
import net.orandja.obor.codec.UtilsKt;
import net.orandja.obor.data.CborObject;
import net.orandja.obor.data.DummyDescriptor;
import net.orandja.obor.io.CborWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002'(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0012H\u0002JH\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162#\u0010\u0018\u001a\u001f\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0019\u00a2\u0006\u0002\b\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0010\u00a2\u0006\u0002\b\u001cJ\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lnet/orandja/obor/data/CborFloat;", "Lnet/orandja/obor/data/CborObject;", "value", "", "<init>", "(D)V", "getValue", "()D", "toString", "", "writeInto", "", "writer", "Lnet/orandja/obor/io/CborWriter;", "cborSize", "", "getCborSize", "()J", "", "describe", "depth", "elements", "", "Lnet/orandja/obor/data/CborObject$Description;", "withWriter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "", "describe$obor", "encodeFloat", "", "encodeDouble", "component1", "copy", "equals", "", "other", "", "hashCode", "Serializer", "Companion", "obor"})
public final class CborFloat
extends CborObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double value;
    private final long cborSize;

    public CborFloat(double value) {
        super(CborObject.Kind.FLOAT, null);
        this.value = value;
        this.cborSize = this.cborSize();
    }

    public final double getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString();
    }

    @Override
    public void writeInto(@NotNull CborWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.encodeDouble(writer, this.value);
    }

    @Override
    public long getCborSize() {
        return this.cborSize;
    }

    private final int cborSize() {
        int float16Bits;
        float floatValue = Float32Kt.float64toFloat32(this.value);
        return Double.doubleToRawLongBits(floatValue) == Double.doubleToRawLongBits(this.value) ? (Float.floatToRawIntBits(Float16Kt.float16BitsToFloat32(float16Bits = Float16Kt.float32ToFloat16bits(floatValue))) == Float.floatToRawIntBits(floatValue) ? 3 : 5) : 7;
    }

    @Override
    public void describe$obor(int depth, @NotNull List<CborObject.Description> elements, @NotNull Function1<? super Function1<? super CborWriter, Unit>, byte[]> withWriter) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(withWriter, (String)"withWriter");
        byte[] cbor = (byte[])withWriter.invoke(arg_0 -> CborFloat.describe$lambda$0(this, arg_0));
        String meaning = switch (cbor.length) {
            case 3 -> "float16(" + this.value + ")";
            case 5 -> "float32(" + this.value + ")";
            case 9 -> "float64(" + this.value + ")";
            default -> throw new IllegalStateException(("invalid size for float: " + cbor.length).toString());
        };
        ((Collection)elements).add(new CborObject.Description(depth, cbor, meaning));
    }

    private final void encodeFloat(CborWriter writer, float value) {
        int float16Bits = Float16Kt.float32ToFloat16bits(value);
        if (Float.floatToRawIntBits(Float16Kt.float16BitsToFloat32(float16Bits)) == Float.floatToRawIntBits(value)) {
            writer.writeHeader16(UtilsKt.getHEADER_FLOAT_16(), (short)float16Bits);
        } else {
            writer.writeHeader32(UtilsKt.getHEADER_FLOAT_32(), Float.floatToRawIntBits(value));
        }
    }

    private final void encodeDouble(CborWriter writer, double value) {
        float floatValue = Float32Kt.float64toFloat32(value);
        if (Double.doubleToRawLongBits(floatValue) == Double.doubleToRawLongBits(value)) {
            this.encodeFloat(writer, floatValue);
        } else {
            writer.writeHeader64(UtilsKt.getHEADER_FLOAT_64(), Double.doubleToRawLongBits(value));
        }
    }

    public final double component1() {
        return this.value;
    }

    @NotNull
    public final CborFloat copy(double value) {
        return new CborFloat(value);
    }

    public static /* synthetic */ CborFloat copy$default(CborFloat cborFloat, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = cborFloat.value;
        }
        return cborFloat.copy(d);
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CborFloat)) {
            return false;
        }
        CborFloat cborFloat = (CborFloat)other;
        return Double.compare(this.value, cborFloat.value) == 0;
    }

    private static final Unit describe$lambda$0(CborFloat this$0, CborWriter $this$withWriter) {
        Intrinsics.checkNotNullParameter((Object)$this$withWriter, (String)"$this$withWriter");
        this$0.encodeDouble($this$withWriter, this$0.value);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/orandja/obor/data/CborFloat$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/orandja/obor/data/CborFloat;", "obor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<CborFloat> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lnet/orandja/obor/data/CborFloat$Serializer;", "Lkotlinx/serialization/KSerializer;", "Lnet/orandja/obor/data/CborFloat;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor$annotations", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "obor"})
    @SourceDebugExtension(value={"SMAP\nCborFloat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborFloat.kt\nnet/orandja/obor/data/CborFloat$Serializer\n+ 2 Utils.kt\nnet/orandja/obor/codec/UtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,76:1\n67#2:77\n11165#3:78\n11500#3,3:79\n*S KotlinDebug\n*F\n+ 1 CborFloat.kt\nnet/orandja/obor/data/CborFloat$Serializer\n*L\n65#1:77\n65#1:78\n65#1:79,3\n*E\n"})
    public static final class Serializer
    implements KSerializer<CborFloat> {
        @NotNull
        public static final Serializer INSTANCE;
        @NotNull
        private static final SerialDescriptor descriptor;

        private Serializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        public static /* synthetic */ void getDescriptor$annotations() {
        }

        @NotNull
        public CborFloat deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            return new CborFloat(decoder.decodeDouble());
        }

        public void serialize(@NotNull Encoder encoder, @NotNull CborFloat value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            encoder.encodeDouble(value.getValue());
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$mapTo$iv$iv$iv;
            void klass$iv;
            INSTANCE = new Serializer();
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CborFloat.class)};
            boolean $i$f$name = false;
            void $this$map$iv$iv = klass$iv;
            boolean $i$f$map = false;
            void var4_4 = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(((void)$this$map$iv$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it$iv;
                void item$iv$iv$iv;
                void var10_10 = item$iv$iv$iv = $this$mapTo$iv$iv$iv[i];
                Collection collection = destination$iv$iv$iv;
                boolean bl = false;
                collection.add(it$iv.getSimpleName());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 6;
            SerialKind serialKind = null;
            int n3 = 0;
            String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            descriptor = new DummyDescriptor(string, n3, serialKind, n2, defaultConstructorMarker);
        }
    }
}

