/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.codec;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import net.orandja.obor.annotations.CborSkip;
import net.orandja.obor.annotations.CborTag;
import net.orandja.obor.annotations.CborTuple;
import net.orandja.obor.codec.ByteArrayDescriptor;
import net.orandja.obor.codec.Cbor;
import net.orandja.obor.codec.CborDecoderException;
import net.orandja.obor.codec.Float16Kt;
import net.orandja.obor.codec.ListBytesDescriptor;
import net.orandja.obor.codec.ListStringsDescriptor;
import net.orandja.obor.codec.UtilsKt;
import net.orandja.obor.io.CborReader;
import net.orandja.obor.io.specific.ExpandableByteArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0000\u0018\u0000 \u0085\u00012\u00020\u00012\u00020\u0002:\u0002\u0085\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0082\bJ\u0011\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0082\bJ\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0082\bJ\u0019\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0082\bJ\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0082\bJ\u0019\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001cH\u0082\bJ\u0011\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0082\bJ\u0019\u0010 \u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0012H\u0082\bJ\u0011\u0010\"\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0082\bJ\u0019\u0010#\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0012H\u0082\bJ\u0010\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020\u0012H\u0086\bJ\u0010\u0010)\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010+\u001a\u00020\u00142\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016J\b\u00100\u001a\u00020\u0018H\u0002J\u0010\u00101\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u00102\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0018\u00103\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0018\u00104\u001a\u0002052\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0018\u00106\u001a\u0002072\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0018\u00108\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0018\u00109\u001a\u00020:2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0018\u0010;\u001a\u00020<2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0018\u0010?\u001a\u00020@2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J\u0016\u0010A\u001a\u00020B2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012J\u0018\u0010C\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0012H\u0016J3\u0010D\u001a\u0002HE\"\n\b\u0000\u0010E*\u0004\u0018\u00010F2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HE0H2\n\b\u0002\u0010I\u001a\u0004\u0018\u0001HEH\u0002\u00a2\u0006\u0002\u0010JJ;\u0010K\u001a\u0002HE\"\u0004\b\u0000\u0010E2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00122\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HE0H2\b\u0010I\u001a\u0004\u0018\u0001HEH\u0016\u00a2\u0006\u0002\u0010LJ>\u0010M\u001a\u0004\u0018\u0001HE\"\b\b\u0000\u0010E*\u00020F*\u00020\u00012\u000e\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HE0H2\u000e\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HE0OH\u0082\b\u00a2\u0006\u0002\u0010PJC\u0010Q\u001a\u0004\u0018\u0001HE\"\b\b\u0000\u0010E*\u00020F2\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00122\u000e\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001HE0H2\b\u0010I\u001a\u0004\u0018\u0001HEH\u0016\u00a2\u0006\u0002\u0010LJ\b\u0010R\u001a\u00020\u0018H\u0016J\n\u0010S\u001a\u0004\u0018\u00010TH\u0016J\b\u0010U\u001a\u0004\u0018\u00010TJ\b\u0010V\u001a\u00020\u0018H\u0016J\b\u0010W\u001a\u00020<H\u0016J\b\u0010X\u001a\u00020>H\u0016J\b\u0010Y\u001a\u00020\u001cH\u0016J\b\u0010Z\u001a\u000207H\u0016J\b\u0010[\u001a\u00020\u0012H\u0016J\b\u0010\\\u001a\u00020:H\u0016J\b\u0010]\u001a\u000205H\u0016J\b\u0010^\u001a\u00020@H\u0016J\b\u0010_\u001a\u00020@H\u0002J\u0006\u0010`\u001a\u00020BJ\b\u0010a\u001a\u00020BH\u0002J\u0010\u0010b\u001a\u00020\u00122\u0006\u0010c\u001a\u00020'H\u0016J\r\u0010d\u001a\u00020e\u00a2\u0006\u0004\bf\u0010gJ\r\u0010h\u001a\u00020i\u00a2\u0006\u0004\bj\u0010kJ\r\u0010l\u001a\u00020m\u00a2\u0006\u0004\bn\u0010oJ\r\u0010p\u001a\u00020q\u00a2\u0006\u0004\br\u0010sJ\r\u0010t\u001a\u00020e\u00a2\u0006\u0004\bu\u0010gJ\r\u0010v\u001a\u00020i\u00a2\u0006\u0004\bw\u0010kJ\r\u0010x\u001a\u00020m\u00a2\u0006\u0004\by\u0010oJ\r\u0010z\u001a\u00020q\u00a2\u0006\u0004\b{\u0010sJ\b\u0010|\u001a\u00020\u0014H\u0002J\u0019\u0010}\u001a\u00020q2\u0006\u0010~\u001a\u00020\u001cH\u0082\b\u00a2\u0006\u0005\b\u007f\u0010\u0080\u0001J!\u0010\u0081\u0001\u001a\u00020\u00142\u0006\u0010~\u001a\u00020\u001c2\r\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u00140OH\u0082\bJ\n\u0010\u0083\u0001\u001a\u00020\u0014H\u0082\bJ\u0012\u0010\u0084\u0001\u001a\u00020\u00142\u0006\u0010~\u001a\u00020\u001cH\u0082\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0086\u0001"}, d2={"Lnet/orandja/obor/codec/CborDecoder;", "Lkotlinx/serialization/encoding/Decoder;", "Lkotlinx/serialization/encoding/CompositeDecoder;", "reader", "Lnet/orandja/obor/io/CborReader;", "configuration", "Lnet/orandja/obor/codec/Cbor$Configuration;", "<init>", "(Lnet/orandja/obor/io/CborReader;Lnet/orandja/obor/codec/Cbor$Configuration;)V", "getReader$obor", "()Lnet/orandja/obor/io/CborReader;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "tracker", "", "depth", "", "ensureCapacity", "", "elementsToAppend", "clear", "hasFlag", "", "flag", "setFlag", "getMajor", "", "setMajor", "major", "getCollectionSize", "setCollectionSize", "size", "getIndex", "setIndex", "index", "beginStructure", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeCollectionSize", "endStructure", "decodeInline", "readTag", "annotations", "", "", "decodeElementIndex", "isCollectionDone", "decodeStructureElementIndex", "decodeBooleanElement", "decodeByteElement", "decodeCharElement", "", "decodeShortElement", "", "decodeIntElement", "decodeLongElement", "", "decodeFloatElement", "", "decodeDoubleElement", "", "decodeStringElement", "", "decodeBytesElement", "", "decodeInlineElement", "decodeSerializableValue", "T", "", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "previousValue", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeSerializableElement", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeIfNullable", "block", "Lkotlin/Function0;", "(Lkotlinx/serialization/encoding/Decoder;Lkotlinx/serialization/DeserializationStrategy;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "decodeNullableSerializableElement", "decodeNotNullMark", "decodeNull", "", "decodeUndefined", "decodeBoolean", "decodeFloat", "decodeDouble", "decodeByte", "decodeShort", "decodeInt", "decodeLong", "decodeChar", "decodeString", "decodeStringIndefinite", "decodeBytes", "decodeBytesIndefinite", "decodeEnum", "enumDescriptor", "decodeUByte", "Lkotlin/UByte;", "decodeUByte-w2LRezQ", "()B", "decodeUShort", "Lkotlin/UShort;", "decodeUShort-Mh2AYeg", "()S", "decodeUInt", "Lkotlin/UInt;", "decodeUInt-pVg5ArA", "()I", "decodeULong", "Lkotlin/ULong;", "decodeULong-s-VKNKU", "()J", "decodeNegativeUByte", "decodeNegativeUByte-w2LRezQ", "decodeNegativeUShort", "decodeNegativeUShort-Mh2AYeg", "decodeNegativeUInt", "decodeNegativeUInt-pVg5ArA", "decodeNegativeULong", "decodeNegativeULong-s-VKNKU", "skipElement", "getSize", "peek", "getSize-I7RO_PI", "(B)J", "skipRepeat", "onItem", "skipRepeatIndefinite", "skipSimpleElement", "Companion", "obor"})
@SourceDebugExtension(value={"SMAP\nCborDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborDecoder.kt\nnet/orandja/obor/codec/CborDecoder\n+ 2 Utils.kt\nnet/orandja/obor/codec/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Decoding.kt\nkotlinx/serialization/encoding/DecodingKt\n*L\n1#1,765:1\n83#1:766\n70#1,5:767\n90#1,2:772\n85#1,2:774\n85#1,2:776\n90#1,2:778\n90#1,2:780\n90#1,2:782\n90#1,2:785\n85#1,2:787\n90#1,2:789\n83#1:791\n90#1,2:792\n95#1,2:794\n88#1:796\n88#1:798\n83#1:799\n95#1,2:800\n180#1,15:802\n88#1:817\n83#1:818\n77#1,5:819\n70#1,5:824\n85#1,2:829\n83#1:832\n98#1:833\n100#1,2:834\n93#1:836\n98#1:837\n98#1,4:838\n352#1,2:845\n88#1,6:847\n755#1,8:853\n748#1,4:886\n726#1,8:890\n748#1,4:899\n738#1:903\n726#1,19:904\n748#1,4:924\n738#1:928\n726#1,19:929\n755#1,8:948\n726#1,8:956\n63#2:784\n63#2:797\n63#2:831\n67#2:861\n94#2:868\n68#2:869\n95#2:870\n67#2:873\n94#2:880\n68#2:881\n95#2:882\n63#2:885\n63#2:898\n63#2:923\n1755#3,3:842\n11165#4:862\n11500#4,3:863\n11165#4:874\n11500#4,3:875\n570#5,2:866\n572#5,2:871\n570#5,2:878\n572#5,2:883\n*S KotlinDebug\n*F\n+ 1 CborDecoder.kt\nnet/orandja/obor/codec/CborDecoder\n*L\n106#1:766\n108#1:767,5\n112#1:772,2\n115#1:774,2\n117#1:776,2\n118#1:778,2\n125#1:780,2\n127#1:782,2\n129#1:785,2\n135#1:787,2\n138#1:789,2\n150#1:791\n151#1:792,2\n152#1:794,2\n154#1:796\n155#1:798\n158#1:799\n160#1:800,2\n173#1:802,15\n175#1:817\n175#1:818\n198#1:819,5\n204#1:824,5\n206#1:829,2\n243#1:832\n244#1:833\n245#1:834,2\n250#1:836\n252#1:837\n268#1:838,4\n358#1:845,2\n410#1:847,6\n412#1:853,8\n706#1:886,4\n707#1:890,8\n711#1:899,4\n712#1:903\n712#1:904,19\n716#1:924,4\n717#1:928\n717#1:929,19\n720#1:948,8\n738#1:956,8\n129#1:784\n154#1:797\n221#1:831\n556#1:861\n558#1:868\n558#1:869\n558#1:870\n597#1:873\n599#1:880\n599#1:881\n599#1:882\n705#1:885\n710#1:898\n715#1:923\n278#1:842,3\n556#1:862\n556#1:863,3\n597#1:874\n597#1:875,3\n557#1:866,2\n557#1:871,2\n598#1:878,2\n598#1:883,2\n*E\n"})
public final class CborDecoder
implements Decoder,
CompositeDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CborReader reader;
    @NotNull
    private final Cbor.Configuration configuration;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private int[] tracker;
    private int depth;
    private static final int INLINE = 1;
    private static final int STRUCTURE = 2;
    private static final int TUPLE = 4;
    private static final int INLINE_TUPLE = 8;

    public CborDecoder(@NotNull CborReader reader, @NotNull Cbor.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.reader = reader;
        this.configuration = configuration;
        this.serializersModule = this.configuration.getSerializersModule();
        this.tracker = new int[16];
        this.depth = 1;
    }

    @NotNull
    public final CborReader getReader$obor() {
        return this.reader;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    private final void ensureCapacity(int elementsToAppend) {
        boolean $i$f$ensureCapacity = false;
        if (this.depth * 4 + 4 + elementsToAppend * 4 <= this.tracker.length) {
            return;
        }
        int[] newArray = new int[Integer.highestOneBit(this.tracker.length + elementsToAppend * 4) << 1];
        ArraysKt.copyInto((int[])this.tracker, (int[])newArray, (int)0, (int)0, (int)this.tracker.length);
        this.tracker = newArray;
    }

    private final void clear(int depth) {
        boolean $i$f$clear = false;
        this.tracker[depth * 4] = 0;
        this.tracker[depth * 4 + 1] = 0;
        this.tracker[depth * 4 + 2] = 0;
        this.tracker[depth * 4 + 3] = 0;
    }

    private final boolean hasFlag(int depth, int flag) {
        boolean $i$f$hasFlag = false;
        return (this.tracker[depth * 4] & flag) > 0;
    }

    private final void setFlag(int depth, int flag) {
        boolean $i$f$setFlag = false;
        this.tracker[depth * 4] = this.tracker[depth * 4] | flag;
    }

    private final byte getMajor(int depth) {
        boolean $i$f$getMajor = false;
        return (byte)this.tracker[depth * 4 + 1];
    }

    private final void setMajor(int depth, byte major) {
        boolean $i$f$setMajor = false;
        this.tracker[depth * 4 + 1] = major & 0xFF;
    }

    private final int getCollectionSize(int depth) {
        boolean $i$f$getCollectionSize = false;
        return this.tracker[depth * 4 + 2];
    }

    private final void setCollectionSize(int depth, int size) {
        boolean $i$f$setCollectionSize = false;
        this.tracker[depth * 4 + 2] = size;
    }

    private final int getIndex(int depth) {
        boolean $i$f$getIndex = false;
        return this.tracker[depth * 4 + 3];
    }

    private final void setIndex(int depth, int index) {
        boolean $i$f$setIndex = false;
        this.tracker[depth * 4 + 3] = index;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        block14: {
            block15: {
                block17: {
                    block16: {
                        block13: {
                            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                            var2_2 = this;
                            var3_6 = this.depth;
                            flag$iv = 1;
                            $i$f$hasFlag = false;
                            if (!((this_$iv.tracker[depth$iv * 4] & flag$iv) > 0)) {
                                this.readTag(descriptor.getAnnotations());
                                this_$iv = this;
                                elementsToAppend$iv = 1;
                                $i$f$ensureCapacity = false;
                                if (this_$iv.depth * 4 + 4 + elementsToAppend$iv * 4 > this_$iv.tracker.length) {
                                    newArray$iv = new int[Integer.highestOneBit(this_$iv.tracker.length + elementsToAppend$iv * 4) << 1];
                                    ArraysKt.copyInto((int[])this_$iv.tracker, (int[])newArray$iv, (int)0, (int)0, (int)this_$iv.tracker.length);
                                    this_$iv.tracker = newArray$iv;
                                }
                                this_$iv = this.depth;
                                this.depth = this_$iv + 1;
                            }
                            this_$iv = this;
                            elementsToAppend$iv = this.depth;
                            major$iv = -96;
                            $i$f$setMajor = false;
                            this_$iv.tracker[depth$iv * 4 + true] = major$iv & 255;
                            this_$iv = descriptor.getKind();
                            if (!Intrinsics.areEqual((Object)this_$iv, (Object)StructureKind.CLASS.INSTANCE) && !Intrinsics.areEqual((Object)this_$iv, (Object)StructureKind.OBJECT.INSTANCE)) break block13;
                            depth$iv = this;
                            major$iv = this.depth;
                            flag$iv = 2;
                            $i$f$setFlag = 0;
                            this_$iv.tracker[depth$iv * 4] = this_$iv.tracker[depth$iv * 4] | flag$iv;
                            for (Annotation annotation : descriptor.getAnnotations()) {
                                if (!(annotation instanceof CborTuple)) continue;
                                flag$iv = this;
                                $i$f$setFlag = this.depth;
                                flag$iv = 4;
                                $i$f$setFlag = false;
                                this_$iv.tracker[depth$iv * 4] = this_$iv.tracker[depth$iv * 4] | flag$iv;
                                this_$iv = this;
                                depth$iv = this.depth;
                                major$iv = -128;
                                $i$f$setMajor = false;
                                this_$iv.tracker[depth$iv * 4 + 1] = major$iv & 255;
                            }
                            break block14;
                        }
                        if (!Intrinsics.areEqual((Object)this_$iv, (Object)StructureKind.LIST.INSTANCE)) break block15;
                        if (!(descriptor instanceof ByteArrayDescriptor) && !(descriptor instanceof ListBytesDescriptor)) break block16;
                        this_$iv = this;
                        annotation = this.depth;
                        major$iv = 64;
                        $i$f$setMajor = 0;
                        this_$iv.tracker[depth$iv * 4 + 1] = major$iv & 255;
                        break block14;
                    }
                    if (!(descriptor instanceof ListStringsDescriptor)) break block17;
                    this_$iv = this;
                    depth$iv = this.depth;
                    major$iv = 96;
                    $i$f$setMajor = 0;
                    this_$iv.tracker[depth$iv * 4 + 1] = major$iv & 255;
                    break block14;
                }
                if (!(descriptor.getElementDescriptor(0).getKind() instanceof PrimitiveKind.BYTE)) ** GOTO lbl-1000
                this_$iv = this.reader.peek();
                flags$iv = 64;
                $i$f$hasMajor = false;
                if ((int)($this$hasMajor$iv & -32) == flags$iv) {
                    $this$hasMajor$iv = this;
                    flags$iv = this.depth;
                    major$iv = 64;
                    $i$f$setMajor = 0;
                    this_$iv.tracker[depth$iv * 4 + 1] = major$iv & 255;
                } else lbl-1000:
                // 2 sources

                {
                    if (descriptor.getElementsCount() == 1) {
                        for (Annotation annotation : descriptor.getElementDescriptor(0).getAnnotations()) {
                            if (!(annotation instanceof CborTuple) || !((CborTuple)annotation).inlinedInList()) continue;
                            major$iv = this;
                            $i$f$setMajor = this.depth;
                            flag$iv = 8;
                            $i$f$setFlag = false;
                            this_$iv.tracker[depth$iv * 4] = this_$iv.tracker[depth$iv * 4] | flag$iv;
                            break;
                        }
                    }
                    this_$iv = this;
                    annotation = this.depth;
                    major$iv = -128;
                    $i$f$setMajor = 0;
                    this_$iv.tracker[depth$iv * 4 + true] = major$iv & 255;
                }
                break block14;
            }
            if (!Intrinsics.areEqual((Object)this_$iv, (Object)StructureKind.MAP.INSTANCE)) {
                throw new CborDecoderException.InvalidStructureKind(this.reader.totalRead(), descriptor);
            }
        }
        this_$iv = this;
        this_$iv = this.depth - 1;
        flag$iv = 8;
        $i$f$hasFlag = false;
        if (!((this_$iv.tracker[depth$iv * 4] & flag$iv) > 0)) ** GOTO lbl-1000
        this_$iv = this;
        depth$iv = this.depth;
        flag$iv = 4;
        $i$f$hasFlag = false;
        if ((this_$iv.tracker[depth$iv * 4] & flag$iv) > 0) {
            this_$iv = this;
            depth$iv = this.depth;
            major$iv = -128;
            $i$f$setMajor = false;
            this_$iv.tracker[depth$iv * 4 + 1] = major$iv & 255;
            this_$iv = this;
            depth$iv = this.depth;
            size$iv = descriptor.getElementsCount();
            $i$f$setCollectionSize = false;
            this_$iv.tracker[depth$iv * 4 + 2] = size$iv;
        } else lbl-1000:
        // 2 sources

        {
            this_$iv = this.reader.peek();
            depth$iv = this;
            depth$iv = this.depth;
            $i$f$getMajor = false;
            flags$iv = (byte)this_$iv.tracker[depth$iv * 4 + 1];
            $i$f$hasMajor = false;
            if (!((byte)($this$hasMajor$iv & -32) == flags$iv)) {
                $this$hasMajor$iv = this;
                depth$iv = this.depth;
                $i$f$getMajor = 0;
                throw new CborDecoderException.InvalidMajor(this.reader.totalRead(), (byte)this_$iv.tracker[depth$iv * 4 + 1], this.reader.peek(), descriptor);
            }
            collectionSize = this.decodeCollectionSize(descriptor);
            if (collectionSize != -1) {
                depth$iv = this;
                $i$f$getMajor = this.depth;
                flag$iv = 8;
                $i$f$hasFlag = false;
                if ((this_$iv.tracker[depth$iv * 4] & flag$iv) > 0) {
                    collectionSize /= descriptor.getElementDescriptor(0).getElementsCount();
                }
            }
            this_$iv = this;
            depth$iv = this.depth;
            $i$f$setCollectionSize = false;
            this_$iv.tracker[depth$iv * 4 + 2] = collectionSize;
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor) {
        block8: {
            block7: {
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                        this_$iv = this;
                        $i$f$decodeCollectionSize = false;
                        sizeBits$iv = this_$iv.getReader$obor().peekConsume() & 31;
                        if (sizeBits$iv >= 24) break block5;
                        v0 = sizeBits$iv;
                        ** GOTO lbl29
                    }
                    if (sizeBits$iv != 24) break block6;
                    v0 = this_$iv.getReader$obor().nextByte() & 255;
                    ** GOTO lbl29
                }
                if (sizeBits$iv != 25) break block7;
                v0 = this_$iv.getReader$obor().nextShort() & 65535;
                ** GOTO lbl29
            }
            if (sizeBits$iv != 26) break block8;
            result$iv = this_$iv.getReader$obor().nextInt();
            if (result$iv < 0) {
                throw new CborDecoderException.CollectionSizeTooLarge(this_$iv.getReader$obor().totalRead(), ULong.constructor-impl((long)result$iv), null);
            }
            v0 = result$iv;
            ** GOTO lbl29
        }
        if (sizeBits$iv == 31) {
            v1 = -1;
        } else {
            throw new CborDecoderException.InvalidSizeElement(this_$iv.getReader$obor().totalRead(), (byte)sizeBits$iv, 26, true);
lbl29:
            // 4 sources

            v1 = result$iv = v0;
        }
        result = v1;
        this_$iv = this;
        depth$iv = this.depth;
        $i$f$getMajor = false;
        if ((byte)this_$iv.tracker[depth$iv * 4 + 1] != -96) ** GOTO lbl-1000
        this_$iv = this;
        depth$iv = this.depth;
        flag$iv = 4;
        $i$f$hasFlag = false;
        if ((this_$iv.tracker[depth$iv * 4] & flag$iv) > 0) ** GOTO lbl-1000
        this_$iv = this;
        depth$iv = this.depth;
        flag$iv = 2;
        $i$f$hasFlag = false;
        if (!((this_$iv.tracker[depth$iv * 4] & flag$iv) > 0)) {
            v2 = result * 2;
        } else lbl-1000:
        // 3 sources

        {
            v2 = result;
        }
        return v2;
    }

    public final int decodeCollectionSize() {
        int n;
        boolean $i$f$decodeCollectionSize = false;
        byte by = this.getReader$obor().peekConsume() & 0x1F;
        if (by < 24) {
            n = by;
        } else if (by == 24) {
            n = this.getReader$obor().nextByte() & 0xFF;
        } else if (by == 25) {
            n = this.getReader$obor().nextShort() & 0xFFFF;
        } else if (by == 26) {
            int result = this.getReader$obor().nextInt();
            if (result < 0) {
                throw new CborDecoderException.CollectionSizeTooLarge(this.getReader$obor().totalRead(), ULong.constructor-impl((long)result), null);
            }
            n = result;
        } else {
            if (by == 31) {
                return -1;
            }
            throw new CborDecoderException.InvalidSizeElement(this.getReader$obor().totalRead(), by, 26, true);
        }
        byte by2 = n;
        return by2;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CborDecoder cborDecoder = this;
        int depth$iv = this.depth;
        boolean $i$f$clear = false;
        this_$iv.tracker[depth$iv * 4] = 0;
        this_$iv.tracker[depth$iv * 4 + 1] = 0;
        this_$iv.tracker[depth$iv * 4 + 2] = 0;
        this_$iv.tracker[depth$iv * 4 + 3] = 0;
        int n = this.depth;
        this.depth = n + -1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor descriptor) {
        void depth$iv;
        void this_$iv222;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.readTag(descriptor.getAnnotations());
        CborDecoder cborDecoder = this;
        int elementsToAppend$iv = 1;
        boolean $i$f$ensureCapacity = false;
        if (this_$iv222.depth * 4 + 4 + elementsToAppend$iv * 4 > this_$iv222.tracker.length) {
            int[] newArray$iv = new int[Integer.highestOneBit(this_$iv222.tracker.length + elementsToAppend$iv * 4) << 1];
            ArraysKt.copyInto((int[])this_$iv222.tracker, (int[])newArray$iv, (int)0, (int)0, (int)this_$iv222.tracker.length);
            this_$iv222.tracker = newArray$iv;
        }
        int this_$iv222 = this.depth;
        this.depth = this_$iv222 + 1;
        CborDecoder this_$iv222 = this;
        elementsToAppend$iv = this.depth;
        int flag$iv = 1;
        boolean $i$f$setFlag = false;
        this_$iv222.tracker[depth$iv * 4] = this_$iv222.tracker[depth$iv * 4] | flag$iv;
        this.readTag(descriptor.getElementAnnotations(0));
        return this;
    }

    private final void readTag(List<? extends Annotation> annotations) {
        long l;
        boolean noTag;
        Long tag = null;
        boolean required = false;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof CborTag)) continue;
            tag = ((CborTag)annotation).tag();
            required = ((CborTag)annotation).required();
        }
        byte by = this.reader.peek();
        byte flags$iv = -64;
        boolean $i$f$hasMajor = false;
        boolean bl = noTag = !((byte)(by & 0xFFFFFFE0) == flags$iv);
        if (noTag && required) {
            long l2 = this.reader.totalRead();
            Long l3 = tag;
            Intrinsics.checkNotNull((Object)l3);
            throw new CborDecoderException.RequiredTagNotFound(l2, l3);
        }
        if (noTag) {
            return;
        }
        byte by2 = (byte)(this.reader.peekConsume() & 0x1F);
        if (by2 < 24) {
            l = by2;
        } else if (by2 == 24) {
            l = (long)this.reader.nextByte() & 0xFFL;
        } else if (by2 == 25) {
            l = (long)this.reader.nextShort() & 0xFFFFL;
        } else if (by2 == 26) {
            l = (long)this.reader.nextInt() & 0xFFFFFFFFL;
        } else if (by2 == 27) {
            l = this.reader.nextLong();
        } else {
            throw new CborDecoderException.InvalidSizeElement(this.reader.totalRead(), by2, 27, false);
        }
        long readTag = l;
        if (tag != null && readTag != tag) {
            throw new CborDecoderException.UnexpectedTag(this.reader.totalRead(), readTag, tag);
        }
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        CborDecoder this_$iv;
        int depth$iv;
        CborDecoder this_$iv2;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.isCollectionDone()) {
            return -1;
        }
        CborDecoder cborDecoder = this;
        int n = this.depth;
        int flag$iv = 2;
        boolean $i$f$hasFlag = false;
        if ((this_$iv2.tracker[depth$iv * 4] & flag$iv) > 0) {
            this_$iv2 = this;
            depth$iv = this.depth;
            flag$iv = 4;
            $i$f$hasFlag = false;
            if (!((this_$iv2.tracker[depth$iv * 4] & flag$iv) > 0)) {
                return this.decodeStructureElementIndex(descriptor);
            }
        }
        CborDecoder depth$iv2 = this;
        int depth$iv3 = this.depth;
        boolean $i$f$getIndex = false;
        int index = this_$iv.tracker[depth$iv3 * 4 + 3];
        this_$iv = this;
        depth$iv3 = this.depth;
        int index$iv = index + 1;
        boolean $i$f$setIndex = false;
        this_$iv.tracker[depth$iv3 * 4 + 3] = index$iv;
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCollectionDone() {
        CborDecoder this_$iv;
        CborDecoder cborDecoder = this;
        int depth$iv = this.depth;
        boolean $i$f$getCollectionSize = false;
        int collectionSize = this_$iv.tracker[depth$iv * 4 + 2];
        if (collectionSize != -1) {
            this_$iv = this;
            depth$iv = this.depth;
            boolean $i$f$getIndex = false;
            if (this_$iv.tracker[depth$iv * 4 + 3] == collectionSize) {
                return true;
            }
        }
        if (collectionSize != -1) return false;
        if (this.reader.peek() != UtilsKt.getHEADER_BREAK()) return false;
        this.reader.consume();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final int decodeStructureElementIndex(SerialDescriptor descriptor) {
        do lbl-1000:
        // 3 sources

        {
            block6: {
                block7: {
                    name = this.decodeString();
                    index = descriptor.getElementIndex(name);
                    var4_4 = this;
                    var5_5 = this.depth;
                    var6_6 = this;
                    depth$iv = this.depth;
                    $i$f$getIndex = false;
                    index$iv = this_$iv.tracker[depth$iv * 4 + 3] + 1;
                    $i$f$setIndex = false;
                    this_$iv.tracker[depth$iv * 4 + 3] = index$iv;
                    if (index != -3) break block7;
                    if (!this.configuration.getIgnoreUnknownKeys()) {
                        throw new CborDecoderException.ClassUnknownKey(this.reader.totalRead(), name, descriptor);
                    }
                    this.skipElement();
                    if (!this.isCollectionDone()) ** GOTO lbl-1000
                    return -1;
                }
                annotations = descriptor.getElementAnnotations(index);
                $this$any$iv = annotations;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (Annotation)element$iv;
                        $i$a$-any-CborDecoder$decodeStructureElementIndex$skipped$1 = false;
                        if (!(it instanceof CborSkip)) continue;
                        v0 = true;
                        break block6;
                    }
                    v0 = skipped = false;
                }
            }
            if (!skipped) {
                return index;
            }
            this.skipElement();
        } while (!this.isCollectionDone());
        return -1;
    }

    public boolean decodeBooleanElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeBoolean();
    }

    public byte decodeByteElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeByte();
    }

    public char decodeCharElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeChar();
    }

    public short decodeShortElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeShort();
    }

    public int decodeIntElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeInt();
    }

    public long decodeLongElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeLong();
    }

    public float decodeFloatElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeFloat();
    }

    public double decodeDoubleElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeDouble();
    }

    @NotNull
    public String decodeStringElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeString();
    }

    @NotNull
    public final byte[] decodeBytesElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeBytes();
    }

    @NotNull
    public Decoder decodeInlineElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.decodeInline(descriptor);
    }

    private final <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializer, T previousValue) {
        return this.decodeSerializableValue(deserializer);
    }

    static /* synthetic */ Object decodeSerializableValue$default(CborDecoder cborDecoder, DeserializationStrategy deserializationStrategy, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return cborDecoder.decodeSerializableValue(deserializationStrategy, object);
    }

    public <T> T decodeSerializableElement(@NotNull SerialDescriptor descriptor, int index, @NotNull DeserializationStrategy<? extends T> deserializer, @Nullable T previousValue) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        if (index < descriptor.getElementsCount()) {
            this.readTag(descriptor.getElementAnnotations(index));
        }
        return this.decodeSerializableValue(deserializer, previousValue);
    }

    private final <T> T decodeIfNullable(Decoder $this$decodeIfNullable, DeserializationStrategy<? extends T> deserializer, Function0<? extends T> block) {
        boolean $i$f$decodeIfNullable = false;
        boolean isNullabilitySupported = deserializer.getDescriptor().isNullable();
        return (T)(isNullabilitySupported || $this$decodeIfNullable.decodeNotNullMark() ? block.invoke() : $this$decodeIfNullable.decodeNull());
    }

    @Nullable
    public <T> T decodeNullableSerializableElement(@NotNull SerialDescriptor descriptor, int index, @NotNull DeserializationStrategy<? extends T> deserializer, @Nullable T previousValue) {
        Void void_;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        CborDecoder cborDecoder = this;
        Decoder $this$decodeIfNullable$iv = this;
        boolean $i$f$decodeIfNullable = false;
        boolean isNullabilitySupported$iv = deserializer.getDescriptor().isNullable();
        if (isNullabilitySupported$iv || $this$decodeIfNullable$iv.decodeNotNullMark()) {
            boolean bl = false;
            void_ = this.decodeSerializableValue(deserializer, previousValue);
        } else {
            void_ = $this$decodeIfNullable$iv.decodeNull();
        }
        return (T)void_;
    }

    public boolean decodeNotNullMark() {
        return this.reader.peek() != UtilsKt.getHEADER_NULL();
    }

    @Nullable
    public Void decodeNull() {
        if (this.reader.peekConsume() != UtilsKt.getHEADER_NULL()) {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "NULL (" + UtilsKt.getHEADER_NULL() + ")");
        }
        return null;
    }

    @Nullable
    public final Void decodeUndefined() {
        if (this.reader.peekConsume() != UtilsKt.getHEADER_UNDEFINED()) {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "UNDEFINED (" + UtilsKt.getHEADER_UNDEFINED() + ")");
        }
        return null;
    }

    public boolean decodeBoolean() {
        boolean bl;
        byte by = this.reader.peekConsume();
        if (by == UtilsKt.getHEADER_FALSE()) {
            bl = false;
        } else if (by == UtilsKt.getHEADER_TRUE()) {
            bl = true;
        } else {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "TRUE, FALSE (" + UtilsKt.getHEADER_TRUE() + ", " + UtilsKt.getHEADER_FALSE() + ")");
        }
        return bl;
    }

    public float decodeFloat() {
        float f;
        byte by = this.reader.peekConsume();
        if (by == UtilsKt.getHEADER_FLOAT_16()) {
            f = Float16Kt.float16BitsToFloat32(this.reader.nextShort() & 0xFFFF);
        } else if (by == UtilsKt.getHEADER_FLOAT_32()) {
            f = Float.intBitsToFloat(this.reader.nextInt());
        } else {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "FLOAT (" + UtilsKt.getHEADER_FLOAT_16() + ", " + UtilsKt.getHEADER_FLOAT_32() + ")");
        }
        return f;
    }

    public double decodeDouble() {
        double d;
        byte by = this.reader.peekConsume();
        if (by == UtilsKt.getHEADER_FLOAT_16()) {
            d = Float16Kt.float16BitsToFloat32(this.reader.nextShort() & 0xFFFF);
        } else if (by == UtilsKt.getHEADER_FLOAT_32()) {
            d = Float.intBitsToFloat(this.reader.nextInt());
        } else if (by == UtilsKt.getHEADER_FLOAT_64()) {
            d = Double.longBitsToDouble(this.reader.nextLong());
        } else {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "DOUBLE (" + UtilsKt.getHEADER_FLOAT_16() + ", " + UtilsKt.getHEADER_FLOAT_32() + ", " + UtilsKt.getHEADER_FLOAT_64() + ")");
        }
        return d;
    }

    public byte decodeByte() {
        byte by;
        byte header;
        byte major;
        CborDecoder this_$iv;
        CborDecoder cborDecoder = this;
        int depth$iv = this.depth;
        boolean $i$f$getMajor = false;
        if ((byte)this_$iv.tracker[depth$iv * 4 + 1] == 64) {
            byte peek;
            this_$iv = this;
            depth$iv = this.depth;
            boolean $i$f$getCollectionSize = false;
            if (this_$iv.tracker[depth$iv * 4 + 2] == -1 && (byte)((peek = this.reader.peek()) & 0xFFFFFFE0) == 64) {
                CborDecoder this_$iv2 = this;
                boolean $i$f$skipSimpleElement = false;
                this_$iv2.reader.consume();
                if ((byte)(peek & 0x1F) == 24) {
                    this_$iv2.reader.skip(1);
                } else if ((byte)(peek & 0x1F) == 25) {
                    this_$iv2.reader.skip(2);
                } else if ((byte)(peek & 0x1F) == 26) {
                    this_$iv2.reader.skip(4);
                } else if ((byte)(peek & 0x1F) == 27) {
                    this_$iv2.reader.skip(8);
                }
            }
        }
        if ((major = (byte)((header = this.reader.peekConsume()) & 0xFFFFFFE0)) != 0 && major != 32) {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "BYTE (Majors: 0, 32)");
        }
        byte size = (byte)(header & 0x1F);
        if (size < 24) {
            by = major == 32 ? (byte)(~size) : size;
        } else if (size == 24) {
            byte result = this.reader.nextByte();
            if (result < 0) {
                throw new CborDecoderException.UnfitValue(this.reader.totalRead(), "Byte", ULong.constructor-impl((long)result), null);
            }
            by = major == 32 ? (byte)(~result) : result;
        } else {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "BYTE (bits size should be <= 24)");
        }
        return by;
    }

    public short decodeShort() {
        short s;
        byte header = this.reader.peekConsume();
        byte major = (byte)(header & 0xFFFFFFE0);
        if (major != 0 && major != 32) {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "SHORT (Majors: 0, 32)");
        }
        byte size = (byte)(header & 0x1F);
        if (size < 24) {
            s = major == 32 ? (short)(~size) : (short)size;
        } else if (size == 24) {
            short result = (short)((short)this.reader.nextByte() & 0xFF);
            s = major == 32 ? (short)(~result) : result;
        } else if (size == 25) {
            short result = this.reader.nextShort();
            if (result < 0) {
                throw new CborDecoderException.UnfitValue(this.reader.totalRead(), "Short", ULong.constructor-impl((long)result), null);
            }
            s = major == 32 ? (short)(~result) : result;
        } else {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "SHORT (bits size should be <= 25)");
        }
        return s;
    }

    public int decodeInt() {
        byte by;
        byte header = this.reader.peekConsume();
        byte major = (byte)(header & 0xFFFFFFE0);
        if (major != 0 && major != 32) {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "INT (Majors: 0, 32)");
        }
        byte size = (byte)(header & 0x1F);
        if (size < 24) {
            by = major == 32 ? (byte)(~size) : size;
        } else if (size == 24) {
            int result = this.reader.nextByte() & 0xFF;
            by = major == 32 ? (byte)(~result) : (byte)result;
        } else if (size == 25) {
            int result = this.reader.nextShort() & 0xFFFF;
            by = major == 32 ? (byte)(~result) : (byte)result;
        } else if (size == 26) {
            int result = this.reader.nextInt();
            if (result < 0) {
                throw new CborDecoderException.UnfitValue(this.reader.totalRead(), "Int", ULong.constructor-impl((long)result), null);
            }
            by = major == 32 ? (byte)(~result) : (byte)result;
        } else {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "INT (bits size should be <= 26)");
        }
        return by;
    }

    public long decodeLong() {
        long l;
        byte header = this.reader.peekConsume();
        byte major = (byte)(header & 0xFFFFFFE0);
        if (major != 0 && major != 32) {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "LONG (Majors: 0, 32)");
        }
        byte size = (byte)(header & 0x1F);
        if (size < 24) {
            l = major == 32 ? (long)(~size) : (long)size;
        } else if (size == 24) {
            long result = (long)this.reader.nextByte() & 0xFFL;
            l = major == 32 ? result ^ 0xFFFFFFFFFFFFFFFFL : result;
        } else if (size == 25) {
            long result = (long)this.reader.nextShort() & 0xFFFFL;
            l = major == 32 ? result ^ 0xFFFFFFFFFFFFFFFFL : result;
        } else if (size == 26) {
            long result = (long)this.reader.nextInt() & 0xFFFFFFFFL;
            l = major == 32 ? result ^ 0xFFFFFFFFFFFFFFFFL : result;
        } else if (size == 27) {
            long result = this.reader.nextLong();
            if (result < 0L) {
                throw new CborDecoderException.UnfitValue(this.reader.totalRead(), "Long", ULong.constructor-impl((long)result), null);
            }
            l = major == 32 ? result ^ 0xFFFFFFFFFFFFFFFFL : result;
        } else {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "LONG (bits size should be <= 27)");
        }
        return l;
    }

    public char decodeChar() {
        String result = this.decodeString();
        if (result.length() != 1) {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "Tried to decode a single char but found '" + result + "'");
        }
        return result.charAt(0);
    }

    @NotNull
    public String decodeString() {
        int n;
        byte header = this.reader.peek();
        if ((byte)(header & 0xFFFFFFE0) != 96) {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "STRING (Majors: 96)");
        }
        byte by = header & 0x1F;
        if (by < 24) {
            n = by;
        } else if (by == 24) {
            n = this.reader.nextByte() & 0xFF;
        } else if (by == 25) {
            n = this.reader.nextShort() & 0xFFFF;
        } else if (by == 26) {
            int result = this.reader.nextInt();
            if (result < 0) {
                throw new CborDecoderException.CollectionSizeTooLarge(this.reader.totalRead(), ULong.constructor-impl((long)result), null);
            }
            n = result;
        } else {
            if (by == 31) {
                return this.decodeStringIndefinite();
            }
            throw new CborDecoderException.InvalidSizeElement(this.reader.totalRead(), by, 27, true);
        }
        byte by2 = n;
        this.reader.consume();
        return this.reader.readString(by2);
    }

    /*
     * WARNING - void declaration
     */
    private final String decodeStringIndefinite() {
        CompositeDecoder composite$iv;
        void $this$mapTo$iv$iv$iv;
        void klass$iv;
        StringBuilder builder = new StringBuilder();
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CborDecoder.class)};
        boolean $i$f$name = false;
        void $this$map$iv$iv = klass$iv;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(((void)$this$map$iv$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it$iv;
            void item$iv$iv$iv;
            void var13_16 = item$iv$iv$iv = $this$mapTo$iv$iv$iv[i];
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            collection.add(it$iv.getSimpleName());
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        ListStringsDescriptor descriptor = new ListStringsDescriptor(string);
        Decoder $this$decodeStructure$iv = this;
        boolean $i$f$decodeStructure = false;
        CompositeDecoder $this$decodeStringIndefinite_u24lambda_u242 = composite$iv = $this$decodeStructure$iv.beginStructure((SerialDescriptor)descriptor);
        boolean bl = false;
        CompositeDecoder $this$assertCborDecoder$iv = $this$decodeStringIndefinite_u24lambda_u242;
        boolean $i$f$assertCborDecoder = false;
        if (!($this$assertCborDecoder$iv instanceof CborDecoder)) {
            new IllegalStateException;
            boolean bl2 = false;
            boolean $i$f$decodeStringIndefinite$lambda$2$stub_for_inlining = false;
            boolean $i$f$unreachable = false;
            throw new NotImplementedError("Unreachable code reached.");
        }
        int index = 0;
        while ((index = ((CborDecoder)$this$decodeStringIndefinite_u24lambda_u242).decodeElementIndex(descriptor)) != -1) {
            builder.append(((CborDecoder)$this$decodeStringIndefinite_u24lambda_u242).decodeStringElement(descriptor.getElementDescriptor(index), index));
        }
        Unit result$iv = Unit.INSTANCE;
        composite$iv.endStructure((SerialDescriptor)descriptor);
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final byte[] decodeBytes() {
        int n;
        byte header = this.reader.peek();
        if ((byte)(header & 0xFFFFFFE0) != 64) {
            throw new CborDecoderException.FailedToDecodeElement(this.reader.totalRead(), "BYTEARRAY (Majors: 64)");
        }
        byte by = header & 0x1F;
        if (by < 24) {
            n = by;
        } else if (by == 24) {
            n = this.reader.nextByte() & 0xFF;
        } else if (by == 25) {
            n = this.reader.nextShort() & 0xFFFF;
        } else if (by == 26) {
            int result = this.reader.nextInt();
            if (result < 0) {
                throw new CborDecoderException.CollectionSizeTooLarge(this.reader.totalRead(), ULong.constructor-impl((long)result), null);
            }
            n = result;
        } else {
            if (by == 31) {
                return this.decodeBytesIndefinite();
            }
            throw new CborDecoderException.InvalidSizeElement(this.reader.totalRead(), by, 26, true);
        }
        byte by2 = n;
        this.reader.consume();
        return (byte[])this.reader.read(by2);
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] decodeBytesIndefinite() {
        CompositeDecoder composite$iv;
        void $this$mapTo$iv$iv$iv;
        ExpandableByteArray result = new ExpandableByteArray(0, 1, null);
        byte[] buffer = null;
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CborDecoder.class)};
        KClass[] klass$iv = kClassArray;
        boolean $i$f$name = false;
        KClass[] $this$map$iv$iv = klass$iv;
        boolean $i$f$map = false;
        KClass[] kClassArray2 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList($this$map$iv$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it$iv;
            void item$iv$iv$iv;
            void var14_17 = item$iv$iv$iv = $this$mapTo$iv$iv$iv[i];
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            collection.add(it$iv.getSimpleName());
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        ListBytesDescriptor descriptor = new ListBytesDescriptor(string);
        Decoder $this$decodeStructure$iv = this;
        boolean $i$f$decodeStructure = false;
        CompositeDecoder $this$decodeBytesIndefinite_u24lambda_u244 = composite$iv = $this$decodeStructure$iv.beginStructure((SerialDescriptor)descriptor);
        boolean bl = false;
        CompositeDecoder $this$assertCborDecoder$iv = $this$decodeBytesIndefinite_u24lambda_u244;
        boolean $i$f$assertCborDecoder = false;
        if (!($this$assertCborDecoder$iv instanceof CborDecoder)) {
            new IllegalStateException;
            boolean bl2 = false;
            boolean $i$f$decodeBytesIndefinite$lambda$4$stub_for_inlining$3 = false;
            boolean $i$f$unreachable = false;
            throw new NotImplementedError("Unreachable code reached.");
        }
        int index = 0;
        while ((index = ((CborDecoder)$this$decodeBytesIndefinite_u24lambda_u244).decodeElementIndex(descriptor)) != -1) {
            buffer = ((CborDecoder)$this$decodeBytesIndefinite_u24lambda_u244).decodeBytesElement(descriptor.getElementDescriptor(index), index);
            result.write(buffer, 0, buffer.length);
        }
        Unit result$iv = Unit.INSTANCE;
        composite$iv.endStructure((SerialDescriptor)descriptor);
        return result.getSizedArray();
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return enumDescriptor.getElementIndex(this.decodeString());
    }

    public final byte decodeUByte-w2LRezQ() {
        byte by;
        byte it = this.reader.peekConsume();
        byte by2 = UtilsKt.getHEADER_POSITIVE_8();
        byte by3 = it;
        boolean bl = 0 <= by3 ? by3 < by2 : false;
        if (bl) {
            by = UByte.constructor-impl((byte)((byte)(it & 0x1F)));
        } else if (it == UtilsKt.getHEADER_POSITIVE_8()) {
            by = UByte.constructor-impl((byte)this.reader.nextByte());
        } else {
            throw new CborDecoderException.InvalidUnsignedValue(this.reader.totalRead(), "UByte", it);
        }
        return by;
    }

    public final short decodeUShort-Mh2AYeg() {
        short s;
        byte it = this.reader.peekConsume();
        byte by = UtilsKt.getHEADER_POSITIVE_8();
        byte by2 = it;
        boolean bl = 0 <= by2 ? by2 < by : false;
        if (bl) {
            s = UShort.constructor-impl((short)((byte)(it & 0x1F)));
        } else if (it == UtilsKt.getHEADER_POSITIVE_8()) {
            s = UShort.constructor-impl((short)((short)((short)UByte.constructor-impl((byte)this.reader.nextByte()) & 0xFF)));
        } else if (it == UtilsKt.getHEADER_POSITIVE_16()) {
            s = UShort.constructor-impl((short)this.reader.nextShort());
        } else {
            throw new CborDecoderException.InvalidUnsignedValue(this.reader.totalRead(), "UShort", it);
        }
        return s;
    }

    public final int decodeUInt-pVg5ArA() {
        int n;
        byte it = this.reader.peekConsume();
        byte by = UtilsKt.getHEADER_POSITIVE_8();
        byte by2 = it;
        boolean bl = 0 <= by2 ? by2 < by : false;
        if (bl) {
            n = UInt.constructor-impl((int)((byte)(it & 0x1F)));
        } else if (it == UtilsKt.getHEADER_POSITIVE_8()) {
            n = UInt.constructor-impl((int)(UByte.constructor-impl((byte)this.reader.nextByte()) & 0xFF));
        } else if (it == UtilsKt.getHEADER_POSITIVE_16()) {
            n = UInt.constructor-impl((int)(UShort.constructor-impl((short)this.reader.nextShort()) & 0xFFFF));
        } else if (it == UtilsKt.getHEADER_POSITIVE_32()) {
            n = UInt.constructor-impl((int)this.reader.nextInt());
        } else {
            throw new CborDecoderException.InvalidUnsignedValue(this.reader.totalRead(), "UInt", it);
        }
        return n;
    }

    public final long decodeULong-s-VKNKU() {
        long l;
        byte it = this.reader.peekConsume();
        byte by = UtilsKt.getHEADER_POSITIVE_8();
        byte by2 = it;
        boolean bl = 0 <= by2 ? by2 < by : false;
        if (bl) {
            l = ULong.constructor-impl((long)((byte)(it & 0x1F)));
        } else if (it == UtilsKt.getHEADER_POSITIVE_8()) {
            l = ULong.constructor-impl((long)((long)UByte.constructor-impl((byte)this.reader.nextByte()) & 0xFFL));
        } else if (it == UtilsKt.getHEADER_POSITIVE_16()) {
            l = ULong.constructor-impl((long)((long)UShort.constructor-impl((short)this.reader.nextShort()) & 0xFFFFL));
        } else if (it == UtilsKt.getHEADER_POSITIVE_32()) {
            l = ULong.constructor-impl((long)((long)UInt.constructor-impl((int)this.reader.nextInt()) & 0xFFFFFFFFL));
        } else if (it == UtilsKt.getHEADER_POSITIVE_64()) {
            l = ULong.constructor-impl((long)this.reader.nextLong());
        } else {
            throw new CborDecoderException.InvalidUnsignedValue(this.reader.totalRead(), "ULong", it);
        }
        return l;
    }

    public final byte decodeNegativeUByte-w2LRezQ() {
        byte by;
        byte it = this.reader.peekConsume();
        byte by2 = UtilsKt.getHEADER_NEGATIVE_8();
        byte by3 = it;
        boolean bl = 32 <= by3 ? by3 < by2 : false;
        if (bl) {
            by = UByte.constructor-impl((byte)((byte)(it & 0x1F)));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_8()) {
            by = UByte.constructor-impl((byte)UByte.constructor-impl((byte)this.reader.nextByte()));
        } else {
            throw new CborDecoderException.InvalidUnsignedValue(this.reader.totalRead(), "UByte", it);
        }
        return by;
    }

    public final short decodeNegativeUShort-Mh2AYeg() {
        short s;
        byte it = this.reader.peekConsume();
        byte by = UtilsKt.getHEADER_NEGATIVE_8();
        byte by2 = it;
        boolean bl = 32 <= by2 ? by2 < by : false;
        if (bl) {
            s = UShort.constructor-impl((short)((byte)(it & 0x1F)));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_8()) {
            s = UShort.constructor-impl((short)((short)((short)UByte.constructor-impl((byte)this.reader.nextByte()) & 0xFF)));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_16()) {
            s = UShort.constructor-impl((short)this.reader.nextShort());
        } else {
            throw new CborDecoderException.InvalidUnsignedValue(this.reader.totalRead(), "UShort", it);
        }
        return s;
    }

    public final int decodeNegativeUInt-pVg5ArA() {
        int n;
        byte it = this.reader.peekConsume();
        byte by = UtilsKt.getHEADER_NEGATIVE_8();
        byte by2 = it;
        boolean bl = 32 <= by2 ? by2 < by : false;
        if (bl) {
            n = UInt.constructor-impl((int)((byte)(it & 0x1F)));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_8()) {
            n = UInt.constructor-impl((int)(UByte.constructor-impl((byte)this.reader.nextByte()) & 0xFF));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_16()) {
            n = UInt.constructor-impl((int)(UShort.constructor-impl((short)this.reader.nextShort()) & 0xFFFF));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_32()) {
            n = UInt.constructor-impl((int)this.reader.nextInt());
        } else {
            throw new CborDecoderException.InvalidUnsignedValue(this.reader.totalRead(), "UInt", it);
        }
        return n;
    }

    public final long decodeNegativeULong-s-VKNKU() {
        long l;
        byte it = this.reader.peekConsume();
        byte by = UtilsKt.getHEADER_NEGATIVE_8();
        byte by2 = it;
        boolean bl = 32 <= by2 ? by2 < by : false;
        if (bl) {
            l = ULong.constructor-impl((long)((byte)(it & 0x1F)));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_8()) {
            l = ULong.constructor-impl((long)((long)UByte.constructor-impl((byte)this.reader.nextByte()) & 0xFFL));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_16()) {
            l = ULong.constructor-impl((long)((long)UShort.constructor-impl((short)this.reader.nextShort()) & 0xFFFFL));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_32()) {
            l = ULong.constructor-impl((long)((long)UInt.constructor-impl((int)this.reader.nextInt()) & 0xFFFFFFFFL));
        } else if (it == UtilsKt.getHEADER_NEGATIVE_64()) {
            l = ULong.constructor-impl((long)this.reader.nextLong());
        } else {
            throw new CborDecoderException.InvalidUnsignedValue(this.reader.totalRead(), "ULong", it);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private final void skipElement() {
        void $this$hasMajor$iv;
        byte peek = this.reader.peek();
        byte by = peek;
        byte flags$iv = (byte)(0x40 | 0x60);
        boolean $i$f$hasMajor = false;
        if ((byte)($this$hasMajor$iv & 0xFFFFFFE0) == flags$iv) {
            if ((byte)(peek & 0x1F) == 31) {
                CborDecoder this_$iv = this;
                $i$f$skipRepeatIndefinite = false;
                this_$iv.reader.consume();
                while (this_$iv.reader.peek() != UtilsKt.getHEADER_BREAK()) {
                    this_$iv.skipElement();
                }
                this_$iv.reader.consume();
            } else {
                long l;
                CborDecoder this_$iv = this;
                boolean bl = false;
                this_$iv.reader.consume();
                if ((byte)(peek & 0x18) == 24) {
                    l = ULong.constructor-impl((long)((long)UByte.constructor-impl((byte)this_$iv.reader.nextByte()) & 0xFFL));
                } else if ((byte)(peek & 0x19) == 25) {
                    l = ULong.constructor-impl((long)((long)UShort.constructor-impl((short)this_$iv.reader.nextShort()) & 0xFFFFL));
                } else if ((byte)(peek & 0x1A) == 26) {
                    l = ULong.constructor-impl((long)((long)UInt.constructor-impl((int)this_$iv.reader.nextInt()) & 0xFFFFFFFFL));
                } else if ((byte)(peek & 0x1B) == 27) {
                    l = ULong.constructor-impl((long)this_$iv.reader.nextLong());
                } else if ((byte)(peek & (byte)(~-32)) < 24) {
                    l = ULong.constructor-impl((long)((byte)(peek & (byte)(~-32))));
                } else {
                    throw new CborDecoderException.InvalidSizeElement(this_$iv.reader.totalRead(), (byte)(peek & 0x1F), 27, false);
                }
                this.reader.skip((int)l);
            }
        } else {
            byte this_$iv = peek;
            flags$iv = -128;
            $i$f$hasMajor = false;
            if ((byte)($this$hasMajor$iv & 0xFFFFFFE0) == flags$iv) {
                if ((byte)(peek & 0x1F) == 31) {
                    CborDecoder this_$iv2 = this;
                    $i$f$skipRepeatIndefinite = false;
                    this_$iv2.reader.consume();
                    while (this_$iv2.reader.peek() != UtilsKt.getHEADER_BREAK()) {
                        this_$iv2.skipElement();
                    }
                    this_$iv2.reader.consume();
                } else {
                    long l;
                    CborDecoder this_$iv3 = this;
                    $i$f$skipRepeat = false;
                    CborDecoder this_$iv$iv = this_$iv3;
                    boolean bl = false;
                    this_$iv$iv.reader.consume();
                    if ((byte)(peek & 0x18) == 24) {
                        l = ULong.constructor-impl((long)((long)UByte.constructor-impl((byte)this_$iv$iv.reader.nextByte()) & 0xFFL));
                    } else if ((byte)(peek & 0x19) == 25) {
                        l = ULong.constructor-impl((long)((long)UShort.constructor-impl((short)this_$iv$iv.reader.nextShort()) & 0xFFFFL));
                    } else if ((byte)(peek & 0x1A) == 26) {
                        l = ULong.constructor-impl((long)((long)UInt.constructor-impl((int)this_$iv$iv.reader.nextInt()) & 0xFFFFFFFFL));
                    } else if ((byte)(peek & 0x1B) == 27) {
                        l = ULong.constructor-impl((long)this_$iv$iv.reader.nextLong());
                    } else if ((byte)(peek & (byte)(~-32)) < 24) {
                        l = ULong.constructor-impl((long)((byte)(peek & (byte)(~-32))));
                    } else {
                        throw new CborDecoderException.InvalidSizeElement(this_$iv$iv.reader.totalRead(), (byte)(peek & 0x1F), 27, false);
                    }
                    long count$iv = l;
                    long index$iv = ULong.constructor-impl((long)0L);
                    while (Long.compareUnsigned(index$iv, count$iv) < 0) {
                        boolean bl2 = false;
                        this.skipElement();
                        index$iv = ULong.constructor-impl((long)(index$iv + 1L));
                    }
                }
            } else {
                this_$iv = peek;
                flags$iv = -96;
                $i$f$hasMajor = false;
                if ((byte)($this$hasMajor$iv & 0xFFFFFFE0) == flags$iv) {
                    if ((byte)(peek & 0x1F) == 31) {
                        CborDecoder this_$iv4 = this;
                        $i$f$skipRepeatIndefinite = false;
                        this_$iv4.reader.consume();
                        while (this_$iv4.reader.peek() != UtilsKt.getHEADER_BREAK()) {
                            this_$iv4.skipElement();
                        }
                        this_$iv4.reader.consume();
                    } else {
                        long l;
                        CborDecoder this_$iv5 = this;
                        $i$f$skipRepeat = false;
                        CborDecoder this_$iv$iv = this_$iv5;
                        boolean bl = false;
                        this_$iv$iv.reader.consume();
                        if ((byte)(peek & 0x18) == 24) {
                            l = ULong.constructor-impl((long)((long)UByte.constructor-impl((byte)this_$iv$iv.reader.nextByte()) & 0xFFL));
                        } else if ((byte)(peek & 0x19) == 25) {
                            l = ULong.constructor-impl((long)((long)UShort.constructor-impl((short)this_$iv$iv.reader.nextShort()) & 0xFFFFL));
                        } else if ((byte)(peek & 0x1A) == 26) {
                            l = ULong.constructor-impl((long)((long)UInt.constructor-impl((int)this_$iv$iv.reader.nextInt()) & 0xFFFFFFFFL));
                        } else if ((byte)(peek & 0x1B) == 27) {
                            l = ULong.constructor-impl((long)this_$iv$iv.reader.nextLong());
                        } else if ((byte)(peek & (byte)(~-32)) < 24) {
                            l = ULong.constructor-impl((long)((byte)(peek & (byte)(~-32))));
                        } else {
                            throw new CborDecoderException.InvalidSizeElement(this_$iv$iv.reader.totalRead(), (byte)(peek & 0x1F), 27, false);
                        }
                        long count$iv = l;
                        long index$iv = ULong.constructor-impl((long)0L);
                        while (Long.compareUnsigned(index$iv, count$iv) < 0) {
                            boolean bl3 = false;
                            this.skipElement();
                            this.skipElement();
                            index$iv = ULong.constructor-impl((long)(index$iv + 1L));
                        }
                    }
                } else {
                    CborDecoder this_$iv6 = this;
                    boolean $i$f$skipSimpleElement = false;
                    this_$iv6.reader.consume();
                    if ((byte)(peek & 0x1F) == 24) {
                        this_$iv6.reader.skip(1);
                    } else if ((byte)(peek & 0x1F) == 25) {
                        this_$iv6.reader.skip(2);
                    } else if ((byte)(peek & 0x1F) == 26) {
                        this_$iv6.reader.skip(4);
                    } else if ((byte)(peek & 0x1F) == 27) {
                        this_$iv6.reader.skip(8);
                    }
                }
            }
        }
    }

    private final long getSize-I7RO_PI(byte peek) {
        long l;
        boolean bl = false;
        this.reader.consume();
        if ((byte)(peek & 0x18) == 24) {
            l = ULong.constructor-impl((long)((long)UByte.constructor-impl((byte)this.reader.nextByte()) & 0xFFL));
        } else if ((byte)(peek & 0x19) == 25) {
            l = ULong.constructor-impl((long)((long)UShort.constructor-impl((short)this.reader.nextShort()) & 0xFFFFL));
        } else if ((byte)(peek & 0x1A) == 26) {
            l = ULong.constructor-impl((long)((long)UInt.constructor-impl((int)this.reader.nextInt()) & 0xFFFFFFFFL));
        } else if ((byte)(peek & 0x1B) == 27) {
            l = ULong.constructor-impl((long)this.reader.nextLong());
        } else if ((byte)(peek & (byte)(~-32)) < 24) {
            l = ULong.constructor-impl((long)((byte)(peek & (byte)(~-32))));
        } else {
            throw new CborDecoderException.InvalidSizeElement(this.reader.totalRead(), (byte)(peek & 0x1F), 27, false);
        }
        return l;
    }

    private final void skipRepeat(byte peek, Function0<Unit> onItem) {
        long l;
        boolean $i$f$skipRepeat = false;
        CborDecoder this_$iv = this;
        boolean bl = false;
        this_$iv.reader.consume();
        if ((byte)(peek & 0x18) == 24) {
            l = ULong.constructor-impl((long)((long)UByte.constructor-impl((byte)this_$iv.reader.nextByte()) & 0xFFL));
        } else if ((byte)(peek & 0x19) == 25) {
            l = ULong.constructor-impl((long)((long)UShort.constructor-impl((short)this_$iv.reader.nextShort()) & 0xFFFFL));
        } else if ((byte)(peek & 0x1A) == 26) {
            l = ULong.constructor-impl((long)((long)UInt.constructor-impl((int)this_$iv.reader.nextInt()) & 0xFFFFFFFFL));
        } else if ((byte)(peek & 0x1B) == 27) {
            l = ULong.constructor-impl((long)this_$iv.reader.nextLong());
        } else if ((byte)(peek & (byte)(~-32)) < 24) {
            l = ULong.constructor-impl((long)((byte)(peek & (byte)(~-32))));
        } else {
            throw new CborDecoderException.InvalidSizeElement(this_$iv.reader.totalRead(), (byte)(peek & 0x1F), 27, false);
        }
        long count = l;
        long index = ULong.constructor-impl((long)0L);
        while (Long.compareUnsigned(index, count) < 0) {
            onItem.invoke();
            long l2 = index;
            index = ULong.constructor-impl((long)(l2 + 1L));
        }
    }

    private final void skipRepeatIndefinite() {
        boolean $i$f$skipRepeatIndefinite = false;
        this.reader.consume();
        while (this.reader.peek() != UtilsKt.getHEADER_BREAK()) {
            this.skipElement();
        }
        this.reader.consume();
    }

    private final void skipSimpleElement(byte peek) {
        boolean $i$f$skipSimpleElement = false;
        this.reader.consume();
        if ((byte)(peek & 0x1F) == 24) {
            this.reader.skip(1);
        } else if ((byte)(peek & 0x1F) == 25) {
            this.reader.skip(2);
        } else if ((byte)(peek & 0x1F) == 26) {
            this.reader.skip(4);
        } else if ((byte)(peek & 0x1F) == 27) {
            this.reader.skip(8);
        }
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        return (T)Decoder.DefaultImpls.decodeSerializableValue((Decoder)this, deserializer);
    }

    @ExperimentalSerializationApi
    @Nullable
    public <T> T decodeNullableSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        return (T)Decoder.DefaultImpls.decodeNullableSerializableValue((Decoder)this, deserializer);
    }

    @ExperimentalSerializationApi
    public boolean decodeSequentially() {
        return CompositeDecoder.DefaultImpls.decodeSequentially((CompositeDecoder)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/orandja/obor/codec/CborDecoder$Companion;", "", "<init>", "()V", "INLINE", "", "STRUCTURE", "TUPLE", "INLINE_TUPLE", "obor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

