/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.io.specific;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.orandja.obor.io.ByteWriter;
import net.orandja.obor.io.CborWriter;
import net.orandja.obor.io.specific.ExpandableByteArray;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\b\u0000\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u001d\u0010\u0017\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0082\bJ\u001d\u0010\u0017\u001a\u00020\b*\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0082\bJ\u001d\u0010\u0017\u001a\u00020\b*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0082\bJ\t\u0010\u001b\u001a\u00020\u0015H\u0096\u0001J\u0011\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0096\u0001J\u0011\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0096\u0001J!\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/orandja/obor/io/specific/CborWriterExpandableByteArray;", "Lnet/orandja/obor/io/CborWriter;", "Lnet/orandja/obor/io/ByteWriter;", "vector", "Lnet/orandja/obor/io/specific/ExpandableByteArray;", "<init>", "(Lnet/orandja/obor/io/specific/ExpandableByteArray;)V", "writeMajor8", "", "major", "", "value", "writeHeader8", "header", "writeMajor16", "", "writeHeader16", "writeMajor32", "", "writeHeader32", "writeMajor64", "", "writeHeader64", "into", "buffer", "", "offset", "totalWrite", "write", "byteArray", "array", "count", "Companion", "obor"})
@SourceDebugExtension(value={"SMAP\nCborWriterExpandableByteArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborWriterExpandableByteArray.kt\nnet/orandja/obor/io/specific/CborWriterExpandableByteArray\n*L\n1#1,97:1\n74#1,3:98\n80#1,5:101\n88#1,9:106\n*S KotlinDebug\n*F\n+ 1 CborWriterExpandableByteArray.kt\nnet/orandja/obor/io/specific/CborWriterExpandableByteArray\n*L\n44#1:98,3\n56#1:101,5\n68#1:106,9\n*E\n"})
public final class CborWriterExpandableByteArray
implements CborWriter,
ByteWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExpandableByteArray vector;
    private static final short SHORT_BYTE_MASK = -256;
    private static final int INT_SHORT_MASK = -65536;
    private static final long LONG_INT_MASK = -4294967296L;

    public CborWriterExpandableByteArray(@NotNull ExpandableByteArray vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        this.vector = vector;
    }

    @Override
    public void writeMajor8(byte major, byte value) {
        byte by = value;
        boolean bl = 0 <= by ? by < 24 : false;
        if (bl) {
            this.vector.write((byte)(major | value));
        } else {
            this.writeHeader8((byte)(major | 0x18), value);
        }
    }

    @Override
    public void writeHeader8(byte header, byte value) {
        this.vector.ensureCapacity(2);
        this.vector.getArray()[this.vector.getSize()] = header;
        this.vector.getArray()[this.vector.getSize() + 1] = value;
        ExpandableByteArray expandableByteArray = this.vector;
        expandableByteArray.setSize(expandableByteArray.getSize() + 2);
    }

    @Override
    public void writeMajor16(byte major, short value) {
        if ((short)(value & 0xFFFFFF00) == 0) {
            this.writeMajor8(major, (byte)value);
        } else {
            this.writeHeader16((byte)(major | 0x19), value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeHeader16(byte header, short value) {
        void $this$into$iv;
        this.vector.ensureCapacity(3);
        this.vector.getArray()[this.vector.getSize()] = header;
        ByteWriter byteWriter = this;
        short s = value;
        byte[] byArray = this.vector.getArray();
        int offset$iv = this.vector.getSize() + 1;
        boolean $i$f$into = false;
        buffer$iv[0 + offset$iv] = (byte)($this$into$iv >> 8 & 0xFF);
        buffer$iv[1 + offset$iv] = (byte)($this$into$iv & 0xFF);
        byteWriter = this.vector;
        ((ExpandableByteArray)byteWriter).setSize(((ExpandableByteArray)byteWriter).getSize() + 3);
    }

    @Override
    public void writeMajor32(byte major, int value) {
        if ((value & 0xFFFF0000) == 0) {
            this.writeMajor16(major, (short)value);
        } else {
            this.writeHeader32((byte)(major | 0x1A), value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeHeader32(byte header, int value) {
        void $this$into$iv;
        this.vector.ensureCapacity(5);
        this.vector.getArray()[this.vector.getSize()] = header;
        ByteWriter byteWriter = this;
        int n = value;
        byte[] byArray = this.vector.getArray();
        int offset$iv = this.vector.getSize() + 1;
        boolean $i$f$into = false;
        buffer$iv[0 + offset$iv] = (byte)($this$into$iv >> 24 & 0xFF);
        buffer$iv[1 + offset$iv] = (byte)($this$into$iv >> 16 & 0xFF);
        buffer$iv[2 + offset$iv] = (byte)($this$into$iv >> 8 & 0xFF);
        buffer$iv[3 + offset$iv] = (byte)($this$into$iv & 0xFF);
        byteWriter = this.vector;
        ((ExpandableByteArray)byteWriter).setSize(((ExpandableByteArray)byteWriter).getSize() + 5);
    }

    @Override
    public void writeMajor64(byte major, long value) {
        if ((value & 0xFFFFFFFF00000000L) == 0L) {
            this.writeMajor32(major, (int)value);
        } else {
            this.writeHeader64((byte)(major | 0x1B), value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeHeader64(byte header, long value) {
        void $this$into$iv;
        this.vector.ensureCapacity(9);
        this.vector.getArray()[this.vector.getSize()] = header;
        ByteWriter byteWriter = this;
        long l = value;
        byte[] byArray = this.vector.getArray();
        int offset$iv = this.vector.getSize() + 1;
        boolean $i$f$into = false;
        buffer$iv[0 + offset$iv] = (byte)($this$into$iv >> 56 & 0xFFL);
        buffer$iv[1 + offset$iv] = (byte)($this$into$iv >> 48 & 0xFFL);
        buffer$iv[2 + offset$iv] = (byte)($this$into$iv >> 40 & 0xFFL);
        buffer$iv[3 + offset$iv] = (byte)($this$into$iv >> 32 & 0xFFL);
        buffer$iv[4 + offset$iv] = (byte)($this$into$iv >> 24 & 0xFFL);
        buffer$iv[5 + offset$iv] = (byte)($this$into$iv >> 16 & 0xFFL);
        buffer$iv[6 + offset$iv] = (byte)($this$into$iv >> 8 & 0xFFL);
        buffer$iv[7 + offset$iv] = (byte)($this$into$iv & 0xFFL);
        byteWriter = this.vector;
        ((ExpandableByteArray)byteWriter).setSize(((ExpandableByteArray)byteWriter).getSize() + 9);
    }

    private final void into(short $this$into, byte[] buffer, int offset) {
        boolean $i$f$into = false;
        buffer[0 + offset] = (byte)($this$into >> 8 & 0xFF);
        buffer[1 + offset] = (byte)($this$into & 0xFF);
    }

    private final void into(int $this$into, byte[] buffer, int offset) {
        boolean $i$f$into = false;
        buffer[0 + offset] = (byte)($this$into >> 24 & 0xFF);
        buffer[1 + offset] = (byte)($this$into >> 16 & 0xFF);
        buffer[2 + offset] = (byte)($this$into >> 8 & 0xFF);
        buffer[3 + offset] = (byte)($this$into & 0xFF);
    }

    private final void into(long $this$into, byte[] buffer, int offset) {
        boolean $i$f$into = false;
        buffer[0 + offset] = (byte)($this$into >> 56 & 0xFFL);
        buffer[1 + offset] = (byte)($this$into >> 48 & 0xFFL);
        buffer[2 + offset] = (byte)($this$into >> 40 & 0xFFL);
        buffer[3 + offset] = (byte)($this$into >> 32 & 0xFFL);
        buffer[4 + offset] = (byte)($this$into >> 24 & 0xFFL);
        buffer[5 + offset] = (byte)($this$into >> 16 & 0xFFL);
        buffer[6 + offset] = (byte)($this$into >> 8 & 0xFFL);
        buffer[7 + offset] = (byte)($this$into & 0xFFL);
    }

    @Override
    public void write(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.vector.write(byteArray);
    }

    @Override
    public void write(byte value) {
        this.vector.write(value);
    }

    @Override
    public void write(@NotNull byte[] array, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.vector.write(array, offset, count);
    }

    @Override
    public long totalWrite() {
        return this.vector.totalWrite();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/orandja/obor/io/specific/CborWriterExpandableByteArray$Companion;", "", "<init>", "()V", "SHORT_BYTE_MASK", "", "INT_SHORT_MASK", "", "LONG_INT_MASK", "", "obor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

