/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.io;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.orandja.obor.io.ByteReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u000eJ\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H&J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000f"}, d2={"Lnet/orandja/obor/io/CborReader;", "Lnet/orandja/obor/io/ByteReader;", "peek", "", "consume", "", "peekConsume", "nextByte", "nextShort", "", "nextInt", "", "nextLong", "", "ByReader", "obor"})
public interface CborReader
extends ByteReader {
    public byte peek();

    public void consume();

    public byte peekConsume();

    public byte nextByte();

    public short nextShort();

    public int nextInt();

    public long nextLong();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u000e\u0010\u0014\u001a\u00020\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000fH\u0096\u0001J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u000fH\u0096\u0001J\t\u0010\u0019\u001a\u00020\u0011H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u001a"}, d2={"Lnet/orandja/obor/io/CborReader$ByReader;", "Lnet/orandja/obor/io/CborReader;", "Lnet/orandja/obor/io/ByteReader;", "reader", "<init>", "(Lnet/orandja/obor/io/ByteReader;)V", "peek", "", "Ljava/lang/Byte;", "consume", "", "nextByte", "nextShort", "", "nextInt", "", "nextLong", "", "skip", "count", "read", "()Ljava/lang/Byte;", "", "readString", "", "totalRead", "obor"})
    public static class ByReader
    implements CborReader,
    ByteReader {
        @NotNull
        private final ByteReader reader;
        @Nullable
        private Byte peek;

        public ByReader(@NotNull ByteReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
        }

        @Override
        public byte peek() {
            if (this.peek != null) {
                Byte by = this.peek;
                Intrinsics.checkNotNull((Object)by);
                return by;
            }
            Byte by = this.peek = this.read();
            Intrinsics.checkNotNull((Object)by);
            return by;
        }

        @Override
        public void consume() {
            this.peek = null;
        }

        @Override
        public byte nextByte() {
            return this.read();
        }

        @Override
        public short nextShort() {
            byte[] array = this.read(2);
            short result = (short)((array[0] & 0xFF) << 8 | array[1] & 0xFF);
            return result;
        }

        @Override
        public int nextInt() {
            byte[] array = this.read(4);
            int result = (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | array[3] & 0xFF;
            return result;
        }

        @Override
        public long nextLong() {
            byte[] array = this.read(8);
            long result = ((long)array[0] & 0xFFL) << 56 | ((long)array[1] & 0xFFL) << 48 | ((long)array[2] & 0xFFL) << 40 | ((long)array[3] & 0xFFL) << 32 | ((long)array[4] & 0xFFL) << 24 | ((long)array[5] & 0xFFL) << 16 | ((long)array[6] & 0xFFL) << 8 | (long)array[7] & 0xFFL;
            return result;
        }

        @Override
        public void skip(int count) {
            this.consume();
            this.reader.skip(count);
        }

        @Override
        public byte peekConsume() {
            return DefaultImpls.peekConsume(this);
        }

        @Override
        @NotNull
        public String readString(int count) {
            return this.reader.readString(count);
        }

        @Override
        public long totalRead() {
            return this.reader.totalRead();
        }

        @Override
        @NotNull
        public Byte read() {
            return (Byte)this.reader.read();
        }

        @Override
        @NotNull
        public byte[] read(int count) {
            return (byte[])this.reader.read(count);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static byte peekConsume(@NotNull CborReader $this) {
            byte result = $this.peek();
            $this.consume();
            return result;
        }
    }
}

