/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.io;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.orandja.obor.io.NativeArrayWriter;
import net.orandja.obor.io.WriterException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\b"}, d2={"Lnet/orandja/obor/io/ByteWriter;", "Lnet/orandja/obor/io/NativeArrayWriter;", "", "", "write", "", "byteArray", "Of", "obor"})
public interface ByteWriter
extends NativeArrayWriter<Byte, byte[]> {
    @Override
    public void write(@NotNull byte[] var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void write(@NotNull ByteWriter $this, @NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            $this.write(byteArray, 0, byteArray.length);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/orandja/obor/io/ByteWriter$Of;", "Lnet/orandja/obor/io/ByteWriter;", "byteArray", "", "<init>", "([B)V", "position", "", "totalWrite", "", "write", "", "value", "", "array", "offset", "count", "obor"})
    public static final class Of
    implements ByteWriter {
        @NotNull
        private final byte[] byteArray;
        private int position;

        public Of(@NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            this.byteArray = byteArray;
        }

        @Override
        public long totalWrite() {
            return this.position;
        }

        @Override
        public void write(byte value) {
            if (this.position >= this.byteArray.length) {
                throw new WriterException("Tried to write at position " + this.position + " but is out of bound for array of size " + this.byteArray.length, null, 2, null);
            }
            int n = this.position;
            this.position = n + 1;
            this.byteArray[n] = value;
        }

        @Override
        public void write(@NotNull byte[] array, int offset, int count) {
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)array, (String)"array");
                    if (count == 0) {
                        return;
                    }
                    boolean bl = 0 <= count ? count <= array.length : false;
                    if (!bl) break block5;
                    int n = array.length;
                    int n2 = count + offset;
                    if (0 <= n2 ? n2 <= n : false) break block6;
                }
                throw new WriterException("Requested array range is out of range. Range is " + new IntRange(0, array.length) + " Requested is " + RangesKt.until((int)count, (int)(count + offset)), null, 2, null);
            }
            if (this.position + count > this.byteArray.length) {
                throw new WriterException("Tried to write at " + RangesKt.until((int)this.position, (int)count) + " but is out of bound for array of size " + this.byteArray.length, null, 2, null);
            }
            ArraysKt.copyInto((byte[])array, (byte[])this.byteArray, (int)this.position, (int)offset, (int)(offset + count));
            this.position += count;
        }

        @Override
        public void write(@NotNull byte[] byteArray) {
            DefaultImpls.write(this, byteArray);
        }
    }
}

