/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.obor.codec.encoder;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import net.orandja.obor.annotations.CborInfinite;
import net.orandja.obor.annotations.CborRawBytes;
import net.orandja.obor.annotations.CborSkip;
import net.orandja.obor.annotations.CborTag;
import net.orandja.obor.codec.ByteArrayDescriptor;
import net.orandja.obor.codec.Float16Kt;
import net.orandja.obor.codec.Float32Kt;
import net.orandja.obor.codec.ListBytesDescriptor;
import net.orandja.obor.codec.ListStringsDescriptor;
import net.orandja.obor.codec.UtilsKt;
import net.orandja.obor.codec.encoder.CborByteStringEncoder;
import net.orandja.obor.codec.encoder.CborBytesEncoder;
import net.orandja.obor.codec.encoder.CborListEncoder;
import net.orandja.obor.codec.encoder.CborMapEncoder;
import net.orandja.obor.codec.encoder.CborStructureEncoder;
import net.orandja.obor.codec.encoder.CborTextEncoder;
import net.orandja.obor.io.CborWriter;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\b\u0010\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0004J\u0016\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0004J\u0016\u0010\u001a\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0004J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020 H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020#H\u0016J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010*\u001a\u00020,H\u0016J\u0017\u0010-\u001a\u00020\u00152\u0006\u0010*\u001a\u00020.H\u0016\u00a2\u0006\u0004\b/\u00100J\u0017\u00101\u001a\u00020\u00152\u0006\u0010*\u001a\u00020.H\u0016\u00a2\u0006\u0004\b2\u00100J\u0010\u00103\u001a\u00020\u00152\u0006\u0010*\u001a\u000204H\u0016J\u0017\u00105\u001a\u00020\u00152\u0006\u0010*\u001a\u000206H\u0016\u00a2\u0006\u0004\b7\u00108J\u0017\u00109\u001a\u00020\u00152\u0006\u0010*\u001a\u000206H\u0016\u00a2\u0006\u0004\b:\u00108J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010*\u001a\u00020 H\u0016J\u0017\u0010<\u001a\u00020\u00152\u0006\u0010*\u001a\u00020=H\u0016\u00a2\u0006\u0004\b>\u0010?J\u0017\u0010@\u001a\u00020\u00152\u0006\u0010*\u001a\u00020=H\u0016\u00a2\u0006\u0004\bA\u0010?J\u0010\u0010B\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\bH\u0016J\u0017\u0010C\u001a\u00020\u00152\u0006\u0010*\u001a\u00020DH\u0016\u00a2\u0006\u0004\bE\u0010FJ\u0017\u0010G\u001a\u00020\u00152\u0006\u0010*\u001a\u00020DH\u0016\u00a2\u0006\u0004\bH\u0010FJ\u0010\u0010I\u001a\u00020\u00152\u0006\u0010*\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u00152\u0006\u0010*\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020\u0015H\u0016J\u0010\u0010N\u001a\u00020\u00152\u0006\u0010*\u001a\u00020OH\u0004J\u0010\u0010P\u001a\u00020\u00152\u0006\u0010*\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u00152\u0006\u0010*\u001a\u00020OH\u0016J\u0010\u0010S\u001a\u00020\u00152\u0006\u0010*\u001a\u00020OH\u0002J$\u0010T\u001a\u00020\u00152\u0006\u0010*\u001a\u00020U2\b\b\u0002\u0010V\u001a\u00020 2\b\b\u0002\u0010W\u001a\u00020 H\u0016J \u0010X\u001a\u00020\u00152\u0006\u0010Y\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020 2\u0006\u0010*\u001a\u00020UH\u0016J$\u0010Z\u001a\u00020\u00152\u0006\u0010*\u001a\u00020U2\b\b\u0002\u0010V\u001a\u00020 2\b\b\u0002\u0010W\u001a\u00020 H\u0016J\u0018\u0010[\u001a\u00020\u00152\u0006\u0010\\\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020 H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0094\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006]"}, d2={"Lnet/orandja/obor/codec/encoder/CborEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "writer", "Lnet/orandja/obor/io/CborWriter;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "tracker", "", "", "<init>", "(Lnet/orandja/obor/io/CborWriter;Lkotlinx/serialization/modules/SerializersModule;[Ljava/lang/Long;)V", "getWriter", "()Lnet/orandja/obor/io/CborWriter;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "getTracker", "()[Ljava/lang/Long;", "setTracker", "([Ljava/lang/Long;)V", "[Ljava/lang/Long;", "encodeTag", "", "setClassTracker", "annotations", "", "", "setFieldTracker", "startCollection", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "collectionSize", "", "startStructure", "encodeElement", "", "index", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "beginCollection", "beginStructure", "encodeBoolean", "value", "encodeByte", "", "encodeUByte", "Lkotlin/UByte;", "encodeUByte-7apg3OU", "(B)V", "encodeUByteNeg", "encodeUByteNeg-7apg3OU", "encodeShort", "", "encodeUShort", "Lkotlin/UShort;", "encodeUShort-xj2QHRw", "(S)V", "encodeUShortNeg", "encodeUShortNeg-xj2QHRw", "encodeInt", "encodeUInt", "Lkotlin/UInt;", "encodeUInt-WZ4Q5Ns", "(I)V", "encodeUIntNeg", "encodeUIntNeg-WZ4Q5Ns", "encodeLong", "encodeULong", "Lkotlin/ULong;", "encodeULong-VKZWuLQ", "(J)V", "encodeULongNeg", "encodeULongNeg-VKZWuLQ", "encodeFloat", "", "encodeDouble", "", "encodeNull", "encodeStructureName", "", "encodeChar", "", "encodeString", "encodeStringInfinite", "encodeRawString", "", "offset", "count", "encodeBytesElement", "serialDescriptor", "encodeBytes", "encodeEnum", "enumDescriptor", "obor"})
@SourceDebugExtension(value={"SMAP\nCborEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborEncoder.kt\nnet/orandja/obor/codec/encoder/CborEncoder\n+ 2 Tracker.kt\nnet/orandja/obor/codec/TrackerKt\n+ 3 Utils.kt\nnet/orandja/obor/codec/UtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 Encoding.kt\nkotlinx/serialization/encoding/EncodingKt\n*L\n1#1,306:1\n48#2:307\n98#2:308\n5#2:309\n102#2:310\n99#2:311\n7#2,2:312\n82#2:314\n5#2:315\n86#2:316\n83#2:317\n7#2,2:318\n66#2:320\n5#2:321\n70#2:322\n67#2:323\n7#2,2:324\n59#2:329\n7#2,2:330\n63#2:335\n7#2,2:336\n67#2:341\n7#2,2:342\n71#2:344\n75#2:348\n7#2,2:349\n79#2:354\n7#2,2:355\n83#2:360\n7#2,2:361\n87#2:363\n59#2:364\n7#2,2:365\n49#2:370\n90#2:371\n5#2:372\n74#2:373\n5#2:374\n58#2:375\n5#2:376\n78#2:377\n5#2:378\n78#2:379\n5#2:380\n90#2:381\n5#2:382\n74#2:383\n5#2:384\n105#3:326\n105#3:332\n105#3:338\n105#3:345\n105#3:351\n105#3:357\n105#3:367\n111#3:385\n295#4,2:327\n295#4,2:333\n295#4,2:339\n295#4,2:346\n295#4,2:352\n295#4,2:358\n295#4,2:368\n11102#5:386\n11437#5,3:387\n475#6,4:390\n*S KotlinDebug\n*F\n+ 1 CborEncoder.kt\nnet/orandja/obor/codec/encoder/CborEncoder\n*L\n29#1:307\n33#1:308\n33#1:309\n34#1:310\n35#1:311\n35#1:312,2\n37#1:314\n37#1:315\n38#1:316\n39#1:317\n39#1:318,2\n41#1:320\n41#1:321\n42#1:322\n43#1:323\n43#1:324,2\n48#1:329\n48#1:330,2\n49#1:335\n49#1:336,2\n52#1:341\n52#1:342,2\n53#1:344\n58#1:348\n58#1:349,2\n59#1:354\n59#1:355,2\n62#1:360\n62#1:361,2\n63#1:363\n75#1:364\n75#1:365,2\n92#1:370\n98#1:371\n98#1:372\n98#1:373\n98#1:374\n98#1:375\n98#1:376\n113#1:377\n113#1:378\n145#1:379\n145#1:380\n270#1:381\n270#1:382\n270#1:383\n270#1:384\n48#1:326\n49#1:332\n50#1:338\n58#1:345\n59#1:351\n60#1:357\n82#1:367\n275#1:385\n48#1:327,2\n49#1:333,2\n50#1:339,2\n58#1:346,2\n59#1:352,2\n60#1:358,2\n82#1:368,2\n275#1:386\n275#1:387,3\n276#1:390,4\n*E\n"})
public class CborEncoder
extends AbstractEncoder {
    @NotNull
    private final CborWriter writer;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private Long[] tracker;

    public CborEncoder(@NotNull CborWriter writer, @NotNull SerializersModule serializersModule, @NotNull Long[] tracker) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        this.writer = writer;
        this.serializersModule = serializersModule;
        this.tracker = tracker;
    }

    public /* synthetic */ CborEncoder(CborWriter cborWriter, SerializersModule serializersModule, Long[] longArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean $i$f$newEncoderTracker = false;
            Long[] longArray2 = new Long[]{0L, 0L, 0L, 0L, 0L, 0L};
            longArray = longArray2;
        }
        this(cborWriter, serializersModule, longArray);
    }

    @NotNull
    protected final CborWriter getWriter() {
        return this.writer;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    protected Long[] getTracker() {
        return this.tracker;
    }

    protected void setTracker(@NotNull Long[] longArray) {
        Intrinsics.checkNotNullParameter((Object)longArray, (String)"<set-?>");
        this.tracker = longArray;
    }

    /*
     * WARNING - void declaration
     */
    protected final void encodeTag() {
        void index$iv$iv7;
        boolean $i$f$setFlag;
        long flag$iv$iv;
        boolean value$iv;
        void index$iv$iv22;
        void $this$getFlag$iv$iv;
        Long[] $this$encParentHasTag$iv = this.getTracker();
        boolean $i$f$getEncParentHasTag = false;
        Long[] longArray = $this$encParentHasTag$iv;
        int n = 4;
        long flag$iv$iv22 = 4L;
        boolean $i$f$getFlag = false;
        boolean bl = ($this$getFlag$iv$iv[index$iv$iv22].longValue() & flag$iv$iv22) != 0L;
        if (bl) {
            void index$iv$iv3;
            void $this$setFlag$iv$iv;
            Long[] $this$encParentTag$iv = this.getTracker();
            boolean $i$f$getEncParentTag = false;
            this.writer.writeMajor64-apjzmAw((byte)-64, ULong.constructor-impl((long)$this$encParentTag$iv[5]));
            $this$encParentTag$iv = this.getTracker();
            value$iv = false;
            boolean $i$f$setEncParentHasTag = false;
            Long[] index$iv$iv22 = $this$encParentHasTag$iv;
            int flag$iv$iv22 = 4;
            flag$iv$iv = 4L;
            $i$f$setFlag = false;
            $this$setFlag$iv$iv[index$iv$iv3] = $this$setFlag$iv$iv[index$iv$iv3].longValue() & (flag$iv$iv ^ 0xFFFFFFFFFFFFFFFFL);
        }
        Long[] $this$encFieldHasTag$iv = this.getTracker();
        boolean $i$f$getEncFieldHasTag = false;
        Long[] $i$f$setEncParentHasTag = $this$encFieldHasTag$iv;
        int $this$setFlag$iv$iv = 2;
        flag$iv$iv22 = 4L;
        $i$f$getFlag = false;
        boolean bl2 = ($this$getFlag$iv$iv[index$iv$iv22].longValue() & flag$iv$iv22) != 0L;
        if (bl2) {
            void index$iv$iv4;
            Long[] $this$encFieldTag$iv = this.getTracker();
            boolean $i$f$getEncFieldTag = false;
            this.writer.writeMajor64-apjzmAw((byte)-64, ULong.constructor-impl((long)$this$encFieldTag$iv[3]));
            $this$encFieldTag$iv = this.getTracker();
            value$iv = false;
            boolean $i$f$setEncFieldHasTag = false;
            Long[] index$iv$iv5 = $this$encFieldHasTag$iv;
            int flag$iv$iv3 = 2;
            flag$iv$iv = 4L;
            $i$f$setFlag = false;
            $this$setFlag$iv$iv2[index$iv$iv4] = $this$setFlag$iv$iv2[index$iv$iv4].longValue() & (flag$iv$iv ^ 0xFFFFFFFFFFFFFFFFL);
        }
        Long[] $this$encClassHasTag$iv = this.getTracker();
        boolean $i$f$getEncClassHasTag = false;
        Long[] $i$f$setEncFieldHasTag = $this$encClassHasTag$iv;
        boolean $this$setFlag$iv$iv2 = false;
        long flag$iv$iv42 = 4L;
        $i$f$getFlag = false;
        boolean bl3 = ($this$getFlag$iv$iv[index$iv$iv7].longValue() & flag$iv$iv42) != 0L;
        if (bl3) {
            void index$iv$iv6;
            Long[] $this$encClassTag$iv = this.getTracker();
            boolean $i$f$getEncClassTag = false;
            this.writer.writeMajor64-apjzmAw((byte)-64, ULong.constructor-impl((long)$this$encClassTag$iv[1]));
            $this$encClassTag$iv = this.getTracker();
            value$iv = false;
            boolean $i$f$setEncClassHasTag = false;
            Long[] index$iv$iv7 = $this$encClassHasTag$iv;
            boolean flag$iv$iv42 = false;
            flag$iv$iv = 4L;
            $i$f$setFlag = false;
            $this$setFlag$iv$iv[index$iv$iv6] = $this$setFlag$iv$iv[index$iv$iv6].longValue() & (flag$iv$iv ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void setClassTracker(@NotNull List<? extends Annotation> annotations) {
        CborTag cTag;
        Object v5;
        Object v4;
        Long[] $this$findTypeOf$iv;
        block11: {
            Object v3;
            Object v2;
            boolean $i$f$setFlag;
            boolean value$iv;
            Long[] $this$findTypeOf$iv2;
            block10: {
                Object v1;
                Object v0;
                boolean bl;
                Object it$iv;
                Object element$iv$iv;
                boolean $i$f$firstOrNull2;
                Iterable $this$firstOrNull$iv$iv;
                boolean $i$f$findTypeOf;
                block9: {
                    Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
                    $this$findTypeOf$iv2 = annotations;
                    $i$f$findTypeOf = false;
                    $this$firstOrNull$iv$iv = (Iterable)$this$findTypeOf$iv2;
                    $i$f$firstOrNull2 = false;
                    Iterator iterator = $this$firstOrNull$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        bl = false;
                        if (!(it$iv instanceof CborInfinite)) continue;
                        v0 = element$iv$iv;
                        break block9;
                    }
                    v0 = v1 = null;
                }
                if (!(v0 instanceof CborInfinite)) {
                    v1 = null;
                }
                if ((CborInfinite)v1 != null) {
                    void index$iv$iv;
                    void $this$setFlag$iv$iv;
                    void $this$encClassIsInfinite$iv;
                    $this$findTypeOf$iv2 = this.getTracker();
                    value$iv = true;
                    boolean $i$f$setEncClassIsInfinite = false;
                    void $i$f$firstOrNull2 = $this$encClassIsInfinite$iv;
                    boolean bl2 = false;
                    long flag$iv$iv = 1L;
                    $i$f$setFlag = false;
                    $this$setFlag$iv$iv[index$iv$iv] = $this$setFlag$iv$iv[index$iv$iv].longValue() | flag$iv$iv;
                }
                $this$findTypeOf$iv2 = annotations;
                $i$f$findTypeOf = false;
                $this$firstOrNull$iv$iv = (Iterable)$this$findTypeOf$iv2;
                $i$f$firstOrNull2 = false;
                Iterator index$iv$iv = $this$firstOrNull$iv$iv.iterator();
                while (index$iv$iv.hasNext()) {
                    it$iv = element$iv$iv = index$iv$iv.next();
                    bl = false;
                    if (!(it$iv instanceof CborRawBytes)) continue;
                    v2 = element$iv$iv;
                    break block10;
                }
                v2 = v3 = null;
            }
            if (!(v2 instanceof CborRawBytes)) {
                v3 = null;
            }
            if ((CborRawBytes)v3 != null) {
                void $this$setFlag$iv$iv;
                void $this$encClassIsRawBytes$iv;
                $this$findTypeOf$iv2 = this.getTracker();
                value$iv = true;
                boolean $i$f$setEncClassIsRawBytes = false;
                void $i$f$firstOrNull = $this$encClassIsRawBytes$iv;
                int index$iv$iv = 0;
                long flag$iv$iv = 2L;
                $i$f$setFlag = false;
                $this$setFlag$iv$iv[index$iv$iv] = $this$setFlag$iv$iv[index$iv$iv].longValue() | flag$iv$iv;
            }
            $this$findTypeOf$iv = annotations;
            boolean $i$f$findTypeOf = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$findTypeOf$iv;
            boolean $i$f$firstOrNull = false;
            Iterator flag$iv$iv = $this$firstOrNull$iv$iv.iterator();
            while (flag$iv$iv.hasNext()) {
                Object element$iv$iv;
                Object it$iv = element$iv$iv = flag$iv$iv.next();
                boolean bl = false;
                if (!(it$iv instanceof CborTag)) continue;
                v4 = element$iv$iv;
                break block11;
            }
            v4 = v5 = null;
        }
        if (!(v4 instanceof CborTag)) {
            v5 = null;
        }
        if ((cTag = (CborTag)v5) != null) {
            void index$iv$iv;
            void $this$setFlag$iv$iv;
            Long[] $this$encClassHasTag$iv;
            $this$findTypeOf$iv = this.getTracker();
            boolean value$iv = true;
            boolean $i$f$setEncClassHasTag = false;
            void $i$f$firstOrNull = $this$encClassHasTag$iv;
            boolean flag$iv$iv = false;
            long flag$iv$iv2 = 4L;
            boolean $i$f$setFlag = false;
            $this$setFlag$iv$iv[index$iv$iv] = $this$setFlag$iv$iv[index$iv$iv].longValue() | flag$iv$iv2;
            $this$encClassHasTag$iv = this.getTracker();
            long value$iv2 = cTag.tag();
            boolean $i$f$setEncClassTag = false;
            $this$encClassTag$iv[1] = value$iv2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void setFieldTracker(@NotNull List<? extends Annotation> annotations) {
        CborTag cTag;
        Object v5;
        Object v4;
        Long[] $this$findTypeOf$iv;
        block11: {
            Object v3;
            Object v2;
            boolean $i$f$setFlag;
            boolean value$iv;
            Long[] $this$findTypeOf$iv2;
            block10: {
                Object v1;
                Object v0;
                boolean bl;
                Object it$iv;
                Object element$iv$iv;
                boolean $i$f$firstOrNull2;
                Iterable $this$firstOrNull$iv$iv;
                boolean $i$f$findTypeOf;
                block9: {
                    Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
                    $this$findTypeOf$iv2 = annotations;
                    $i$f$findTypeOf = false;
                    $this$firstOrNull$iv$iv = (Iterable)$this$findTypeOf$iv2;
                    $i$f$firstOrNull2 = false;
                    Iterator iterator = $this$firstOrNull$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        bl = false;
                        if (!(it$iv instanceof CborInfinite)) continue;
                        v0 = element$iv$iv;
                        break block9;
                    }
                    v0 = v1 = null;
                }
                if (!(v0 instanceof CborInfinite)) {
                    v1 = null;
                }
                if ((CborInfinite)v1 != null) {
                    void index$iv$iv;
                    void $this$setFlag$iv$iv;
                    void $this$encFieldIsInfinite$iv;
                    $this$findTypeOf$iv2 = this.getTracker();
                    value$iv = true;
                    boolean $i$f$setEncFieldIsInfinite = false;
                    void $i$f$firstOrNull2 = $this$encFieldIsInfinite$iv;
                    int n = 2;
                    long flag$iv$iv = 1L;
                    $i$f$setFlag = false;
                    $this$setFlag$iv$iv[index$iv$iv] = $this$setFlag$iv$iv[index$iv$iv].longValue() | flag$iv$iv;
                }
                $this$findTypeOf$iv2 = annotations;
                $i$f$findTypeOf = false;
                $this$firstOrNull$iv$iv = (Iterable)$this$findTypeOf$iv2;
                $i$f$firstOrNull2 = false;
                Iterator index$iv$iv = $this$firstOrNull$iv$iv.iterator();
                while (index$iv$iv.hasNext()) {
                    it$iv = element$iv$iv = index$iv$iv.next();
                    bl = false;
                    if (!(it$iv instanceof CborRawBytes)) continue;
                    v2 = element$iv$iv;
                    break block10;
                }
                v2 = v3 = null;
            }
            if (!(v2 instanceof CborRawBytes)) {
                v3 = null;
            }
            if ((CborRawBytes)v3 != null) {
                void $this$setFlag$iv$iv;
                void $this$encFieldIsRawBytes$iv;
                $this$findTypeOf$iv2 = this.getTracker();
                value$iv = true;
                boolean $i$f$setEncFieldIsRawBytes = false;
                void $i$f$firstOrNull = $this$encFieldIsRawBytes$iv;
                int index$iv$iv = 2;
                long flag$iv$iv = 2L;
                $i$f$setFlag = false;
                $this$setFlag$iv$iv[index$iv$iv] = $this$setFlag$iv$iv[index$iv$iv].longValue() | flag$iv$iv;
            }
            $this$findTypeOf$iv = annotations;
            boolean $i$f$findTypeOf = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$findTypeOf$iv;
            boolean $i$f$firstOrNull = false;
            Iterator flag$iv$iv = $this$firstOrNull$iv$iv.iterator();
            while (flag$iv$iv.hasNext()) {
                Object element$iv$iv;
                Object it$iv = element$iv$iv = flag$iv$iv.next();
                boolean bl = false;
                if (!(it$iv instanceof CborTag)) continue;
                v4 = element$iv$iv;
                break block11;
            }
            v4 = v5 = null;
        }
        if (!(v4 instanceof CborTag)) {
            v5 = null;
        }
        if ((cTag = (CborTag)v5) != null) {
            void index$iv$iv;
            void $this$setFlag$iv$iv;
            Long[] $this$encFieldHasTag$iv;
            $this$findTypeOf$iv = this.getTracker();
            boolean value$iv = true;
            boolean $i$f$setEncFieldHasTag = false;
            void $i$f$firstOrNull = $this$encFieldHasTag$iv;
            int flag$iv$iv = 2;
            long flag$iv$iv2 = 4L;
            boolean $i$f$setFlag = false;
            $this$setFlag$iv$iv[index$iv$iv] = $this$setFlag$iv$iv[index$iv$iv].longValue() | flag$iv$iv2;
            $this$encFieldHasTag$iv = this.getTracker();
            long value$iv2 = cTag.tag();
            boolean $i$f$setEncFieldTag = false;
            $this$encFieldTag$iv[3] = value$iv2;
        }
    }

    @NotNull
    public CompositeEncoder startCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.setClassTracker(descriptor.getAnnotations());
        this.encodeTag();
        return (CompositeEncoder)this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompositeEncoder startStructure(@NotNull SerialDescriptor descriptor) {
        void index$iv$iv;
        void $this$setFlag$iv$iv;
        void $this$encClassIsInfinite$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.setClassTracker(descriptor.getAnnotations());
        Long[] longArray = this.getTracker();
        boolean value$iv = true;
        boolean $i$f$setEncClassIsInfinite = false;
        void var5_5 = $this$encClassIsInfinite$iv;
        boolean bl = false;
        long flag$iv$iv = 1L;
        boolean $i$f$setFlag = false;
        $this$setFlag$iv$iv[index$iv$iv] = $this$setFlag$iv$iv[index$iv$iv].longValue() | flag$iv$iv;
        this.encodeTag();
        return (CompositeEncoder)this;
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (index < descriptor.getElementsCount()) {
            Object v1;
            Object v0;
            block4: {
                List $this$findTypeOf$iv = descriptor.getElementAnnotations(index);
                boolean $i$f$findTypeOf = false;
                Iterable $this$firstOrNull$iv$iv = $this$findTypeOf$iv;
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv;
                    Object it$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    if (!(it$iv instanceof CborSkip)) continue;
                    v0 = element$iv$iv;
                    break block4;
                }
                v0 = v1 = null;
            }
            if (!(v0 instanceof CborSkip)) {
                v1 = null;
            }
            if ((CborSkip)v1 != null) {
                return false;
            }
        }
        this.encodeTag();
        return super.encodeElement(descriptor, index);
    }

    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.setClassTracker(descriptor.getAnnotations());
        this.encodeTag();
        this.setFieldTracker(descriptor.getElementAnnotations(0));
        Long[] parent$iv = this.getTracker();
        boolean $i$f$newEncoderTracker = false;
        Long[] longArray = new Long[]{0L, 0L, 0L, 0L, parent$iv[2], parent$iv[3]};
        this.setTracker(longArray);
        return super.encodeInline(descriptor);
    }

    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        SerialDescriptor $this$encClassIsInfinite$iv;
        int index$iv$iv;
        Long[] $this$getFlag$iv$iv;
        boolean $i$f$getFlag;
        long flag$iv$iv;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                Long[] $this$encParentIsInfinite$iv = this.getTracker();
                boolean $i$f$getEncParentIsInfinite = false;
                Long[] longArray = $this$encParentIsInfinite$iv;
                int n = 4;
                flag$iv$iv = 1L;
                $i$f$getFlag = false;
                if (($this$getFlag$iv$iv[index$iv$iv].longValue() & flag$iv$iv) != 0L) break block7;
                Long[] $this$encFieldIsInfinite$iv = this.getTracker();
                boolean $i$f$getEncFieldIsInfinite = false;
                $this$getFlag$iv$iv = $this$encFieldIsInfinite$iv;
                index$iv$iv = 2;
                flag$iv$iv = 1L;
                $i$f$getFlag = false;
                if (($this$getFlag$iv$iv[index$iv$iv] & flag$iv$iv) != 0L) break block7;
                $this$encClassIsInfinite$iv = this.getTracker();
                boolean $i$f$getEncClassIsInfinite = false;
                $this$getFlag$iv$iv = $this$encClassIsInfinite$iv;
                index$iv$iv = 0;
                flag$iv$iv = 1L;
                $i$f$getFlag = false;
                boolean bl = ($this$getFlag$iv$iv[index$iv$iv] & flag$iv$iv) != 0L;
                if (!bl) break block8;
            }
            return this.beginStructure(descriptor);
        }
        this.encodeTag();
        $this$encClassIsInfinite$iv = descriptor;
        if ($this$encClassIsInfinite$iv instanceof ByteArrayDescriptor || $this$encClassIsInfinite$iv instanceof ListBytesDescriptor) {
            return (CompositeEncoder)new CborBytesEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startCollection(descriptor, collectionSize);
        }
        if ($this$encClassIsInfinite$iv instanceof ListStringsDescriptor) {
            return (CompositeEncoder)new CborTextEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startCollection(descriptor, collectionSize);
        }
        Long[] $this$encFieldIsRawBytes$iv = this.getTracker();
        boolean $i$f$getEncFieldIsRawBytes = false;
        $this$getFlag$iv$iv = $this$encFieldIsRawBytes$iv;
        index$iv$iv = 2;
        flag$iv$iv = 2L;
        $i$f$getFlag = false;
        boolean bl = ($this$getFlag$iv$iv[index$iv$iv] & flag$iv$iv) != 0L;
        if (bl) {
            if (!(descriptor.getKind() instanceof StructureKind.LIST) || !(descriptor.getElementDescriptor(0).getKind() instanceof PrimitiveKind.BYTE)) {
                throw new IllegalStateException((Reflection.getOrCreateKotlinClass(CborRawBytes.class).getSimpleName() + " annotation applied on an invalid field. It should be a List<Byte> or equivalent").toString());
            }
            return (CompositeEncoder)new CborByteStringEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startCollection(descriptor, collectionSize);
        }
        SerialKind serialKind = descriptor.getKind();
        return serialKind instanceof StructureKind.MAP ? (CompositeEncoder)new CborMapEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startCollection(descriptor, collectionSize) : (serialKind instanceof StructureKind.LIST ? (CompositeEncoder)new CborListEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startCollection(descriptor, collectionSize) : this.beginStructure(descriptor));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeEncoder compositeEncoder;
        void index$iv$iv;
        void $this$getFlag$iv$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encodeTag();
        SerialDescriptor serialDescriptor = descriptor;
        if (serialDescriptor instanceof ByteArrayDescriptor || serialDescriptor instanceof ListBytesDescriptor) {
            return (CompositeEncoder)new CborBytesEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startStructure(descriptor);
        }
        if (serialDescriptor instanceof ListStringsDescriptor) {
            return (CompositeEncoder)new CborTextEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startStructure(descriptor);
        }
        Long[] $this$encFieldIsRawBytes$iv = this.getTracker();
        boolean $i$f$getEncFieldIsRawBytes = false;
        Long[] longArray = $this$encFieldIsRawBytes$iv;
        int n = 2;
        long flag$iv$iv = 2L;
        boolean $i$f$getFlag = false;
        boolean bl = ($this$getFlag$iv$iv[index$iv$iv].longValue() & flag$iv$iv) != 0L;
        if (bl) {
            if (!(descriptor.getKind() instanceof StructureKind.LIST) || !(descriptor.getElementDescriptor(0).getKind() instanceof PrimitiveKind.BYTE)) {
                throw new IllegalStateException((Reflection.getOrCreateKotlinClass(CborRawBytes.class).getSimpleName() + " annotation applied on an invalid field. It should be a List<Byte> or equivalent").toString());
            }
            return (CompositeEncoder)new CborByteStringEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startStructure(descriptor);
        }
        serialDescriptor = descriptor.getKind();
        if (serialDescriptor instanceof StructureKind.LIST) {
            compositeEncoder = (CompositeEncoder)new CborListEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startStructure(descriptor);
        } else if (serialDescriptor instanceof StructureKind.MAP) {
            compositeEncoder = (CompositeEncoder)new CborMapEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startStructure(descriptor);
        } else if (serialDescriptor instanceof StructureKind.CLASS || serialDescriptor instanceof StructureKind.OBJECT) {
            compositeEncoder = (CompositeEncoder)new CborStructureEncoder(this.writer, this.getSerializersModule(), this.getTracker()).startCollection(descriptor, descriptor.getElementsCount());
        } else {
            throw new IllegalStateException("Try to encode a " + descriptor.getKind() + " but SerialDescriptor isn't a StructureKind");
        }
        return compositeEncoder;
    }

    public void encodeBoolean(boolean value) {
        this.encodeTag();
        if (value) {
            this.writer.write-7apg3OU(UtilsKt.getHEADER_TRUE());
        } else {
            this.writer.write-7apg3OU(UtilsKt.getHEADER_FALSE());
        }
    }

    public void encodeByte(byte value) {
        this.encodeTag();
        byte v = UByte.constructor-impl((byte)value);
        if (Intrinsics.compare((int)(v & 0xFF), (int)(UtilsKt.getBYTE_NEG() & 0xFF)) > 0) {
            this.writer.writeMajor8-YVftJsw((byte)32, UByte.constructor-impl((byte)((byte)(v ^ UtilsKt.getBYTE_FF()))));
        } else {
            this.writer.writeMajor8-YVftJsw((byte)0, v);
        }
    }

    public void encodeUByte-7apg3OU(byte value) {
        this.encodeTag();
        this.writer.writeMajor8-YVftJsw((byte)0, value);
    }

    public void encodeUByteNeg-7apg3OU(byte value) {
        this.encodeTag();
        this.writer.writeMajor8-YVftJsw((byte)32, value);
    }

    public void encodeShort(short value) {
        this.encodeTag();
        short v = UShort.constructor-impl((short)value);
        if (Intrinsics.compare((int)(v & 0xFFFF), (int)(UtilsKt.getSHORT_NEG() & 0xFFFF)) > 0) {
            this.writer.writeMajor16-Dt2v30s((byte)32, UShort.constructor-impl((short)((short)(v ^ UtilsKt.getSHORT_FF()))));
        } else {
            this.writer.writeMajor16-Dt2v30s((byte)0, v);
        }
    }

    public void encodeUShort-xj2QHRw(short value) {
        this.encodeTag();
        this.writer.writeMajor16-Dt2v30s((byte)0, value);
    }

    public void encodeUShortNeg-xj2QHRw(short value) {
        this.encodeTag();
        this.writer.writeMajor16-Dt2v30s((byte)32, value);
    }

    public void encodeInt(int value) {
        this.encodeTag();
        int v = UInt.constructor-impl((int)value);
        if (Integer.compareUnsigned(UInt.constructor-impl((int)(v & UtilsKt.getINT_NEG())), 0) > 0) {
            this.writer.writeMajor32-g_SBl1M((byte)32, UInt.constructor-impl((int)(v ^ UtilsKt.getINT_FF())));
        } else {
            this.writer.writeMajor32-g_SBl1M((byte)0, v);
        }
    }

    public void encodeUInt-WZ4Q5Ns(int value) {
        this.encodeTag();
        this.writer.writeMajor32-g_SBl1M((byte)0, value);
    }

    public void encodeUIntNeg-WZ4Q5Ns(int value) {
        this.encodeTag();
        this.writer.writeMajor32-g_SBl1M((byte)32, value);
    }

    public void encodeLong(long value) {
        this.encodeTag();
        long v = ULong.constructor-impl((long)value);
        if (Long.compareUnsigned(ULong.constructor-impl((long)(v & UtilsKt.getLONG_NEG())), ULong.constructor-impl((long)(0L & 0xFFFFFFFFL))) > 0) {
            this.writer.writeMajor64-apjzmAw((byte)32, ULong.constructor-impl((long)(v ^ UtilsKt.getLONG_FF())));
        } else {
            this.writer.writeMajor64-apjzmAw((byte)0, v);
        }
    }

    public void encodeULong-VKZWuLQ(long value) {
        this.encodeTag();
        this.writer.writeMajor64-apjzmAw((byte)0, value);
    }

    public void encodeULongNeg-VKZWuLQ(long value) {
        this.encodeTag();
        this.writer.writeMajor64-apjzmAw((byte)32, value);
    }

    public void encodeFloat(float value) {
        this.encodeTag();
        int float16Bits = Float16Kt.float32ToFloat16bits(value);
        if (Float.floatToRawIntBits(Float16Kt.float16BitsToFloat32(float16Bits)) == Float.floatToRawIntBits(value)) {
            this.writer.writeHeader16-Dt2v30s(UtilsKt.getHEADER_FLOAT_16(), UShort.constructor-impl((short)((short)float16Bits)));
        } else {
            this.writer.writeHeader32-g_SBl1M(UtilsKt.getHEADER_FLOAT_32(), UInt.constructor-impl((int)Float.floatToRawIntBits(value)));
        }
    }

    public void encodeDouble(double value) {
        float floatValue = Float32Kt.float64toFloat32(value);
        if (Double.doubleToRawLongBits(floatValue) == Double.doubleToRawLongBits(value)) {
            this.encodeFloat(floatValue);
        } else {
            this.encodeTag();
            this.writer.writeHeader64-apjzmAw(UtilsKt.getHEADER_FLOAT_64(), ULong.constructor-impl((long)Double.doubleToRawLongBits(value)));
        }
    }

    public void encodeNull() {
        this.writer.write-7apg3OU(UtilsKt.getHEADER_NULL());
    }

    protected final void encodeStructureName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CborEncoder.encodeRawString$default(this, StringsKt.encodeToByteArray((String)value), 0, 0, 6, null);
    }

    public void encodeChar(char value) {
        this.encodeString(String.valueOf(value));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void encodeString(@NotNull String value) {
        int index$iv$iv;
        Long[] $this$getFlag$iv$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeTag();
        Long[] $this$encParentIsInfinite$iv = this.getTracker();
        boolean $i$f$getEncParentIsInfinite = false;
        Long[] longArray = $this$encParentIsInfinite$iv;
        int n = 4;
        long flag$iv$iv = 1L;
        boolean $i$f$getFlag = false;
        if (!(($this$getFlag$iv$iv[index$iv$iv].longValue() & flag$iv$iv) != 0L)) {
            Long[] $this$encFieldIsInfinite$iv = this.getTracker();
            boolean $i$f$getEncFieldIsInfinite = false;
            $this$getFlag$iv$iv = $this$encFieldIsInfinite$iv;
            index$iv$iv = 2;
            flag$iv$iv = 1L;
            $i$f$getFlag = false;
            if (!(($this$getFlag$iv$iv[index$iv$iv] & flag$iv$iv) != 0L)) {
                CborEncoder.encodeRawString$default(this, StringsKt.encodeToByteArray((String)value), 0, 0, 6, null);
                return;
            }
        }
        this.encodeStringInfinite(value);
    }

    /*
     * WARNING - void declaration
     */
    private final void encodeStringInfinite(String value) {
        CompositeEncoder composite$iv;
        void $this$mapTo$iv$iv$iv;
        void klass$iv;
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CborEncoder.class)};
        boolean $i$f$name = false;
        void $this$map$iv$iv = klass$iv;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(((void)$this$map$iv$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it$iv;
            void item$iv$iv$iv;
            void var13_15 = item$iv$iv$iv = $this$mapTo$iv$iv$iv[i];
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            collection.add(it$iv.getSimpleName());
        }
        String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        ListStringsDescriptor descriptor = new ListStringsDescriptor(string);
        Encoder $this$encodeStructure$iv = (Encoder)this;
        boolean $i$f$encodeStructure = false;
        CompositeEncoder $this$encodeStringInfinite_u24lambda_u240 = composite$iv = $this$encodeStructure$iv.beginStructure((SerialDescriptor)descriptor);
        boolean bl = false;
        for (String item : StringsKt.chunkedSequence((CharSequence)value, (int)255)) {
            CborEncoder.encodeRawString$default(this, StringsKt.encodeToByteArray((String)item), 0, 0, 6, null);
        }
        composite$iv.endStructure((SerialDescriptor)descriptor);
    }

    public void encodeRawString(@NotNull byte[] value, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writer.writeMajor32-g_SBl1M((byte)96, UInt.constructor-impl((int)count));
        if (count != 0) {
            this.writer.write(value, offset, count);
        }
    }

    public static /* synthetic */ void encodeRawString$default(CborEncoder cborEncoder, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeRawString");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        cborEncoder.encodeRawString(byArray, n, n2);
    }

    public void encodeBytesElement(@NotNull SerialDescriptor serialDescriptor, int index, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"serialDescriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CborEncoder.encodeBytes$default(this, value, 0, 0, 6, null);
    }

    public void encodeBytes(@NotNull byte[] value, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeTag();
        this.writer.writeMajor32-g_SBl1M((byte)64, UInt.constructor-impl((int)count));
        if (count != 0) {
            this.writer.write(value, offset, count);
        }
    }

    public static /* synthetic */ void encodeBytes$default(CborEncoder cborEncoder, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeBytes");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        cborEncoder.encodeBytes(byArray, n, n2);
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.encodeTag();
        this.encodeString(enumDescriptor.getElementName(index));
    }
}

