/*
 * Decompiled with CFR 0.152.
 */
package net.orandja.kt.stylized.dsl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import net.orandja.kt.stylized.Style;
import net.orandja.kt.stylized.StyleReadOnlyProperty;
import net.orandja.kt.stylized.UtilsKt;
import net.orandja.kt.stylized.dsl.StyleBuilder;
import net.orandja.kt.stylized.dsl.StyleGroup;
import net.orandja.kt.stylized.exceptions.InvalidReferenceNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\r\u0010\u0011\u001a\u00020\f*\u00020\u0010H\u0086\u0002J \u0010\u0012\u001a\u00020\f\"\u0004\b\u0000\u0010\u0013*\u00020\u00102\u0006\u0010\u0014\u001a\u0002H\u0013H\u0086\u0004\u00a2\u0006\u0002\u0010\u0015J \u0010\u0012\u001a\u00020\f\"\u0004\b\u0000\u0010\u0013*\u00020\b2\u0006\u0010\u0014\u001a\u0002H\u0013H\u0086\u0004\u00a2\u0006\u0002\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\f\u0010\u001a\u001a\u00020\b*\u00020\u0010H\u0002J\u001b\u0010\u001b\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u0002H\u0013H\u0002\u00a2\u0006\u0002\u0010\u001cR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lnet/orandja/kt/stylized/dsl/StyleGroupBuilder;", "Lnet/orandja/kt/stylized/dsl/StyleBuilder;", "parent", "Lnet/orandja/kt/stylized/Style;", "<init>", "(Lnet/orandja/kt/stylized/Style;)V", "values", "", "", "getValues", "()Ljava/util/Map;", "add", "", "name", "style", "reference", "Lnet/orandja/kt/stylized/Style$Reference;", "unaryPlus", "set", "T", "value", "(Lnet/orandja/kt/stylized/Style$Reference;Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/Object;)V", "build", "Lnet/orandja/kt/stylized/Style$Group;", "build$stylized", "assertName", "useRefNameInsteadOfRef", "(Ljava/lang/Object;)Lnet/orandja/kt/stylized/Style;", "stylized"})
public class StyleGroupBuilder
extends StyleBuilder {
    @Nullable
    private final Style parent;
    @NotNull
    private final Map<String, Style> values;

    public StyleGroupBuilder(@Nullable Style parent) {
        this.parent = parent;
        this.values = new LinkedHashMap();
    }

    @NotNull
    protected final Map<String, Style> getValues() {
        return this.values;
    }

    public final void add(@NotNull String name, @NotNull Style style) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.values.put(name, style);
    }

    public final void add(@NotNull Style.Reference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        this.add(this.assertName(reference), reference);
    }

    public final void unaryPlus(@NotNull Style.Reference $this$unaryPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
        this.add(this.assertName($this$unaryPlus), $this$unaryPlus);
    }

    public final <T> void set(@NotNull Style.Reference $this$set, T value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        if (value instanceof StyleReadOnlyProperty) {
            throw new IllegalStateException("'style' and 'attr' function should not be used in style creation. Please use 'group' instead".toString());
        }
        this.add(this.assertName($this$set), this.useRefNameInsteadOfRef(value));
    }

    public final <T> void set(@NotNull String $this$set, T value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        if (value instanceof StyleReadOnlyProperty) {
            throw new IllegalStateException("'style' and 'attr' function should not be used in style creation. Please use 'group' instead".toString());
        }
        this.add($this$set, this.useRefNameInsteadOfRef(value));
    }

    @NotNull
    public final Style.Group build$stylized() {
        return switch (this.values.size()) {
            case 0 -> new StyleGroup.Empty(this.parent);
            case 1 -> {
                Map.Entry var1_1 = (Map.Entry)CollectionsKt.first((Iterable)this.values.entrySet());
                String key = (String)var1_1.getKey();
                Style value = (Style)var1_1.getValue();
                yield new StyleGroup.Single(key, value, this.parent);
            }
            default -> new StyleGroup.Multi(this.values, this.parent);
        };
    }

    private final String assertName(Style.Reference $this$assertName) {
        List name = SequencesKt.toList(UtilsKt.sanitize(UtilsKt.extractStrings($this$assertName.name())));
        if (name.isEmpty()) {
            throw new InvalidReferenceNameException("Reference does not have a name", $this$assertName);
        }
        if (name.size() >= 2) {
            throw new InvalidReferenceNameException("To set a value, reference/attribute should be single ('foo' not 'foo.bar')", $this$assertName);
        }
        return (String)name.get(0);
    }

    private final <T> Style useRefNameInsteadOfRef(T value) {
        Style style;
        if (value instanceof Style.Reference) {
            Object[] objectArray = new Object[]{value};
            style = this.reference(objectArray);
        } else {
            style = this.stylized(value);
        }
        return style;
    }
}

