/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.spring.upstream.rest;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.optionfactory.spring.upstream.UpstreamException;
import net.optionfactory.spring.upstream.UpstreamInterceptor;
import net.optionfactory.spring.upstream.UpstreamPort;
import net.optionfactory.spring.upstream.UpstreamResponseErrorHandler;
import net.optionfactory.spring.upstream.counters.UpstreamRequestCounter;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class UpstreamRestPort<CTX>
implements UpstreamPort<CTX> {
    private final String upstreamId;
    private final UpstreamRequestCounter requestCounter;
    private final RestTemplate rest;
    private final List<UpstreamInterceptor<CTX>> interceptors;
    private final ThreadLocal<UpstreamInterceptor.ExchangeContext<CTX>> callContexts = new ThreadLocal();

    public UpstreamRestPort(String upstreamId, UpstreamRequestCounter requestCounter, ObjectMapper objectMapper, SSLConnectionSocketFactory socketFactory, int connectionTimeoutInMillis, List<UpstreamInterceptor<CTX>> interceptors) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        CloseableHttpClient client = builder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(connectionTimeoutInMillis).build()).setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).build()).build();
        HttpComponentsClientHttpRequestFactory innerRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)client);
        BufferingClientHttpRequestFactory requestFactory = new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)innerRequestFactory);
        ByteArrayHttpMessageConverter byteArrayMessageConverter = new ByteArrayHttpMessageConverter();
        MappingJackson2HttpMessageConverter mappingJacksonMessageConverter = new MappingJackson2HttpMessageConverter(objectMapper);
        FormHttpMessageConverter formMessageConverter = new FormHttpMessageConverter();
        formMessageConverter.addPartConverter((HttpMessageConverter)mappingJacksonMessageConverter);
        ResourceHttpMessageConverter resourceMessageConverter = new ResourceHttpMessageConverter();
        List<HttpMessageConverter> converters = Arrays.asList(byteArrayMessageConverter, formMessageConverter, mappingJacksonMessageConverter, resourceMessageConverter);
        RestTemplate inner = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        inner.setMessageConverters(converters);
        inner.setInterceptors(List.of(new RestInterceptors<CTX>(upstreamId, interceptors, this.callContexts)));
        inner.setErrorHandler((ResponseErrorHandler)new UpstreamResponseErrorHandler(upstreamId, interceptors, this.callContexts));
        this.upstreamId = upstreamId;
        this.requestCounter = requestCounter;
        this.interceptors = interceptors;
        this.rest = inner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ResponseEntity<T> exchange(CTX context, String endpointId, RequestEntity<?> requestEntity, Class<T> responseType) {
        UpstreamInterceptor.ExchangeContext ctx = new UpstreamInterceptor.ExchangeContext();
        ctx.prepare = new UpstreamInterceptor.PrepareContext();
        ctx.prepare.requestId = this.requestCounter.next();
        ctx.prepare.ctx = context;
        ctx.prepare.endpointId = endpointId;
        ctx.prepare.entity = requestEntity;
        ctx.prepare.upstreamId = this.upstreamId;
        this.callContexts.set(ctx);
        try {
            ctx.prepare.entity = this.makeEntity(ctx.prepare);
            ResponseEntity response = this.rest.exchange(ctx.prepare.entity, responseType);
            for (UpstreamInterceptor<CTX> interceptor : this.interceptors) {
                interceptor.mappingSuccess(ctx.prepare, ctx.request, ctx.response, response);
            }
            ResponseEntity responseEntity = response;
            return responseEntity;
        }
        finally {
            this.callContexts.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ResponseEntity<T> exchange(CTX context, String endpointId, RequestEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) {
        UpstreamInterceptor.ExchangeContext ctx = new UpstreamInterceptor.ExchangeContext();
        ctx.prepare = new UpstreamInterceptor.PrepareContext();
        ctx.prepare.requestId = this.requestCounter.next();
        ctx.prepare.ctx = context;
        ctx.prepare.endpointId = endpointId;
        ctx.prepare.entity = requestEntity;
        ctx.prepare.upstreamId = this.upstreamId;
        this.callContexts.set(ctx);
        try {
            ctx.prepare.entity = this.makeEntity(ctx.prepare);
            ResponseEntity response = this.rest.exchange(ctx.prepare.entity, responseType);
            for (UpstreamInterceptor<CTX> interceptor : this.interceptors) {
                interceptor.mappingSuccess(ctx.prepare, ctx.request, ctx.response, response);
            }
            ResponseEntity responseEntity = response;
            return responseEntity;
        }
        finally {
            this.callContexts.remove();
        }
    }

    private RequestEntity<?> makeEntity(UpstreamInterceptor.PrepareContext<CTX> prepare) {
        HttpHeaders headers = new HttpHeaders();
        headers.addAll((MultiValueMap)prepare.entity.getHeaders());
        for (UpstreamInterceptor<CTX> interceptor : this.interceptors) {
            HttpHeaders newHeaders = interceptor.prepare(prepare);
            if (newHeaders == null) continue;
            headers.addAll((MultiValueMap)newHeaders);
        }
        return new RequestEntity(prepare.entity.getBody(), (MultiValueMap)headers, prepare.entity.getMethod(), prepare.entity.getUrl(), prepare.entity.getType());
    }

    public static class RestInterceptors<CTX>
    implements ClientHttpRequestInterceptor {
        private final String upstreamId;
        private final List<UpstreamInterceptor<CTX>> interceptors;
        private final ThreadLocal<UpstreamInterceptor.ExchangeContext<CTX>> exchangeContexts;

        public RestInterceptors(String upstreamId, List<UpstreamInterceptor<CTX>> interceptors, ThreadLocal<UpstreamInterceptor.ExchangeContext<CTX>> exchangeContexts) {
            this.upstreamId = upstreamId;
            this.interceptors = interceptors;
            this.exchangeContexts = exchangeContexts;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] requestBodyBytes, ClientHttpRequestExecution execution) throws IOException {
            UpstreamInterceptor.ExchangeContext<CTX> context = this.exchangeContexts.get();
            context.request = new UpstreamInterceptor.RequestContext();
            context.request.at = Instant.now();
            context.request.body = new ByteArrayResource(requestBodyBytes);
            context.request.headers = request.getHeaders();
            for (UpstreamInterceptor<CTX> interceptor : this.interceptors) {
                interceptor.before(context.prepare, context.request);
            }
            try {
                ClientHttpResponse response = execution.execute(request, requestBodyBytes);
                try (InputStream body = response.getBody();){
                    context.response = new UpstreamInterceptor.ResponseContext();
                    context.response.at = Instant.now();
                    context.response.status = response.getStatusCode();
                    context.response.headers = response.getHeaders();
                    context.response.body = new ByteArrayResource(StreamUtils.copyToByteArray((InputStream)body));
                }
                for (UpstreamInterceptor<CTX> interceptor : this.interceptors) {
                    interceptor.remotingSuccess(context.prepare, context.request, context.response);
                }
                return response;
            }
            catch (IOException | RuntimeException ex) {
                context.error = new UpstreamInterceptor.ErrorContext();
                context.error.at = Instant.now();
                RestInterceptors.searchCauseOfType(ex, JsonMappingException.class).ifPresent(cex -> {
                    context.error.ex = cex;
                    for (UpstreamInterceptor<CTX> interceptor : this.interceptors) {
                        interceptor.remotingError(context.prepare, context.request, context.error);
                    }
                    throw new UpstreamException(this.upstreamId, "MAPPING_ERROR", cex.getMessage());
                });
                RestInterceptors.searchCauseOfType(ex, SocketException.class).ifPresent(cex -> {
                    context.error.ex = cex;
                    for (UpstreamInterceptor<CTX> interceptor : this.interceptors) {
                        interceptor.remotingError(context.prepare, context.request, context.error);
                    }
                    throw new UpstreamException(this.upstreamId, "UPSTREAM_DOWN", cex.getMessage());
                });
                context.error.ex = ex;
                for (UpstreamInterceptor<CTX> interceptor : this.interceptors) {
                    interceptor.remotingError(context.prepare, context.request, context.error);
                }
                throw new UpstreamException(this.upstreamId, "GENERIC_ERROR", ex.getMessage());
            }
        }

        private static <T> Optional<T> searchCauseOfType(Throwable specific, Class<T> type) {
            for (Throwable current = specific; current != null; current = current.getCause()) {
                if (!type.isAssignableFrom(current.getClass())) continue;
                return Optional.of(current);
            }
            return Optional.empty();
        }
    }
}

