/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.spring.oidc.authcode;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class ConfigurableOauth2UserService<U extends OidcUser>
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private final OidcUserService delegate;
    private final BiFunction<Set<GrantedAuthority>, OidcUser, U> userFactory;

    public ConfigurableOauth2UserService(ClientHttpRequestFactory httpRequestFactory, ApplicationEventPublisher events, BiFunction<Set<GrantedAuthority>, OidcUser, U> userFactory) {
        RestTemplate oauth2RestTemplate = new RestTemplate(httpRequestFactory);
        oauth2RestTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        DefaultOAuth2UserService defaultOAuth2UserService = new DefaultOAuth2UserService();
        defaultOAuth2UserService.setRestOperations((RestOperations)oauth2RestTemplate);
        this.delegate = new OidcUserService();
        this.delegate.setOauth2UserService((OAuth2UserService)defaultOAuth2UserService);
        this.userFactory = userFactory;
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = this.delegate.loadUser(userRequest);
        HashSet augmentedAuthorities = new HashSet();
        augmentedAuthorities.addAll(oidcUser.getAuthorities());
        List groups = (List)oidcUser.getAttribute("groups");
        if (groups != null) {
            Set additionalAuthorities = groups.stream().map(g -> String.format("ROLE_GROUP_%s", g.toUpperCase().replace("-", "_"))).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
            augmentedAuthorities.addAll(additionalAuthorities);
        }
        return (OidcUser)this.userFactory.apply(augmentedAuthorities, oidcUser);
    }
}

