/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.spring.context.conditionals;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Documented
@Conditional(value={PropertyCondition.class})
public @interface ConditionalProperty {
    public String name();

    public String[] matches() default {"true"};

    public boolean matchesWhenMissing() default false;

    public static class PropertyCondition
    implements ConfigurationCondition {
        private static final String ANNOTATION_NAME = ConditionalProperty.class.getName();

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (!metadata.isAnnotated(ANNOTATION_NAME)) {
                return true;
            }
            if (metadata.isAnnotated(Configuration.class.getName())) {
                throw new IllegalStateException(String.format("@%s cannot be applied to @%s classes at type level, properties are not accessible in this phase yet", ConditionalProperty.class.getSimpleName(), Configuration.class.getSimpleName()));
            }
            Map attributes = metadata.getAnnotationAttributes(ANNOTATION_NAME);
            String propertyName = (String)attributes.get("name");
            String[] propertyMatches = (String[])attributes.get("matches");
            boolean propertyMatchesWhenMissing = (Boolean)attributes.get("matchesWhenMissing");
            if (!context.getEnvironment().containsProperty(propertyName)) {
                return propertyMatchesWhenMissing;
            }
            String propertyValue = context.getEnvironment().getProperty(propertyName);
            return Stream.of(propertyMatches).anyMatch(propertyValue::equals);
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }
    }
}

