/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.spring.authentication.code;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.util.ForwardedHeaderUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcLogoutSuccessHandler
implements LogoutSuccessHandler {
    private final URI oidcServerBaseUri;
    private final String path;
    private final boolean useRelativeRedirects;

    public OidcLogoutSuccessHandler(URI oidcServerBaseUri, String path, boolean useRelativeRedirects) {
        this.oidcServerBaseUri = oidcServerBaseUri;
        this.path = path;
        this.useRelativeRedirects = useRelativeRedirects;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        ServletServerHttpRequest sRequest = new ServletServerHttpRequest(request);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this.oidcServerBaseUri).path("/logout").queryParam("redirect_uri", new Object[]{ForwardedHeaderUtils.adaptFromForwardedHeaders((URI)sRequest.getURI(), (HttpHeaders)sRequest.getHeaders()).replacePath(this.path).toUriString()});
        String redirectUri = this.useRelativeRedirects ? builder.scheme(null).host(null).toUriString() : builder.toUriString();
        response.sendRedirect(redirectUri);
    }
}

