/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.login;

import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.keycloak.Config;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.forms.login.LoginFormsProviderFactory;
import org.keycloak.forms.login.freemarker.FreeMarkerLoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.Urls;
import org.keycloak.theme.Theme;

public class ConfigurableFreemarkerLoginFormsProvider
extends FreeMarkerLoginFormsProvider {
    private final Map<String, String> conf;

    public ConfigurableFreemarkerLoginFormsProvider(KeycloakSession session, Map<String, String> conf) {
        super(session);
        this.conf = conf;
        this.attributes.put("conf", conf);
        this.attributes.put("baseUri", session.getContext().getUri().getBaseUri().getPath());
        this.attributes.put("realmUri", Urls.realmBase((URI)session.getContext().getUri().getBaseUri()).path("{realm}").build(new Object[]{session.getContext().getRealm().getName()}).getPath());
        System.out.println(this.attributes);
    }

    protected Properties handleThemeResources(Theme theme, Locale locale) {
        String prefix = "conf.";
        Properties ps = super.handleThemeResources(theme, locale);
        for (String key : ps.stringPropertyNames()) {
            String value = ps.getProperty(key);
            ps.setProperty(key, StringPropertyReplacer.replaceProperties((String)value, k -> k.startsWith("conf.") ? this.conf.get(k.substring("conf.".length())) : null));
        }
        return ps;
    }

    public static class Factory
    implements LoginFormsProviderFactory {
        private Map<String, String> conf;

        public ConfigurableFreemarkerLoginFormsProvider create(KeycloakSession session) {
            return new ConfigurableFreemarkerLoginFormsProvider(session, this.conf);
        }

        public void init(Config.Scope ignored) {
            String prefix = "kc.conf-login-";
            Config config = ConfigProvider.getConfig();
            this.conf = StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(key -> key.startsWith("kc.conf-login-")).map(k -> Map.entry(k.substring("kc.conf-login-".length()), (String)config.getValue(k, String.class))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void postInit(KeycloakSessionFactory factory) {
        }

        public void close() {
        }

        public String getId() {
            return "opfa-freemarker-configurable";
        }

        public int order() {
            return 1;
        }
    }
}

