/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.spid.metadata.extensions;

import java.util.Optional;
import net.optionfactory.keycloak.spid.SpidIdentityProviderConfig;
import net.optionfactory.keycloak.spid.metadata.extensions.SpidBillingContactType;
import org.jboss.logging.Logger;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.util.StringUtil;
import org.w3c.dom.Element;

public class SpidBillingContactTypePrivateSP
extends SpidBillingContactType {
    protected static final Logger logger = Logger.getLogger(SpidBillingContactTypePrivateSP.class);
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String SPID_METADATA_INVOICING_EXTENSIONS_NS = "https://spid.gov.it/invoicing-extensions";

    public SpidBillingContactTypePrivateSP(SpidIdentityProviderConfig config) throws ConfigurationException {
        super(config);
        Element customerTransferee = this.createElement("fpa:CessionarioCommittente");
        customerTransferee.appendChild(this.createPersonalData(config));
        customerTransferee.appendChild(this.createHeadQuarters(config));
        this.extensions.addExtension((Object)customerTransferee);
    }

    protected Element createPersonalData(SpidIdentityProviderConfig config) {
        Element personalData = this.createElement("fpa:DatiAnagrafici");
        Element vatFiscalCode = this.createElement("fpa:IdFiscaleIVA");
        if (StringUtil.isNullOrEmpty((String)config.getVatNumber()) || config.getVatNumber().length() < 13) {
            logger.errorf("Invalid VAT number % ", (Object)config.getVatNumber());
        } else {
            this.createElement("fpa:IdPaese", config.getVatNumber().substring(0, 2)).ifPresent(vatFiscalCode::appendChild);
            this.createElement("fpa:IdCodice", config.getVatNumber().substring(3, 13)).ifPresent(vatFiscalCode::appendChild);
        }
        personalData.appendChild(vatFiscalCode);
        Element registry = this.createElement("fpa:Anagrafica");
        this.createElement("fpa:Denominazione", config.getBillingContactRegistryName()).ifPresent(registry::appendChild);
        personalData.appendChild(registry);
        return personalData;
    }

    protected Element createHeadQuarters(SpidIdentityProviderConfig config) {
        Element headQuarters = this.createElement("fpa:Sede");
        this.createElement("fpa:Indirizzo", config.getBillingContactSiteAddress()).ifPresent(headQuarters::appendChild);
        this.createElement("fpa:NumeroCivico", config.getBillingContactSiteNumber()).ifPresent(headQuarters::appendChild);
        this.createElement("fpa:CAP", config.getBillingContactSiteZipCode()).ifPresent(headQuarters::appendChild);
        this.createElement("fpa:Comune", config.getBillingContactSiteCity()).ifPresent(headQuarters::appendChild);
        this.createElement("fpa:Provincia", config.getBillingContactSiteProvince()).ifPresent(headQuarters::appendChild);
        this.createElement("fpa:Nazione", config.getBillingContactSiteCountry()).ifPresent(headQuarters::appendChild);
        return headQuarters;
    }

    protected Element createElement(String name) {
        Element element = this.doc.createElementNS(SPID_METADATA_INVOICING_EXTENSIONS_NS, name);
        element.setAttributeNS(XMLNS_NS, "xmlns:fpa", SPID_METADATA_INVOICING_EXTENSIONS_NS);
        return element;
    }

    protected Optional<Element> createElement(String name, String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            return Optional.empty();
        }
        Element element = this.doc.createElementNS(SPID_METADATA_INVOICING_EXTENSIONS_NS, name);
        element.setAttributeNS(XMLNS_NS, "xmlns:fpa", SPID_METADATA_INVOICING_EXTENSIONS_NS);
        element.setTextContent(value);
        return Optional.of(element);
    }
}

