/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.spid.metadata.extensions;

import java.util.Optional;
import net.optionfactory.keycloak.spid.SpidIdentityProviderConfig;
import net.optionfactory.keycloak.spid.metadata.extensions.SpidOtherContactTypePrivateSP;
import net.optionfactory.keycloak.spid.metadata.extensions.SpidOtherContactTypePublicSP;
import org.keycloak.dom.saml.v2.metadata.ContactType;
import org.keycloak.dom.saml.v2.metadata.ContactTypeType;
import org.keycloak.dom.saml.v2.metadata.ExtensionsType;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SpidOtherContactType
extends ContactType {
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String SPID_METADATA_EXTENSIONS_NS = "https://spid.gov.it/saml-extensions";
    protected Document doc;

    public static Optional<SpidOtherContactType> build(SpidIdentityProviderConfig config) throws ConfigurationException {
        if (StringUtil.isNullOrEmpty((String)config.getOtherContactCompany()) && StringUtil.isNullOrEmpty((String)config.getOtherContactEmail()) && StringUtil.isNullOrEmpty((String)config.getOtherContactPhone())) {
            return Optional.empty();
        }
        return Optional.of(config.isSpPrivate() ? new SpidOtherContactTypePrivateSP(config) : new SpidOtherContactTypePublicSP(config));
    }

    protected SpidOtherContactType(SpidIdentityProviderConfig config) throws ConfigurationException {
        super(ContactTypeType.OTHER);
        if (!StringUtil.isNullOrEmpty((String)config.getOtherContactCompany())) {
            this.setCompany(config.getOtherContactCompany());
        }
        if (!StringUtil.isNullOrEmpty((String)config.getOtherContactEmail())) {
            this.addEmailAddress(config.getOtherContactEmail());
        }
        if (!StringUtil.isNullOrEmpty((String)config.getOtherContactPhone())) {
            this.addTelephone(config.getOtherContactPhone());
        }
        this.setExtensions(new ExtensionsType());
        this.doc = DocumentUtil.createDocument();
    }

    protected void addQualifier(String qualifier) {
        Element spTypeElement = this.doc.createElementNS(SPID_METADATA_EXTENSIONS_NS, qualifier);
        spTypeElement.setAttributeNS(XMLNS_NS, "xmlns:spid", SPID_METADATA_EXTENSIONS_NS);
        this.getExtensions().addExtension((Object)spTypeElement);
    }

    protected void addExtensionElement(String name, String value) {
        if (!StringUtil.isNullOrEmpty((String)value)) {
            Element ipaCodeElement = this.doc.createElementNS(SPID_METADATA_EXTENSIONS_NS, name);
            ipaCodeElement.setAttributeNS(XMLNS_NS, "xmlns:spid", SPID_METADATA_EXTENSIONS_NS);
            ipaCodeElement.setTextContent(value);
            this.getExtensions().addExtension((Object)ipaCodeElement);
        }
    }
}

