/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.spid.metadata.extensions;

import java.util.Optional;
import net.optionfactory.keycloak.spid.SpidIdentityProviderConfig;
import net.optionfactory.keycloak.spid.metadata.extensions.SpidBillingContactTypePrivateSP;
import org.keycloak.dom.saml.v2.metadata.ContactType;
import org.keycloak.dom.saml.v2.metadata.ContactTypeType;
import org.keycloak.dom.saml.v2.metadata.ExtensionsType;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.w3c.dom.Document;

public class SpidBillingContactType
extends ContactType {
    protected Document doc;

    public static Optional<SpidBillingContactType> build(SpidIdentityProviderConfig config) throws ConfigurationException {
        if (StringUtil.isNullOrEmpty((String)config.getBillingContactCompany()) && StringUtil.isNullOrEmpty((String)config.getBillingContactEmail()) && StringUtil.isNullOrEmpty((String)config.getBillingContactPhone())) {
            return Optional.empty();
        }
        return config.isSpPrivate() ? Optional.of(new SpidBillingContactTypePrivateSP(config)) : Optional.empty();
    }

    protected SpidBillingContactType(SpidIdentityProviderConfig config) throws ConfigurationException {
        super(ContactTypeType.BILLING);
        if (!StringUtil.isNullOrEmpty((String)config.getBillingContactCompany())) {
            this.setCompany(config.getBillingContactCompany());
        }
        if (!StringUtil.isNullOrEmpty((String)config.getBillingContactEmail())) {
            this.addEmailAddress(config.getBillingContactEmail());
        }
        if (!StringUtil.isNullOrEmpty((String)config.getBillingContactPhone())) {
            this.addTelephone(config.getBillingContactPhone());
        }
        this.setExtensions(new ExtensionsType());
        this.doc = DocumentUtil.createDocument();
    }
}

