/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.spid.metadata;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamWriter;
import net.optionfactory.keycloak.spid.SpidIdentityProvider;
import net.optionfactory.keycloak.spid.SpidIdentityProviderConfig;
import net.optionfactory.keycloak.spid.SpidIdentityProviderFactory;
import net.optionfactory.keycloak.spid.metadata.extensions.SpidBillingContactType;
import net.optionfactory.keycloak.spid.metadata.extensions.SpidOrganizationType;
import net.optionfactory.keycloak.spid.metadata.extensions.SpidOtherContactType;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.dom.saml.v2.metadata.AttributeConsumingServiceType;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.LocalizedNameType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.mappers.SamlMetadataDescriptorUpdater;
import org.keycloak.saml.SPMetadataDescriptor;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLMetadataWriter;
import org.keycloak.services.resource.RealmResourceProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpidSpMetadataResourceProvider
implements RealmResourceProvider {
    protected static final Logger logger = Logger.getLogger(SpidSpMetadataResourceProvider.class);
    private KeycloakSession session;

    public SpidSpMetadataResourceProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    @GET
    @Produces(value={"text/xml; charset=utf-8"})
    public Response get() {
        try {
            RealmModel realm = this.session.getContext().getRealm();
            List lstSpidIdentityProviders = realm.getIdentityProvidersStream().filter(t -> t.getProviderId().equals("spid") && t.isEnabled()).sorted((o1, o2) -> o1.getAlias().compareTo(o2.getAlias())).collect(Collectors.toList());
            if (lstSpidIdentityProviders.size() == 0) {
                throw new Exception("No SPID providers found!");
            }
            SpidIdentityProviderFactory providerFactory = new SpidIdentityProviderFactory();
            SpidIdentityProvider firstSpidProvider = providerFactory.create(this.session, (IdentityProviderModel)lstSpidIdentityProviders.get(0));
            KeycloakUriInfo uriInfo = this.session.getContext().getUri();
            URI authnBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.getUri();
            if (((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).isPostBindingAuthnRequest()) {
                authnBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.getUri();
            }
            URI endpoint = uriInfo.getBaseUriBuilder().path("realms").path(realm.getName()).path("broker").path(((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).getAlias()).path("endpoint").build(new Object[0]);
            boolean wantAuthnRequestsSigned = ((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).isWantAuthnRequestsSigned();
            boolean wantAssertionsSigned = ((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).isWantAssertionsSigned();
            boolean wantAssertionsEncrypted = ((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).isWantAssertionsEncrypted();
            String configEntityId = ((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).getEntityId();
            String entityId = this.getEntityId(configEntityId, (UriInfo)uriInfo, realm);
            String nameIDPolicyFormat = ((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).getNameIDPolicyFormat();
            int attributeConsumingServiceIndex = ((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).getAttributeConsumingServiceIndex() != null ? ((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).getAttributeConsumingServiceIndex() : 1;
            String attributeConsumingServiceName = ((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).getAttributeConsumingServiceName();
            String[] attributeConsumingServiceNames = attributeConsumingServiceName != null ? attributeConsumingServiceName.split(",") : null;
            LinkedList signingKeys = new LinkedList();
            LinkedList encryptionKeys = new LinkedList();
            this.session.keys().getKeysStream(realm, KeyUse.SIG, "RS256").filter(Objects::nonNull).filter(key -> key.getCertificate() != null).sorted(SamlService::compareKeys).forEach(key -> {
                try {
                    Element element = SPMetadataDescriptor.buildKeyInfoElement((String)key.getKid(), (String)PemUtils.encodeCertificate((Certificate)key.getCertificate()));
                    signingKeys.add(SPMetadataDescriptor.buildKeyDescriptorType((Element)element, (KeyTypes)KeyTypes.SIGNING, (String)"RS256"));
                    if (key.getStatus() == KeyStatus.ACTIVE) {
                        encryptionKeys.add(SPMetadataDescriptor.buildKeyDescriptorType((Element)element, (KeyTypes)KeyTypes.ENCRYPTION, (String)"RS256"));
                    }
                }
                catch (ParserConfigurationException e) {
                    logger.warn((Object)"Failed to export SAML SP Metadata!", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            EntityDescriptorType entityDescriptor = SPMetadataDescriptor.buildSPDescriptor((URI)authnBinding, (URI)authnBinding, (URI)endpoint, (URI)endpoint, (boolean)wantAuthnRequestsSigned, (boolean)wantAssertionsSigned, (boolean)wantAssertionsEncrypted, (String)entityId, (String)nameIDPolicyFormat, signingKeys, encryptionKeys);
            AttributeConsumingServiceType attributeConsumingService = new AttributeConsumingServiceType(attributeConsumingServiceIndex);
            attributeConsumingService.setIsDefault(Boolean.valueOf(true));
            if (attributeConsumingServiceNames != null && attributeConsumingServiceNames.length > 0) {
                for (String attributeConsumingServiceNameStr : attributeConsumingServiceNames) {
                    String currentLocale = realm.getDefaultLocale() == null ? "en" : realm.getDefaultLocale();
                    String[] parsedName = attributeConsumingServiceNameStr.split("\\|", 2);
                    String serviceNameLocale = parsedName.length >= 2 ? parsedName[0] : currentLocale;
                    LocalizedNameType attributeConsumingServiceNameElement = new LocalizedNameType(serviceNameLocale);
                    attributeConsumingServiceNameElement.setValue((String)(parsedName.length >= 2 ? parsedName[1] : attributeConsumingServiceNameStr));
                    attributeConsumingService.addServiceName(attributeConsumingServiceNameElement);
                }
            }
            for (EntityDescriptorType.EDTChoiceType choiceType : entityDescriptor.getChoiceType()) {
                List descriptors = choiceType.getDescriptors();
                if (descriptors == null) continue;
                for (EntityDescriptorType.EDTDescriptorChoiceType descriptor : descriptors) {
                    if (descriptor.getSpDescriptor() == null) continue;
                    descriptor.getSpDescriptor().addAttributeConsumerService(attributeConsumingService);
                }
            }
            realm.getIdentityProviderMappersByAliasStream(((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).getAlias()).forEach(mapper -> {
                IdentityProviderMapper target = (IdentityProviderMapper)this.session.getKeycloakSessionFactory().getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                if (target instanceof SamlMetadataDescriptorUpdater) {
                    SamlMetadataDescriptorUpdater metadataAttrProvider = (SamlMetadataDescriptorUpdater)target;
                    metadataAttrProvider.updateMetadata(mapper, entityDescriptor);
                }
            });
            SpidSpMetadataResourceProvider.customizeEntityDescriptor(entityDescriptor, (SpidIdentityProviderConfig)firstSpidProvider.getConfig());
            List<URI> assertionEndpoints = lstSpidIdentityProviders.stream().map(arg_0 -> SpidSpMetadataResourceProvider.lambda$get$5((UriInfo)uriInfo, realm, arg_0)).collect(Collectors.toList());
            List<URI> logoutEndpoints = lstSpidIdentityProviders.stream().map(arg_0 -> SpidSpMetadataResourceProvider.lambda$get$6((UriInfo)uriInfo, realm, arg_0)).collect(Collectors.toList());
            for (EntityDescriptorType.EDTChoiceType choiceType : entityDescriptor.getChoiceType()) {
                List descriptors = choiceType.getDescriptors();
                if (descriptors == null) continue;
                for (EntityDescriptorType.EDTDescriptorChoiceType descriptor : descriptors) {
                    SPSSODescriptorType spDescriptor = descriptor.getSpDescriptor();
                    if (spDescriptor == null) continue;
                    SpidSpMetadataResourceProvider.customizeSpDescriptor(spDescriptor, authnBinding, authnBinding, assertionEndpoints, logoutEndpoints);
                }
            }
            String descriptor = this.writeEntityDescriptorWithConsistentID(entityDescriptor);
            if (((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).isSignSpMetadata()) {
                KeyManager.ActiveRsaKey activeKey = this.session.keys().getActiveRsaKey(realm);
                String keyName = ((SpidIdentityProviderConfig)firstSpidProvider.getConfig()).getXmlSigKeyInfoKeyNameTransformer().getKeyName(activeKey.getKid(), activeKey.getCertificate());
                KeyPair keyPair = new KeyPair(activeKey.getPublicKey(), activeKey.getPrivateKey());
                Document metadataDocument = DocumentUtil.getDocument((String)descriptor);
                SAML2Signature signatureHelper = new SAML2Signature();
                signatureHelper.setSignatureMethod(firstSpidProvider.getSignatureAlgorithm().getXmlSignatureMethod());
                signatureHelper.setDigestMethod(firstSpidProvider.getSignatureAlgorithm().getXmlSignatureDigestMethod());
                Node nextSibling = metadataDocument.getDocumentElement().getFirstChild();
                signatureHelper.setNextSibling(nextSibling);
                signatureHelper.signSAMLDocument(metadataDocument, keyName, keyPair, "http://www.w3.org/2001/10/xml-exc-c14n#");
                descriptor = DocumentUtil.getDocumentAsString((Document)metadataDocument);
            }
            return Response.ok((Object)descriptor, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to export SAML SP Metadata!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String writeEntityDescriptorWithConsistentID(EntityDescriptorType entityDescriptor) throws ProcessingException {
        entityDescriptor.setID("ID_");
        String data = this.entityDescriptorAsString(entityDescriptor);
        String hash = SpidSpMetadataResourceProvider.md5hex(data);
        entityDescriptor.setID("ID_" + hash);
        return this.entityDescriptorAsString(entityDescriptor);
    }

    private String entityDescriptorAsString(EntityDescriptorType entityDescriptor) throws ProcessingException {
        StringWriter sw = new StringWriter();
        XMLStreamWriter writer = StaxUtil.getXMLStreamWriter((Writer)sw);
        SAMLMetadataWriter metadataWriter = new SAMLMetadataWriter(writer);
        metadataWriter.writeEntityDescriptor(entityDescriptor);
        return sw.toString();
    }

    private String getEntityId(String configEntityId, UriInfo uriInfo, RealmModel realm) {
        if (configEntityId == null || configEntityId.isEmpty()) {
            return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
        }
        return configEntityId;
    }

    private static void customizeEntityDescriptor(EntityDescriptorType entityDescriptor, SpidIdentityProviderConfig config) throws ConfigurationException {
        SpidOrganizationType.build(config).ifPresent(arg_0 -> ((EntityDescriptorType)entityDescriptor).setOrganization(arg_0));
        SpidOtherContactType.build(config).ifPresent(arg_0 -> ((EntityDescriptorType)entityDescriptor).addContactPerson(arg_0));
        SpidBillingContactType.build(config).ifPresent(arg_0 -> ((EntityDescriptorType)entityDescriptor).addContactPerson(arg_0));
    }

    private static void customizeSpDescriptor(SPSSODescriptorType spDescriptor, URI loginBinding, URI logoutBinding, List<URI> assertionEndpoints, List<URI> logoutEndpoints) {
        List lstSingleLogoutService = spDescriptor.getSingleLogoutService();
        for (int i = lstSingleLogoutService.size() - 1; i >= 0; --i) {
            spDescriptor.removeSingleLogoutService((EndpointType)lstSingleLogoutService.get(i));
        }
        for (URI logoutEndpoint : logoutEndpoints) {
            spDescriptor.addSingleLogoutService(new EndpointType(logoutBinding, logoutEndpoint));
        }
        List lstAssertionConsumerService = spDescriptor.getAssertionConsumerService();
        for (int i = lstAssertionConsumerService.size() - 1; i >= 0; --i) {
            spDescriptor.removeAssertionConsumerService((IndexedEndpointType)lstAssertionConsumerService.get(i));
        }
        int assertionEndpointIndex = 0;
        for (URI assertionEndpoint : assertionEndpoints) {
            IndexedEndpointType assertionConsumerEndpoint = new IndexedEndpointType(loginBinding, assertionEndpoint);
            if (assertionEndpointIndex == 0) {
                assertionConsumerEndpoint.setIsDefault(Boolean.valueOf(true));
            }
            assertionConsumerEndpoint.setIndex(assertionEndpointIndex);
            spDescriptor.addAssertionConsumerService(assertionConsumerEndpoint);
            ++assertionEndpointIndex;
        }
    }

    private static String md5hex(String data) {
        try {
            byte[] bytes = MessageDigest.getInstance("MD5").digest(data.getBytes(StandardCharsets.UTF_8));
            return new BigInteger(1, bytes).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }

    private static /* synthetic */ URI lambda$get$6(UriInfo uriInfo, RealmModel realm, IdentityProviderModel t) {
        return uriInfo.getBaseUriBuilder().path("realms").path(realm.getName()).path("broker").path(t.getAlias()).path("endpoint").build(new Object[0]);
    }

    private static /* synthetic */ URI lambda$get$5(UriInfo uriInfo, RealmModel realm, IdentityProviderModel t) {
        return uriInfo.getBaseUriBuilder().path("realms").path(realm.getName()).path("broker").path(t.getAlias()).path("endpoint").build(new Object[0]);
    }
}

