/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.spid;

import java.io.IOException;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import net.optionfactory.keycloak.spid.SpidIdentityProvider;
import net.optionfactory.keycloak.spid.SpidIdentityProviderConfig;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.dom.saml.common.CommonConditionsType;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.AuthnContextComparisonType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlPrincipalType;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.SamlSessionUtils;
import org.keycloak.protocol.saml.preprocessor.SamlAuthenticationPreprocessor;
import org.keycloak.rotation.HardcodedKeyLocator;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.constants.X500SAMLProfileConstants;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.saml.processing.core.util.XMLSignatureUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.saml.validators.ConditionsValidator;
import org.keycloak.saml.validators.DestinationValidator;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.LockObjectsForModification;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpidSAMLEndpoint {
    protected static final Logger logger = Logger.getLogger(SpidSAMLEndpoint.class);
    public static final String SAML_FEDERATED_SESSION_INDEX = "SAML_FEDERATED_SESSION_INDEX";
    public static final String SAML_FEDERATED_SUBJECT_NAMEID = "SAML_FEDERATED_SUBJECT_NAME_ID";
    public static final String SAML_LOGIN_RESPONSE = "SAML_LOGIN_RESPONSE";
    public static final String SAML_ASSERTION = "SAML_ASSERTION";
    public static final String SAML_AUTHN_STATEMENT = "SAML_AUTHN_STATEMENT";
    protected RealmModel realm;
    protected EventBuilder event;
    protected SpidIdentityProviderConfig config;
    protected IdentityProvider.AuthenticationCallback callback;
    protected SpidIdentityProvider provider;
    private final DestinationValidator destinationValidator;
    private static final String _UTC_STRING = "^(-?(?:[1-9][0-9]*)?[0-9]{4})-(1[0-2]|0[1-9])-(3[01]|0[1-9]|[12][0-9])T(2[0-3]|[01][0-9]):([0-5][0-9]):([0-5][0-9])(\\.[0-9]+)?(Z|[+-](?:2[0-3]|[01][0-9]):[0-5][0-9])?$";
    private static final String[] SPID_LEVEL = new String[]{"https://www.spid.gov.it/SpidL1", "https://www.spid.gov.it/SpidL2", "https://www.spid.gov.it/SpidL3"};
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpHeaders headers;

    public SpidSAMLEndpoint(RealmModel realm, SpidIdentityProvider provider, SpidIdentityProviderConfig config, IdentityProvider.AuthenticationCallback callback, DestinationValidator destinationValidator) {
        this.realm = realm;
        this.config = config;
        this.callback = callback;
        this.provider = provider;
        this.destinationValidator = destinationValidator;
    }

    @GET
    @NoCache
    @Path(value="descriptor")
    public Response getSPDescriptor() {
        return this.provider.export((UriInfo)this.session.getContext().getUri(), this.realm, null);
    }

    @GET
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState) {
        return new RedirectBinding().execute(samlRequest, samlResponse, relayState, null);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState) {
        return new PostBinding().execute(samlRequest, samlResponse, relayState, null);
    }

    @Path(value="clients/{client_id}")
    @GET
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState, @PathParam(value="client_id") String clientId) {
        return new RedirectBinding().execute(samlRequest, samlResponse, relayState, clientId);
    }

    @Path(value="clients/{client_id}")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState, @PathParam(value="client_id") String clientId) {
        return new PostBinding().execute(samlRequest, samlResponse, relayState, clientId);
    }

    private String getX500Attribute(AssertionType assertion, X500SAMLProfileConstants attribute) {
        return this.getFirstMatchingAttribute(assertion, arg_0 -> ((X500SAMLProfileConstants)attribute).correspondsTo(arg_0));
    }

    private String getAttributeByName(AssertionType assertion, String name) {
        return this.getFirstMatchingAttribute(assertion, attribute -> Objects.equals(attribute.getName(), name));
    }

    private String getAttributeByFriendlyName(AssertionType assertion, String friendlyName) {
        return this.getFirstMatchingAttribute(assertion, attribute -> Objects.equals(attribute.getFriendlyName(), friendlyName));
    }

    private String getPrincipal(AssertionType assertion) {
        SamlPrincipalType principalType = this.config.getPrincipalType();
        if (principalType == null || principalType.equals((Object)SamlPrincipalType.SUBJECT)) {
            NameIDType subjectNameID = this.getSubjectNameID(assertion);
            return subjectNameID != null ? subjectNameID.getValue() : null;
        }
        if (principalType.equals((Object)SamlPrincipalType.ATTRIBUTE)) {
            return this.getAttributeByName(assertion, this.config.getPrincipalAttribute());
        }
        return this.getAttributeByFriendlyName(assertion, this.config.getPrincipalAttribute());
    }

    private String getFirstMatchingAttribute(AssertionType assertion, Predicate<AttributeType> predicate) {
        return assertion.getAttributeStatements().stream().map(AttributeStatementType::getAttributes).flatMap(Collection::stream).map(AttributeStatementType.ASTChoiceType::getAttribute).filter(predicate).map(AttributeType::getAttributeValue).flatMap(Collection::stream).findFirst().map(Object::toString).orElse(null);
    }

    private String expectedPrincipalType() {
        SamlPrincipalType principalType = this.config.getPrincipalType();
        switch (principalType) {
            case SUBJECT: {
                return principalType.name();
            }
            case ATTRIBUTE: 
            case FRIENDLY_ATTRIBUTE: {
                return String.format("%s(%s)", principalType.name(), this.config.getPrincipalAttribute());
            }
        }
        return null;
    }

    private NameIDType getSubjectNameID(AssertionType assertion) {
        SubjectType subject = assertion.getSubject();
        SubjectType.STSubType subType = subject.getSubType();
        return subType != null ? (NameIDType)subType.getBaseID() : null;
    }

    private boolean validateInResponseToAttribute(ResponseType responseType, String expectedRequestId) {
        SubjectConfirmationDataType subjectConfirmationDataElement;
        SubjectConfirmationType subjectConfirmationElement;
        if (expectedRequestId == null || expectedRequestId.isEmpty()) {
            return true;
        }
        if (responseType.getInResponseTo() == null) {
            logger.error((Object)"Response Validation Error: InResponseTo attribute was expected but not present in received response");
            return false;
        }
        String responseInResponseToValue = responseType.getInResponseTo();
        if (responseInResponseToValue.isEmpty()) {
            logger.error((Object)"Response Validation Error: InResponseTo attribute was expected but it is empty in received response");
            return false;
        }
        if (!responseInResponseToValue.equals(expectedRequestId)) {
            logger.error((Object)"Response Validation Error: received InResponseTo attribute does not match the expected request ID");
            return false;
        }
        if (responseType.getAssertions().isEmpty()) {
            return true;
        }
        SubjectType subjectElement = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion().getSubject();
        if (subjectElement != null && subjectElement.getConfirmation() != null && !subjectElement.getConfirmation().isEmpty() && (subjectConfirmationElement = (SubjectConfirmationType)subjectElement.getConfirmation().get(0)) != null && (subjectConfirmationDataElement = subjectConfirmationElement.getSubjectConfirmationData()) != null && subjectConfirmationDataElement.getInResponseTo() != null) {
            String subjectConfirmationDataInResponseToValue = subjectConfirmationDataElement.getInResponseTo();
            if (subjectConfirmationDataInResponseToValue.isEmpty()) {
                logger.error((Object)"Response Validation Error: SubjectConfirmationData InResponseTo attribute was expected but it is empty in received response");
                return false;
            }
            if (!subjectConfirmationDataInResponseToValue.equals(expectedRequestId)) {
                logger.error((Object)"Response Validation Error: received SubjectConfirmationData InResponseTo attribute does not match the expected request ID");
                return false;
            }
        }
        return true;
    }

    private String verifySpidResponse(Element documentElement, Element assertionElement, String expectedRequestId, String requestIssueInstant, String idpEntityId) {
        Pattern utcPattern;
        String responseIDToValue = documentElement.getAttribute("ID");
        if (responseIDToValue.isEmpty()) {
            return "SpidSamlCheck_nr08";
        }
        String responseIssueInstantToValue = documentElement.getAttribute("IssueInstant");
        if (!responseIssueInstantToValue.isEmpty() && !(utcPattern = Pattern.compile(_UTC_STRING)).matcher(responseIssueInstantToValue).find()) {
            return "SpidSamlCheck_nr13";
        }
        try {
            XMLGregorianCalendar requestIssueInstantTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(requestIssueInstant);
            XMLGregorianCalendar responseIssueInstantTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(responseIssueInstantToValue);
            if (responseIssueInstantTime.compare(requestIssueInstantTime) == -1) {
                return "SpidSamlCheck_nr14";
            }
            XMLGregorianCalendar requestFutureIssueInstantTime = (XMLGregorianCalendar)requestIssueInstantTime.clone();
            requestFutureIssueInstantTime.add(DatatypeFactory.newInstance().newDuration(true, 0, 0, 0, 0, 3, 0));
            if (responseIssueInstantTime.compare(requestFutureIssueInstantTime) == 1) {
                return "SpidSamlCheck_nr15";
            }
        }
        catch (DatatypeConfigurationException e) {
            logger.error((Object)e);
            return "SpidSamlCheck_nr14";
        }
        Element issuerElement = this.getDirectChild(documentElement, "Issuer");
        if (issuerElement == null) {
            return "SpidSamlCheck_nr28";
        }
        if (!issuerElement.hasChildNodes() || !StringUtil.isNotNull((String)issuerElement.getFirstChild().getNodeValue()) || this.hasNamedChild(issuerElement)) {
            return "SpidSamlCheck_nr27";
        }
        if (!issuerElement.getFirstChild().getNodeValue().equals(idpEntityId)) {
            return "SpidSamlCheck_nr29";
        }
        if (issuerElement.hasAttribute("Format") && !issuerElement.getAttribute("Format").equals(JBossSAMLURIConstants.NAMEID_FORMAT_ENTITY.get())) {
            return "SpidSamlCheck_nr30";
        }
        String responseAssertionIDToValue = assertionElement.getAttribute("ID");
        if (responseAssertionIDToValue.isEmpty()) {
            return "SpidSamlCheck_nr33";
        }
        String responseAssertionIssueInstantToValue = assertionElement.getAttribute("IssueInstant");
        try {
            XMLGregorianCalendar requestIssueInstantTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(requestIssueInstant);
            XMLGregorianCalendar assertionIssueInstantTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(responseAssertionIssueInstantToValue);
            if (assertionIssueInstantTime.compare(requestIssueInstantTime) == -1) {
                return "SpidSamlCheck_nr39";
            }
            XMLGregorianCalendar requestFutureIssueInstantTime = (XMLGregorianCalendar)requestIssueInstantTime.clone();
            requestFutureIssueInstantTime.add(DatatypeFactory.newInstance().newDuration(true, 0, 0, 0, 0, 3, 0));
            if (assertionIssueInstantTime.compare(requestFutureIssueInstantTime) == 1) {
                return "SpidSamlCheck_nr40";
            }
        }
        catch (DatatypeConfigurationException e) {
            logger.error((Object)e);
            return "SpidSamlCheck_nr39";
        }
        Element subjectElement = this.getDirectChild(assertionElement, "Subject");
        if (subjectElement == null) {
            return "SpidSamlCheck_nr42";
        }
        if (!this.hasNamedChild(subjectElement)) {
            return "SpidSamlCheck_nr41";
        }
        Element nameIdElement = this.getDirectChild(subjectElement, "NameID");
        if (nameIdElement == null) {
            return "SpidSamlCheck_nr44";
        }
        if (!nameIdElement.hasChildNodes() || !StringUtil.isNotNull((String)nameIdElement.getFirstChild().getNodeValue()) || this.hasNamedChild(nameIdElement)) {
            return "SpidSamlCheck_nr43";
        }
        if (nameIdElement.hasAttribute("Format")) {
            if (nameIdElement.getAttribute("Format").isEmpty()) {
                return "SpidSamlCheck_nr45";
            }
            if (!nameIdElement.getAttribute("Format").equals(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get())) {
                return "SpidSamlCheck_nr47";
            }
        } else {
            return "SpidSamlCheck_nr46";
        }
        if (!nameIdElement.hasAttribute("NameQualifier")) {
            return "SpidSamlCheck_nr49";
        }
        if (nameIdElement.getAttribute("NameQualifier").isEmpty()) {
            return "SpidSamlCheck_nr48";
        }
        if (!documentElement.hasAttribute("InResponseTo")) {
            return "SpidSamlCheck_nr17";
        }
        String responseInResponseToValue = documentElement.getAttribute("InResponseTo");
        if (responseInResponseToValue.isEmpty()) {
            return "SpidSamlCheck_nr16";
        }
        if (!responseInResponseToValue.equals(expectedRequestId)) {
            return "SpidSamlCheck_nr18";
        }
        Element subjectConfirmationElement = this.getDirectChild(subjectElement, "SubjectConfirmation");
        if (subjectConfirmationElement == null) {
            return "SpidSamlCheck_nr52";
        }
        if (!this.hasNamedChild(subjectConfirmationElement)) {
            return "SpidSamlCheck_nr51";
        }
        if (!subjectConfirmationElement.hasAttribute("Method")) {
            return "SpidSamlCheck_nr54";
        }
        String subjectConfirmationMethodValue = subjectConfirmationElement.getAttribute("Method");
        if (subjectConfirmationMethodValue.isEmpty()) {
            return "SpidSamlCheck_nr53";
        }
        if (!subjectConfirmationMethodValue.equals(JBossSAMLURIConstants.SUBJECT_CONFIRMATION_BEARER.get())) {
            return "SpidSamlCheck_nr55";
        }
        Element subjectConfirmationDataElement = this.getDirectChild(subjectConfirmationElement, "SubjectConfirmationData");
        if (subjectConfirmationDataElement == null) {
            return "SpidSamlCheck_nr56";
        }
        if (!subjectConfirmationDataElement.hasAttribute("Recipient")) {
            return "SpidSamlCheck_nr58";
        }
        String subjectConfirmationDataRecipientValue = subjectConfirmationDataElement.getAttribute("Recipient");
        if (subjectConfirmationDataRecipientValue.isEmpty()) {
            return "SpidSamlCheck_nr57";
        }
        if (!subjectConfirmationDataRecipientValue.equals(documentElement.getAttribute("Destination"))) {
            return "SpidSamlCheck_nr59";
        }
        if (!subjectConfirmationDataElement.hasAttribute("InResponseTo")) {
            return "SpidSamlCheck_nr61";
        }
        String subjectConfirmationDataInResponseToValue = subjectConfirmationDataElement.getAttribute("InResponseTo");
        if (subjectConfirmationDataInResponseToValue.isEmpty()) {
            return "SpidSamlCheck_nr60";
        }
        if (!subjectConfirmationDataInResponseToValue.equals(expectedRequestId)) {
            return "SpidSamlCheck_nr62";
        }
        if (!subjectConfirmationDataElement.hasAttribute("NotOnOrAfter")) {
            return "SpidSamlCheck_nr64";
        }
        try {
            XMLGregorianCalendar notOnOrAfterTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(subjectConfirmationDataElement.getAttribute("NotOnOrAfter"));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar now = datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
            if (notOnOrAfterTime.compare(now) == -1) {
                return "SpidSamlCheck_nr66";
            }
        }
        catch (DatatypeConfigurationException e) {
            logger.error((Object)e);
            return "SpidSamlCheck_nr66";
        }
        Element assertionIssuerElement = this.getDirectChild(assertionElement, "Issuer");
        if (assertionIssuerElement == null) {
            return "SpidSamlCheck_nr68";
        }
        if (!assertionIssuerElement.hasChildNodes() || !StringUtil.isNotNull((String)assertionIssuerElement.getFirstChild().getNodeValue()) || this.hasNamedChild(assertionIssuerElement)) {
            return "SpidSamlCheck_nr67";
        }
        if (!assertionIssuerElement.getFirstChild().getNodeValue().equals(idpEntityId)) {
            return "SpidSamlCheck_nr69";
        }
        if (assertionIssuerElement.hasAttribute("Format")) {
            if (assertionIssuerElement.getAttribute("Format").isEmpty()) {
                return "SpidSamlCheck_nr70";
            }
            if (!assertionIssuerElement.getAttribute("Format").equals(JBossSAMLURIConstants.NAMEID_FORMAT_ENTITY.get())) {
                return "SpidSamlCheck_nr72";
            }
        } else {
            return "SpidSamlCheck_nr71";
        }
        Element conditionsElement = this.getDirectChild(assertionElement, "Conditions");
        if (conditionsElement == null) {
            return "SpidSamlCheck_nr74";
        }
        if (!this.hasNamedChild(conditionsElement)) {
            return "SpidSamlCheck_nr73";
        }
        if (!conditionsElement.hasAttribute("NotBefore")) {
            return "SpidSamlCheck_nr76";
        }
        if (!conditionsElement.hasAttribute("NotOnOrAfter")) {
            return "SpidSamlCheck_nr80";
        }
        Element audienceRestrictionElement = this.getDirectChild(conditionsElement, "AudienceRestriction");
        if (audienceRestrictionElement == null) {
            return "SpidSamlCheck_nr84";
        }
        Element authnStatementElement = this.getDirectChild(assertionElement, "AuthnStatement");
        if (authnStatementElement == null) {
            return "SpidSamlCheck_nr89";
        }
        if (!this.hasNamedChild(authnStatementElement)) {
            return "SpidSamlCheck_nr88";
        }
        Element authnContextElement = this.getDirectChild(authnStatementElement, "AuthnContext");
        if (authnContextElement == null) {
            return "SpidSamlCheck_nr91";
        }
        if (!this.hasNamedChild(authnContextElement)) {
            return "SpidSamlCheck_nr90";
        }
        Element authnContextClassRef = this.getDirectChild(authnContextElement, "AuthnContextClassRef");
        if (authnContextClassRef == null) {
            return "SpidSamlCheck_nr93";
        }
        if (!authnContextClassRef.hasChildNodes() || !StringUtil.isNotNull((String)authnContextClassRef.getFirstChild().getNodeValue()) || this.hasNamedChild(authnContextClassRef)) {
            return "SpidSamlCheck_nr92";
        }
        String responseSpidLevel = authnContextClassRef.getFirstChild().getNodeValue();
        int spidLevelResponse = Arrays.asList(SPID_LEVEL).indexOf(responseSpidLevel) + 1;
        List<String> spidLevelRequestList = null;
        try {
            spidLevelRequestList = Arrays.asList((String[])JsonSerialization.readValue((String)this.config.getAuthnContextClassRefs(), String[].class));
        }
        catch (Exception e) {
            logger.error((Object)("Could not json-deserialize AuthContextClassRefs config entry: " + this.config.getAuthnContextClassRefs()), (Throwable)e);
            return "SpidSamlCheck_nr97";
        }
        int spidLevelRequest = Arrays.asList(SPID_LEVEL).indexOf(spidLevelRequestList.get(0)) + 1;
        if (spidLevelResponse < 1) {
            return "SpidSamlCheck_nr97";
        }
        if (this.config.getAuthnContextComparisonType().equals((Object)AuthnContextComparisonType.EXACT) ? spidLevelResponse != spidLevelRequest : (this.config.getAuthnContextComparisonType().equals((Object)AuthnContextComparisonType.MINIMUM) ? spidLevelResponse < spidLevelRequest : (this.config.getAuthnContextComparisonType().equals((Object)AuthnContextComparisonType.MAXIMUM) ? spidLevelResponse > spidLevelRequest : this.config.getAuthnContextComparisonType().equals((Object)AuthnContextComparisonType.BETTER) && !responseSpidLevel.equals(this.config.getAuthnContextClassRefs())))) {
            return this.getSpidLevelAssertion(spidLevelResponse);
        }
        return null;
    }

    private String getSpidLevelAssertion(int spidLevel) {
        switch (spidLevel) {
            case 1: {
                return "SpidSamlCheck_nr94";
            }
            case 2: {
                return "SpidSamlCheck_nr95";
            }
            case 3: {
                return "SpidSamlCheck_nr96";
            }
        }
        return "SpidSamlCheck_nr97";
    }

    private boolean hasNamedChild(Element element) {
        NodeList childNodes = element.getChildNodes();
        if (childNodes == null) {
            return false;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || node.getNodeName() == null) continue;
            return true;
        }
        return false;
    }

    private Element getDirectChild(Element parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getLocalName())) continue;
            return (Element)child;
        }
        return null;
    }

    protected class RedirectBinding
    extends Binding {
        protected RedirectBinding() {
        }

        @Override
        protected boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder) {
            MultivaluedMap encodedParams = SpidSAMLEndpoint.this.session.getContext().getUri().getQueryParameters(false);
            String algorithm = (String)encodedParams.getFirst((Object)"SigAlg");
            String signature = (String)encodedParams.getFirst((Object)"Signature");
            return algorithm != null && signature != null;
        }

        @Override
        protected void verifySignature(String key, SAMLDocumentHolder documentHolder) throws VerificationException {
            KeyLocator locator = this.getIDPKeyLocator();
            SamlProtocolUtils.verifyRedirectSignature((SAMLDocumentHolder)documentHolder, (KeyLocator)locator, (UriInfo)SpidSAMLEndpoint.this.session.getContext().getUri(), (String)key);
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestRedirectBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseResponseRedirectBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "get";
        }
    }

    protected class PostBinding
    extends Binding {
        protected PostBinding() {
        }

        @Override
        protected boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder) {
            NodeList nl = documentHolder.getSamlDocument().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            return nl != null && nl.getLength() > 0;
        }

        @Override
        protected void verifySignature(String key, SAMLDocumentHolder documentHolder) throws VerificationException {
            ResponseType responseType;
            List assertions;
            if (!this.containsUnencryptedSignature(documentHolder) && documentHolder.getSamlObject() instanceof ResponseType && !(assertions = (responseType = (ResponseType)documentHolder.getSamlObject()).getAssertions()).isEmpty()) {
                return;
            }
            SamlProtocolUtils.verifyDocumentSignature((Document)documentHolder.getSamlDocument(), (KeyLocator)this.getIDPKeyLocator());
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestPostBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            byte[] samlBytes = PostBindingUtil.base64Decode((String)response);
            return SAMLRequestParser.parseResponseDocument((byte[])samlBytes);
        }

        @Override
        protected String getBindingType() {
            return "post";
        }
    }

    protected abstract class Binding {
        protected Binding() {
        }

        private boolean checkSsl() {
            if (SpidSAMLEndpoint.this.session.getContext().getUri().getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !SpidSAMLEndpoint.this.realm.getSslRequired().isRequired(SpidSAMLEndpoint.this.clientConnection);
        }

        protected Response basicChecks(String samlRequest, String samlResponse) {
            if (!this.checkSsl()) {
                SpidSAMLEndpoint.this.event.event(EventType.LOGIN);
                SpidSAMLEndpoint.this.event.error("ssl_required");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"httpsRequiredMessage", (Object[])new Object[0]);
            }
            if (!SpidSAMLEndpoint.this.realm.isEnabled()) {
                SpidSAMLEndpoint.this.event.event(EventType.LOGIN_ERROR);
                SpidSAMLEndpoint.this.event.error("realm_disabled");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"realmNotEnabledMessage", (Object[])new Object[0]);
            }
            if (samlRequest == null && samlResponse == null) {
                SpidSAMLEndpoint.this.event.event(EventType.LOGIN);
                SpidSAMLEndpoint.this.event.error("invalid_request");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            return null;
        }

        protected abstract String getBindingType();

        protected abstract boolean containsUnencryptedSignature(SAMLDocumentHolder var1);

        protected abstract void verifySignature(String var1, SAMLDocumentHolder var2) throws VerificationException;

        protected abstract SAMLDocumentHolder extractRequestDocument(String var1);

        protected abstract SAMLDocumentHolder extractResponseDocument(String var1);

        protected boolean isDestinationRequired() {
            return true;
        }

        protected KeyLocator getIDPKeyLocator() {
            LinkedList<PublicKey> keys = new LinkedList<PublicKey>();
            for (String signingCertificate : SpidSAMLEndpoint.this.config.getSigningCertificates()) {
                X509Certificate cert = null;
                try {
                    cert = XMLSignatureUtil.getX509CertificateFromKeyInfoString((String)signingCertificate.replaceAll("\\s", ""));
                    cert.checkValidity();
                    keys.add(cert.getPublicKey());
                }
                catch (CertificateException e) {
                    logger.warnf("Ignoring invalid certificate: %s", (Object)cert);
                }
                catch (ProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new HardcodedKeyLocator(keys);
        }

        public Response execute(String samlRequest, String samlResponse, String relayState, String clientId) {
            SpidSAMLEndpoint.this.event = new EventBuilder(SpidSAMLEndpoint.this.realm, SpidSAMLEndpoint.this.session, SpidSAMLEndpoint.this.clientConnection);
            Response response = this.basicChecks(samlRequest, samlResponse);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            return this.handleSamlResponse(samlResponse, relayState, clientId);
        }

        protected Response handleSamlRequest(String samlRequest, String relayState) {
            SAMLDocumentHolder holder = this.extractRequestDocument(samlRequest);
            RequestAbstractType requestAbstractType = (RequestAbstractType)holder.getSamlObject();
            if (this.isDestinationRequired() && requestAbstractType.getDestination() == null && this.containsUnencryptedSignature(holder)) {
                SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SpidSAMLEndpoint.this.event.detail("reason", "missing_required_destination");
                SpidSAMLEndpoint.this.event.error("invalid_request");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            if (!SpidSAMLEndpoint.this.destinationValidator.validate(this.getExpectedDestination(SpidSAMLEndpoint.this.config.getAlias(), null), requestAbstractType.getDestination())) {
                SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SpidSAMLEndpoint.this.event.detail("reason", "invalid_destination");
                SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            if (SpidSAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature("SAMLRequest", holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
            }
            if (requestAbstractType instanceof LogoutRequestType) {
                logger.debug((Object)"** logout request");
                SpidSAMLEndpoint.this.event.event(EventType.LOGOUT);
                LogoutRequestType logout = (LogoutRequestType)requestAbstractType;
                return this.logoutRequest(logout, relayState);
            }
            SpidSAMLEndpoint.this.event.event(EventType.LOGIN);
            SpidSAMLEndpoint.this.event.error("invalid_token");
            return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
        }

        protected Response logoutRequest(LogoutRequestType request, String relayState) {
            String brokerUserId = SpidSAMLEndpoint.this.config.getAlias() + "." + request.getNameID().getValue();
            if (request.getSessionIndex() == null || request.getSessionIndex().isEmpty()) {
                AtomicReference<LogoutRequestType> ref = new AtomicReference<LogoutRequestType>(request);
                SpidSAMLEndpoint.this.session.sessions().getUserSessionByBrokerUserIdStream(SpidSAMLEndpoint.this.realm, brokerUserId).filter(userSession -> userSession.getState() != UserSessionModel.State.LOGGING_OUT && userSession.getState() != UserSessionModel.State.LOGGED_OUT).collect(Collectors.toList()).forEach(this.processLogout(ref));
                request = (LogoutRequestType)ref.get();
            } else {
                for (String sessionIndex : request.getSessionIndex()) {
                    String brokerSessionId = SpidSAMLEndpoint.this.config.getAlias() + "." + sessionIndex;
                    UserSessionModel userSession2 = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)SpidSAMLEndpoint.this.session, () -> SpidSAMLEndpoint.this.session.sessions().getUserSessionByBrokerSessionId(SpidSAMLEndpoint.this.realm, brokerSessionId));
                    if (userSession2 == null || userSession2.getState() == UserSessionModel.State.LOGGING_OUT || userSession2.getState() == UserSessionModel.State.LOGGED_OUT) continue;
                    Iterator it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator((KeycloakSession)SpidSAMLEndpoint.this.session);
                    while (it.hasNext()) {
                        request = ((SamlAuthenticationPreprocessor)it.next()).beforeProcessingLogoutRequest(request, userSession2, null);
                    }
                    try {
                        AuthenticationManager.backchannelLogout((KeycloakSession)SpidSAMLEndpoint.this.session, (RealmModel)SpidSAMLEndpoint.this.realm, (UserSessionModel)userSession2, (UriInfo)SpidSAMLEndpoint.this.session.getContext().getUri(), (ClientConnection)SpidSAMLEndpoint.this.clientConnection, (HttpHeaders)SpidSAMLEndpoint.this.headers, (boolean)false);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                    }
                }
            }
            String issuerURL = this.getEntityId((UriInfo)SpidSAMLEndpoint.this.session.getContext().getUri(), SpidSAMLEndpoint.this.realm);
            SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
            builder.logoutRequestID(request.getID());
            builder.destination(SpidSAMLEndpoint.this.config.getSingleLogoutServiceUrl());
            builder.issuer(issuerURL);
            JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder(SpidSAMLEndpoint.this.session).relayState(relayState);
            boolean postBinding = SpidSAMLEndpoint.this.config.isPostBindingLogout();
            if (SpidSAMLEndpoint.this.config.isWantAuthnRequestsSigned()) {
                KeyManager.ActiveRsaKey keys = SpidSAMLEndpoint.this.session.keys().getActiveRsaKey(SpidSAMLEndpoint.this.realm);
                String keyName = SpidSAMLEndpoint.this.config.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
                ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signatureAlgorithm(SpidSAMLEndpoint.this.provider.getSignatureAlgorithm())).signDocument();
                if (!postBinding && SpidSAMLEndpoint.this.config.isAddExtensionsElementWithKeyInfo()) {
                    builder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
                }
            }
            try {
                if (postBinding) {
                    return binding.postBinding(builder.buildDocument()).response(SpidSAMLEndpoint.this.config.getSingleLogoutServiceUrl());
                }
                return binding.redirectBinding(builder.buildDocument()).response(SpidSAMLEndpoint.this.config.getSingleLogoutServiceUrl());
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private Consumer<UserSessionModel> processLogout(AtomicReference<LogoutRequestType> ref) {
            return userSession -> {
                Iterator it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator((KeycloakSession)SpidSAMLEndpoint.this.session);
                while (it.hasNext()) {
                    ref.set(((SamlAuthenticationPreprocessor)it.next()).beforeProcessingLogoutRequest((LogoutRequestType)ref.get(), userSession, null));
                }
                try {
                    AuthenticationManager.backchannelLogout((KeycloakSession)SpidSAMLEndpoint.this.session, (RealmModel)SpidSAMLEndpoint.this.realm, (UserSessionModel)userSession, (UriInfo)SpidSAMLEndpoint.this.session.getContext().getUri(), (ClientConnection)SpidSAMLEndpoint.this.clientConnection, (HttpHeaders)SpidSAMLEndpoint.this.headers, (boolean)false);
                }
                catch (Exception e) {
                    logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                }
            };
        }

        private String getEntityId(UriInfo uriInfo, RealmModel realm) {
            String configEntityId = SpidSAMLEndpoint.this.config.getEntityId();
            if (configEntityId == null || configEntityId.isEmpty()) {
                return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
            }
            return configEntityId;
        }

        protected Response handleLoginResponse(String samlResponse, SAMLDocumentHolder holder, ResponseType responseType, String relayState, String clientId) {
            try {
                String email;
                boolean assertionIssuerValidationSuccess;
                AssertionType assertion;
                boolean hasNoSignatureWhenRequired;
                boolean responseIssuerValidationSuccess;
                AuthenticationSessionModel authSession = clientId != null && !clientId.trim().isEmpty() ? this.samlIdpInitiatedSSO(clientId) : SpidSAMLEndpoint.this.callback.getAndVerifyAuthenticationSession(relayState);
                SpidSAMLEndpoint.this.session.getContext().setAuthenticationSession(authSession);
                KeyManager.ActiveRsaKey keys = SpidSAMLEndpoint.this.session.keys().getActiveRsaKey(SpidSAMLEndpoint.this.realm);
                if (!this.isSuccessfulSamlResponse(responseType)) {
                    boolean isSpidFault;
                    boolean bl = isSpidFault = responseType.getStatus() != null && responseType.getStatus().getStatusMessage() != null && responseType.getStatus().getStatusMessage().startsWith("ErrorCode nr");
                    if (isSpidFault) {
                        return SpidSAMLEndpoint.this.callback.error("SpidFault_" + responseType.getStatus().getStatusMessage().replace(' ', '_'));
                    }
                    String statusMessage = responseType.getStatus() == null || responseType.getStatus().getStatusMessage() == null ? "identityProviderUnexpectedErrorMessage" : responseType.getStatus().getStatusMessage();
                    return SpidSAMLEndpoint.this.callback.error(statusMessage);
                }
                if (responseType.getAssertions() == null || responseType.getAssertions().isEmpty()) {
                    return SpidSAMLEndpoint.this.callback.error("identityProviderUnexpectedErrorMessage");
                }
                boolean assertionIsEncrypted = AssertionUtil.isAssertionEncrypted((ResponseType)responseType);
                if (SpidSAMLEndpoint.this.config.isWantAssertionsEncrypted() && !assertionIsEncrypted) {
                    logger.error((Object)"The assertion is not encrypted, which is required.");
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                Element assertionElement = assertionIsEncrypted ? AssertionUtil.decryptAssertion((SAMLDocumentHolder)holder, (ResponseType)responseType, (PrivateKey)keys.getPrivateKey()) : DocumentUtil.getElement((Document)holder.getSamlDocument(), (QName)new QName(JBossSAMLConstants.ASSERTION.get()));
                String spidExpectedRequestId = authSession.getClientNote("SAML_REQUEST_ID_BROKER");
                String requestIssueInstant = authSession.getClientNote("SPID_REQUEST_ISSUE_INSTANT");
                String idpEntityId = SpidSAMLEndpoint.this.config.getIdpEntityId();
                String spidResponseValidationError = SpidSAMLEndpoint.this.verifySpidResponse(holder.getSamlDocument().getDocumentElement(), assertionElement, spidExpectedRequestId, requestIssueInstant, idpEntityId);
                if (spidResponseValidationError != null) {
                    logger.error((Object)("SPID Response Validation Error: " + spidResponseValidationError));
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                    if (SpidSAMLEndpoint.this.config.isDebugEnabled()) {
                        return SpidSAMLEndpoint.this.callback.error(spidResponseValidationError);
                    }
                    return SpidSAMLEndpoint.this.callback.error("SpidSamlCheck_GenericError");
                }
                String responseIssuer = responseType.getIssuer() != null ? responseType.getIssuer().getValue() : null;
                boolean bl = responseIssuerValidationSuccess = SpidSAMLEndpoint.this.config.getIdpEntityId() == null || responseIssuer != null && responseIssuer.equals(SpidSAMLEndpoint.this.config.getIdpEntityId());
                if (!responseIssuerValidationSuccess) {
                    logger.errorf("Response Issuer validation failed: expected %s, actual %s", (Object)SpidSAMLEndpoint.this.config.getIdpEntityId(), (Object)responseIssuer);
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                String expectedRequestId = authSession.getClientNote("SAML_REQUEST_ID_BROKER");
                boolean inResponseToValidationSuccess = SpidSAMLEndpoint.this.validateInResponseToAttribute(responseType, expectedRequestId);
                if (!inResponseToValidationSuccess) {
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                boolean signed = AssertionUtil.isSignedElement((Element)assertionElement);
                boolean assertionSignatureNotExistsWhenRequired = SpidSAMLEndpoint.this.config.isWantAssertionsSigned() && !signed;
                boolean signatureNotValid = signed && SpidSAMLEndpoint.this.config.isValidateSignature() && !AssertionUtil.isSignatureValid((Element)assertionElement, (KeyLocator)this.getIDPKeyLocator());
                boolean bl2 = hasNoSignatureWhenRequired = !signed && SpidSAMLEndpoint.this.config.isValidateSignature() && !this.containsUnencryptedSignature(holder);
                if (assertionSignatureNotExistsWhenRequired || signatureNotValid || hasNoSignatureWhenRequired) {
                    logger.error((Object)"validation failed");
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                if (AssertionUtil.isIdEncrypted((ResponseType)responseType)) {
                    AssertionUtil.decryptId((ResponseType)responseType, (PrivateKey)keys.getPrivateKey());
                }
                String assertionIssuer = (assertion = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion()).getIssuer() != null ? assertion.getIssuer().getValue() : null;
                boolean bl3 = assertionIssuerValidationSuccess = SpidSAMLEndpoint.this.config.getIdpEntityId() == null || assertionIssuer != null && assertionIssuer.equals(SpidSAMLEndpoint.this.config.getIdpEntityId());
                if (!assertionIssuerValidationSuccess) {
                    logger.errorf("Assertion Issuer validation failed: expected %s, actual %s", (Object)SpidSAMLEndpoint.this.config.getIdpEntityId(), (Object)assertionIssuer);
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                NameIDType subjectNameID = SpidSAMLEndpoint.this.getSubjectNameID(assertion);
                String principal = SpidSAMLEndpoint.this.getPrincipal(assertion);
                if (principal == null) {
                    logger.errorf("no principal in assertion; expected: %s", (Object)SpidSAMLEndpoint.this.expectedPrincipalType());
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequesterMessage", (Object[])new Object[0]);
                }
                BrokeredIdentityContext identity = new BrokeredIdentityContext(principal);
                identity.getContextData().put(SpidSAMLEndpoint.SAML_LOGIN_RESPONSE, responseType);
                identity.getContextData().put(SpidSAMLEndpoint.SAML_ASSERTION, assertion);
                identity.setAuthenticationSession(authSession);
                identity.setUsername(principal);
                if (subjectNameID != null && subjectNameID.getFormat() != null && subjectNameID.getFormat().toString().equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get())) {
                    identity.setEmail(subjectNameID.getValue());
                }
                if (SpidSAMLEndpoint.this.config.isStoreToken()) {
                    identity.setToken(samlResponse);
                }
                ConditionsValidator.Builder cvb = new ConditionsValidator.Builder(assertion.getID(), (CommonConditionsType)assertion.getConditions(), SpidSAMLEndpoint.this.destinationValidator).clockSkewInMillis(1000 * SpidSAMLEndpoint.this.config.getAllowedClockSkew());
                try {
                    String issuerURL = this.getEntityId((UriInfo)SpidSAMLEndpoint.this.session.getContext().getUri(), SpidSAMLEndpoint.this.realm);
                    cvb.addAllowedAudience(new URI[]{URI.create(issuerURL)});
                    if (responseType.getDestination() != null) {
                        cvb.addAllowedAudience(new URI[]{URI.create(responseType.getDestination())});
                    }
                }
                catch (IllegalArgumentException issuerURL) {
                    // empty catch block
                }
                if (!cvb.build().isValid()) {
                    logger.error((Object)"Assertion expired.");
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, (AuthenticationSessionModel)authSession, (Response.Status)Response.Status.BAD_REQUEST, (String)"expiredCodeMessage", (Object[])new Object[0]);
                }
                AuthnStatementType authn = null;
                for (Object statement : assertion.getStatements()) {
                    if (!(statement instanceof AuthnStatementType)) continue;
                    authn = (AuthnStatementType)statement;
                    identity.getContextData().put(SpidSAMLEndpoint.SAML_AUTHN_STATEMENT, authn);
                    break;
                }
                if (assertion.getAttributeStatements() != null && (email = SpidSAMLEndpoint.this.getX500Attribute(assertion, X500SAMLProfileConstants.EMAIL)) != null) {
                    identity.setEmail(email);
                }
                String brokerUserId = SpidSAMLEndpoint.this.config.getAlias() + "." + principal;
                identity.setBrokerUserId(brokerUserId);
                identity.setIdpConfig((IdentityProviderModel)SpidSAMLEndpoint.this.config);
                identity.setIdp((IdentityProvider)SpidSAMLEndpoint.this.provider);
                if (authn != null && authn.getSessionIndex() != null) {
                    identity.setBrokerSessionId(SpidSAMLEndpoint.this.config.getAlias() + "." + authn.getSessionIndex());
                }
                return SpidSAMLEndpoint.this.callback.authenticated(identity);
            }
            catch (WebApplicationException e) {
                return e.getResponse();
            }
            catch (Exception e) {
                throw new IdentityBrokerException("Could not process response from SAML identity provider.", (Throwable)e);
            }
        }

        private AuthenticationSessionModel samlIdpInitiatedSSO(String clientUrlName) {
            SpidSAMLEndpoint.this.event.event(EventType.LOGIN);
            CacheControlUtil.noBackButtonCacheControlHeader();
            Optional oClient = SpidSAMLEndpoint.this.session.clients().searchClientsByAttributes(SpidSAMLEndpoint.this.realm, Collections.singletonMap("saml_idp_initiated_sso_url_name", clientUrlName), Integer.valueOf(0), Integer.valueOf(1)).findFirst();
            if (!oClient.isPresent()) {
                SpidSAMLEndpoint.this.event.error("client_not_found");
                Response response = ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"clientNotFoundMessage", (Object[])new Object[0]);
                throw new WebApplicationException(response);
            }
            LoginProtocolFactory factory = (LoginProtocolFactory)SpidSAMLEndpoint.this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, "saml");
            SamlService samlService = (SamlService)factory.createProtocolEndpoint(SpidSAMLEndpoint.this.realm, SpidSAMLEndpoint.this.event);
            ResteasyProviderFactory.getInstance().injectProperties((Object)samlService);
            AuthenticationSessionModel authSession = samlService.getOrCreateLoginSessionForIdpInitiatedSso(SpidSAMLEndpoint.this.session, SpidSAMLEndpoint.this.realm, (ClientModel)oClient.get(), null);
            if (authSession == null) {
                SpidSAMLEndpoint.this.event.error("invalid_redirect_uri");
                Response response = ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRedirectUriMessage", (Object[])new Object[0]);
                throw new WebApplicationException(response);
            }
            return authSession;
        }

        private boolean isSuccessfulSamlResponse(ResponseType responseType) {
            return responseType != null && responseType.getStatus() != null && responseType.getStatus().getStatusCode() != null && responseType.getStatus().getStatusCode().getValue() != null && Objects.equals(responseType.getStatus().getStatusCode().getValue().toString(), JBossSAMLURIConstants.STATUS_SUCCESS.get());
        }

        public Response handleSamlResponse(String samlResponse, String relayState, String clientId) {
            SAMLDocumentHolder holder = this.extractResponseDocument(samlResponse);
            if (holder == null) {
                SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SpidSAMLEndpoint.this.event.detail("reason", "invalid_saml_document");
                SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"identityProviderInvalidResponseMessage", (Object[])new Object[0]);
            }
            StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
            if (this.isDestinationRequired() && statusResponse.getDestination() == null && this.containsUnencryptedSignature(holder)) {
                SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SpidSAMLEndpoint.this.event.detail("reason", "missing_required_destination");
                SpidSAMLEndpoint.this.event.error("invalid_logout_response");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            if (!SpidSAMLEndpoint.this.destinationValidator.validate(this.getExpectedDestination(SpidSAMLEndpoint.this.config.getAlias(), clientId), statusResponse.getDestination())) {
                SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SpidSAMLEndpoint.this.event.detail("reason", "invalid_destination");
                SpidSAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"invalidRequestMessage", (Object[])new Object[0]);
            }
            if (SpidSAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature("SAMLResponse", holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    SpidSAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SpidSAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"identityProviderInvalidSignatureMessage", (Object[])new Object[0]);
                }
            }
            if (statusResponse instanceof ResponseType) {
                return this.handleLoginResponse(samlResponse, holder, (ResponseType)statusResponse, relayState, clientId);
            }
            return this.handleLogoutResponse(holder, statusResponse, relayState);
        }

        protected Response handleLogoutResponse(SAMLDocumentHolder holder, StatusResponseType responseType, String relayState) {
            if (relayState == null) {
                logger.error((Object)"no valid user session");
                SpidSAMLEndpoint.this.event.event(EventType.LOGOUT);
                SpidSAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            UserSessionModel userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)SpidSAMLEndpoint.this.session, () -> SpidSAMLEndpoint.this.session.sessions().getUserSession(SpidSAMLEndpoint.this.realm, relayState));
            if (userSession == null) {
                logger.error((Object)"no valid user session");
                SpidSAMLEndpoint.this.event.event(EventType.LOGOUT);
                SpidSAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"identityProviderUnexpectedErrorMessage", (Object[])new Object[0]);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.error((Object)"usersession in different state");
                SpidSAMLEndpoint.this.event.event(EventType.LOGOUT);
                SpidSAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error((KeycloakSession)SpidSAMLEndpoint.this.session, null, (Response.Status)Response.Status.BAD_REQUEST, (String)"sessionNotActiveMessage", (Object[])new Object[0]);
            }
            return AuthenticationManager.finishBrowserLogout((KeycloakSession)SpidSAMLEndpoint.this.session, (RealmModel)SpidSAMLEndpoint.this.realm, (UserSessionModel)userSession, (UriInfo)SpidSAMLEndpoint.this.session.getContext().getUri(), (ClientConnection)SpidSAMLEndpoint.this.clientConnection, (HttpHeaders)SpidSAMLEndpoint.this.headers);
        }

        private String getExpectedDestination(String providerAlias, String clientId) {
            if (clientId != null) {
                return SpidSAMLEndpoint.this.session.getContext().getUri().getAbsolutePath().toString();
            }
            return Urls.identityProviderAuthnResponse((URI)SpidSAMLEndpoint.this.session.getContext().getUri().getBaseUri(), (String)providerAlias, (String)SpidSAMLEndpoint.this.realm.getName()).toString();
        }
    }
}

