/*
 * Decompiled with CFR 0.152.
 */
package net.optionfactory.keycloak.sms.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.optionfactory.keycloak.sms.client.PlaceboSmsClient;
import net.optionfactory.keycloak.sms.client.SmsClient;
import net.optionfactory.keycloak.sms.client.SmsClientFactory;
import net.optionfactory.keycloak.sms.client.SnsSmsClient;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class ConfigurableSmsClientFactory
implements SmsClientFactory {
    private final Logger logger = Logger.getLogger(ConfigurableSmsClientFactory.class);
    private final AtomicReference<CloseableHttpClient> httpClientRef = new AtomicReference();
    private final AtomicReference<SmsClient> clientRef = new AtomicReference();

    public void init(Config.Scope config) {
        String type = config.get("type", "placebo");
        SmsClient.ensure(Set.of("placebo", "sns").contains(type), "type can only be placebo or sns: got %s", type);
        if ("placebo".equals(type)) {
            this.logger.infof("configured a PlaceboSmsClient", new Object[0]);
            this.clientRef.set(new PlaceboSmsClient());
            return;
        }
        String clientId = config.get("clientId");
        SmsClient.ensure(clientId != null, "clientId must be configured", new Object[0]);
        String clientSecret = config.get("clientSecret");
        SmsClient.ensure(clientSecret != null, "clientSecret must be configured", new Object[0]);
        String region = config.get("region", "eu-west-1");
        String senderIdOrNull = config.get("senderId");
        this.logger.infof("ConfigurableSmsClientFactory configured: clientId:%s, clientSecret:%s, region:%s, senderId:%s", new Object[]{clientId, "***hidden***", region, senderIdOrNull});
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build();
            NoopHostnameVerifier hostnameVerifier = new NoopHostnameVerifier();
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(3000).build()).setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).build()).build();
            this.httpClientRef.set(httpClient);
            this.clientRef.set(new SnsSmsClient((HttpClient)httpClient, clientId, clientSecret, region, senderIdOrNull));
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public SmsClient create(KeycloakSession session) {
        return this.clientRef.get();
    }

    public void close() {
        CloseableHttpClient maybeHttpClient = this.httpClientRef.get();
        if (maybeHttpClient == null) {
            return;
        }
        try {
            maybeHttpClient.close();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String getId() {
        return "opfa-sms-client-configurable";
    }
}

